/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.worker;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.uber.m3.tally.Scope;
import com.uber.m3.util.ImmutableMap;
import io.temporal.client.WorkflowClient;
import io.temporal.client.WorkflowClientOptions;
import io.temporal.common.Experimental;
import io.temporal.common.WorkflowExecutionHistory;
import io.temporal.common.context.ContextPropagator;
import io.temporal.internal.sync.WorkflowInternal;
import io.temporal.internal.sync.WorkflowThreadExecutor;
import io.temporal.internal.worker.EagerActivityDispatcher;
import io.temporal.internal.worker.PollerOptions;
import io.temporal.internal.worker.ShutdownManager;
import io.temporal.internal.worker.SingleWorkerOptions;
import io.temporal.internal.worker.SyncActivityWorker;
import io.temporal.internal.worker.SyncNexusWorker;
import io.temporal.internal.worker.SyncWorkflowWorker;
import io.temporal.internal.worker.WorkflowExecutorCache;
import io.temporal.internal.worker.WorkflowRunLockManager;
import io.temporal.serviceclient.WorkflowServiceStubs;
import io.temporal.worker.WorkerFactoryOptions;
import io.temporal.worker.WorkerOptions;
import io.temporal.worker.WorkflowImplementationOptions;
import io.temporal.worker.WorkflowTaskDispatchHandle;
import io.temporal.worker.tuning.ActivitySlotInfo;
import io.temporal.worker.tuning.FixedSizeSlotSupplier;
import io.temporal.worker.tuning.LocalActivitySlotInfo;
import io.temporal.worker.tuning.NexusSlotInfo;
import io.temporal.worker.tuning.ResourceBasedSlotSupplier;
import io.temporal.worker.tuning.SlotSupplier;
import io.temporal.worker.tuning.WorkflowSlotInfo;
import io.temporal.workflow.Functions;
import java.lang.reflect.Type;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Worker {
    private static final Logger log = LoggerFactory.getLogger(Worker.class);
    private final WorkerOptions options;
    private final String taskQueue;
    final SyncWorkflowWorker workflowWorker;
    final SyncActivityWorker activityWorker;
    final SyncNexusWorker nexusWorker;
    private final AtomicBoolean started = new AtomicBoolean();

    Worker(WorkflowClient client, String taskQueue, WorkerFactoryOptions factoryOptions, WorkerOptions options, Scope metricsScope, @Nonnull WorkflowRunLockManager runLocks, @Nonnull WorkflowExecutorCache cache, boolean useStickyTaskQueue, WorkflowThreadExecutor workflowThreadExecutor, List<ContextPropagator> contextPropagators) {
        Objects.requireNonNull(client, "client should not be null");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)taskQueue) ? 1 : 0) != 0, (Object)"taskQueue should not be an empty string");
        this.taskQueue = taskQueue;
        this.options = WorkerOptions.newBuilder(options).validateAndBuildWithDefaults();
        factoryOptions = WorkerFactoryOptions.newBuilder(factoryOptions).validateAndBuildWithDefaults();
        WorkflowServiceStubs service = client.getWorkflowServiceStubs();
        WorkflowClientOptions clientOptions = client.getOptions();
        String namespace = clientOptions.getNamespace();
        ImmutableMap tags = new ImmutableMap.Builder(1).put((Object)"task_queue", (Object)taskQueue).build();
        Scope taggedScope = metricsScope.tagged((Map)tags);
        SingleWorkerOptions activityOptions = Worker.toActivityOptions(factoryOptions, this.options, clientOptions, contextPropagators, taggedScope);
        if (this.options.isLocalActivityWorkerOnly()) {
            this.activityWorker = null;
        } else {
            FixedSizeSlotSupplier<ActivitySlotInfo> activitySlotSupplier = this.options.getWorkerTuner() == null ? new FixedSizeSlotSupplier(this.options.getMaxConcurrentActivityExecutionSize()) : this.options.getWorkerTuner().getActivityTaskSlotSupplier();
            Worker.attachMetricsToResourceController(taggedScope, activitySlotSupplier);
            this.activityWorker = new SyncActivityWorker(service, namespace, taskQueue, this.options.getMaxTaskQueueActivitiesPerSecond(), activityOptions, activitySlotSupplier);
        }
        EagerActivityDispatcher.NoopEagerActivityDispatcher eagerActivityDispatcher = this.activityWorker != null && !this.options.isEagerExecutionDisabled() ? this.activityWorker.getEagerActivityDispatcher() : new EagerActivityDispatcher.NoopEagerActivityDispatcher();
        SingleWorkerOptions nexusOptions = Worker.toNexusOptions(factoryOptions, this.options, clientOptions, contextPropagators, taggedScope);
        FixedSizeSlotSupplier<NexusSlotInfo> nexusSlotSupplier = this.options.getWorkerTuner() == null ? new FixedSizeSlotSupplier(this.options.getMaxConcurrentNexusExecutionSize()) : this.options.getWorkerTuner().getNexusSlotSupplier();
        Worker.attachMetricsToResourceController(taggedScope, nexusSlotSupplier);
        this.nexusWorker = new SyncNexusWorker(client, namespace, taskQueue, nexusOptions, nexusSlotSupplier);
        SingleWorkerOptions singleWorkerOptions = Worker.toWorkflowWorkerOptions(factoryOptions, this.options, clientOptions, taskQueue, contextPropagators, taggedScope);
        SingleWorkerOptions localActivityOptions = Worker.toLocalActivityOptions(factoryOptions, this.options, clientOptions, contextPropagators, taggedScope);
        FixedSizeSlotSupplier<WorkflowSlotInfo> workflowSlotSupplier = this.options.getWorkerTuner() == null ? new FixedSizeSlotSupplier(this.options.getMaxConcurrentWorkflowTaskExecutionSize()) : this.options.getWorkerTuner().getWorkflowTaskSlotSupplier();
        Worker.attachMetricsToResourceController(taggedScope, workflowSlotSupplier);
        FixedSizeSlotSupplier<LocalActivitySlotInfo> localActivitySlotSupplier = this.options.getWorkerTuner() == null ? new FixedSizeSlotSupplier(this.options.getMaxConcurrentLocalActivityExecutionSize()) : this.options.getWorkerTuner().getLocalActivitySlotSupplier();
        Worker.attachMetricsToResourceController(taggedScope, localActivitySlotSupplier);
        this.workflowWorker = new SyncWorkflowWorker(service, namespace, taskQueue, singleWorkerOptions, localActivityOptions, runLocks, cache, useStickyTaskQueue ? Worker.getStickyTaskQueueName(client.getOptions().getIdentity()) : null, workflowThreadExecutor, eagerActivityDispatcher, workflowSlotSupplier, localActivitySlotSupplier);
    }

    public void registerWorkflowImplementationTypes(Class<?> ... workflowImplementationClasses) {
        Preconditions.checkState((!this.started.get() ? 1 : 0) != 0, (Object)"registerWorkflowImplementationTypes is not allowed after worker has started");
        this.workflowWorker.registerWorkflowImplementationTypes(WorkflowImplementationOptions.newBuilder().build(), workflowImplementationClasses);
    }

    public void registerWorkflowImplementationTypes(WorkflowImplementationOptions options, Class<?> ... workflowImplementationClasses) {
        Preconditions.checkState((!this.started.get() ? 1 : 0) != 0, (Object)"registerWorkflowImplementationTypes is not allowed after worker has started");
        this.workflowWorker.registerWorkflowImplementationTypes(options, workflowImplementationClasses);
    }

    @Deprecated
    @VisibleForTesting
    public <R> void addWorkflowImplementationFactory(WorkflowImplementationOptions options, Class<R> workflowInterface, Functions.Func<R> factory) {
        this.registerWorkflowImplementationFactory(workflowInterface, factory, options);
    }

    @Deprecated
    @VisibleForTesting
    public <R> void addWorkflowImplementationFactory(Class<R> workflowInterface, Functions.Func<R> factory) {
        WorkflowImplementationOptions unitTestingOptions = WorkflowImplementationOptions.newBuilder().setFailWorkflowExceptionTypes(Throwable.class).build();
        this.registerWorkflowImplementationFactory(workflowInterface, factory, unitTestingOptions);
    }

    @VisibleForTesting
    public <R> void registerWorkflowImplementationFactory(Class<R> workflowInterface, Functions.Func<R> factory, WorkflowImplementationOptions options) {
        this.workflowWorker.registerWorkflowImplementationFactory(options, workflowInterface, factory);
    }

    @VisibleForTesting
    public <R> void registerWorkflowImplementationFactory(Class<R> workflowInterface, Functions.Func<R> factory) {
        this.workflowWorker.registerWorkflowImplementationFactory(WorkflowImplementationOptions.getDefaultInstance(), workflowInterface, factory);
    }

    public void registerActivitiesImplementations(Object ... activityImplementations) {
        Preconditions.checkState((!this.started.get() ? 1 : 0) != 0, (Object)"registerActivitiesImplementations is not allowed after worker has started");
        if (this.activityWorker != null) {
            this.activityWorker.registerActivityImplementations(activityImplementations);
        }
        this.workflowWorker.registerLocalActivityImplementations(activityImplementations);
    }

    @Experimental
    public void registerNexusServiceImplementation(Object ... nexusServiceImplementations) {
        Preconditions.checkState((!this.started.get() ? 1 : 0) != 0, (Object)"registerNexusServiceImplementation is not allowed after worker has started");
        this.nexusWorker.registerNexusServiceImplementation(nexusServiceImplementations);
    }

    void start() {
        if (!this.started.compareAndSet(false, true)) {
            return;
        }
        this.workflowWorker.start();
        this.nexusWorker.start();
        if (this.activityWorker != null) {
            this.activityWorker.start();
        }
    }

    CompletableFuture<Void> shutdown(ShutdownManager shutdownManager, boolean interruptUserTasks) {
        CompletableFuture<Void> workflowWorkerShutdownFuture = this.workflowWorker.shutdown(shutdownManager, interruptUserTasks);
        CompletableFuture<Void> nexusWorkerShutdownFuture = this.nexusWorker.shutdown(shutdownManager, interruptUserTasks);
        if (this.activityWorker != null) {
            return CompletableFuture.allOf(this.activityWorker.shutdown(shutdownManager, interruptUserTasks), workflowWorkerShutdownFuture, nexusWorkerShutdownFuture);
        }
        return CompletableFuture.allOf(workflowWorkerShutdownFuture, nexusWorkerShutdownFuture);
    }

    boolean isTerminated() {
        boolean isTerminated = this.workflowWorker.isTerminated();
        isTerminated &= this.nexusWorker.isTerminated();
        if (this.activityWorker != null) {
            isTerminated &= this.activityWorker.isTerminated();
        }
        return isTerminated;
    }

    void awaitTermination(long timeout, TimeUnit unit) {
        long timeoutMillis = unit.toMillis(timeout);
        if (this.activityWorker != null) {
            timeoutMillis = ShutdownManager.awaitTermination(this.activityWorker, timeoutMillis);
        }
        timeoutMillis = ShutdownManager.awaitTermination(this.nexusWorker, timeoutMillis);
        ShutdownManager.awaitTermination(this.workflowWorker, timeoutMillis);
    }

    public String toString() {
        return "Worker{options=" + this.options + '}';
    }

    @VisibleForTesting
    public void replayWorkflowExecution(io.temporal.internal.common.WorkflowExecutionHistory history) throws Exception {
        this.workflowWorker.queryWorkflowExecution(history, "__replay_only", String.class, (Type)((Object)String.class), new Object[0]);
    }

    public void replayWorkflowExecution(String jsonSerializedHistory) throws Exception {
        WorkflowExecutionHistory history = WorkflowExecutionHistory.fromJson(jsonSerializedHistory);
        this.replayWorkflowExecution(history);
    }

    public String getTaskQueue() {
        return this.taskQueue;
    }

    public void suspendPolling() {
        this.workflowWorker.suspendPolling();
        this.nexusWorker.suspendPolling();
        if (this.activityWorker != null) {
            this.activityWorker.suspendPolling();
        }
    }

    public void resumePolling() {
        this.workflowWorker.resumePolling();
        this.nexusWorker.resumePolling();
        if (this.activityWorker != null) {
            this.activityWorker.resumePolling();
        }
    }

    public boolean isSuspended() {
        return this.workflowWorker.isSuspended() && this.nexusWorker.isSuspended() && (this.activityWorker == null || this.activityWorker.isSuspended());
    }

    @Nullable
    public WorkflowTaskDispatchHandle reserveWorkflowExecutor() {
        return this.workflowWorker.reserveWorkflowExecutor();
    }

    private static String getStickyTaskQueueName(String workerIdentity) {
        UUID uniqueId = UUID.randomUUID();
        return String.format("%s:%s", workerIdentity, uniqueId);
    }

    public static String getWorkflowType(Class<?> workflowInterfaceClass) {
        return WorkflowInternal.getWorkflowType(workflowInterfaceClass);
    }

    private static SingleWorkerOptions toActivityOptions(WorkerFactoryOptions factoryOptions, WorkerOptions options, WorkflowClientOptions clientOptions, List<ContextPropagator> contextPropagators, Scope metricsScope) {
        return Worker.toSingleWorkerOptions(factoryOptions, options, clientOptions, contextPropagators).setUsingVirtualThreads(options.isUsingVirtualThreadsOnActivityWorker()).setPollerOptions(PollerOptions.newBuilder().setMaximumPollRatePerSecond(options.getMaxWorkerActivitiesPerSecond()).setPollThreadCount(options.getMaxConcurrentActivityTaskPollers()).setUsingVirtualThreads(options.isUsingVirtualThreadsOnActivityWorker()).build()).setMetricsScope(metricsScope).build();
    }

    private static SingleWorkerOptions toNexusOptions(WorkerFactoryOptions factoryOptions, WorkerOptions options, WorkflowClientOptions clientOptions, List<ContextPropagator> contextPropagators, Scope metricsScope) {
        return Worker.toSingleWorkerOptions(factoryOptions, options, clientOptions, contextPropagators).setPollerOptions(PollerOptions.newBuilder().setPollThreadCount(options.getMaxConcurrentNexusTaskPollers()).setUsingVirtualThreads(options.isUsingVirtualThreadsOnNexusWorker()).build()).setMetricsScope(metricsScope).setUsingVirtualThreads(options.isUsingVirtualThreadsOnNexusWorker()).build();
    }

    private static SingleWorkerOptions toWorkflowWorkerOptions(WorkerFactoryOptions factoryOptions, WorkerOptions options, WorkflowClientOptions clientOptions, String taskQueue, List<ContextPropagator> contextPropagators, Scope metricsScope) {
        int maxConcurrentWorkflowTaskPollers;
        ImmutableMap tags = new ImmutableMap.Builder(1).put((Object)"task_queue", (Object)taskQueue).build();
        Duration stickyQueueScheduleToStartTimeout = options.getStickyQueueScheduleToStartTimeout();
        if (WorkerOptions.DEFAULT_STICKY_SCHEDULE_TO_START_TIMEOUT.equals(stickyQueueScheduleToStartTimeout) && factoryOptions.getWorkflowHostLocalTaskQueueScheduleToStartTimeout() != null) {
            stickyQueueScheduleToStartTimeout = factoryOptions.getWorkflowHostLocalTaskQueueScheduleToStartTimeout();
        }
        if ((maxConcurrentWorkflowTaskPollers = options.getMaxConcurrentWorkflowTaskPollers()) == 1) {
            log.warn("WorkerOptions.Builder#setMaxConcurrentWorkflowTaskPollers was set to 1. This is an illegal value. The number of Workflow Task Pollers is forced to 2. See documentation on WorkerOptions.Builder#setMaxConcurrentWorkflowTaskPollers");
            maxConcurrentWorkflowTaskPollers = 2;
        }
        return Worker.toSingleWorkerOptions(factoryOptions, options, clientOptions, contextPropagators).setPollerOptions(PollerOptions.newBuilder().setPollThreadCount(maxConcurrentWorkflowTaskPollers).setUsingVirtualThreads(options.isUsingVirtualThreadsOnWorkflowWorker()).build()).setStickyQueueScheduleToStartTimeout(stickyQueueScheduleToStartTimeout).setStickyTaskQueueDrainTimeout(options.getStickyTaskQueueDrainTimeout()).setUsingVirtualThreads(options.isUsingVirtualThreadsOnWorkflowWorker()).setDefaultDeadlockDetectionTimeout(options.getDefaultDeadlockDetectionTimeout()).setMetricsScope(metricsScope.tagged((Map)tags)).build();
    }

    private static SingleWorkerOptions toLocalActivityOptions(WorkerFactoryOptions factoryOptions, WorkerOptions options, WorkflowClientOptions clientOptions, List<ContextPropagator> contextPropagators, Scope metricsScope) {
        return Worker.toSingleWorkerOptions(factoryOptions, options, clientOptions, contextPropagators).setPollerOptions(PollerOptions.newBuilder().setPollThreadCount(1).build()).setMetricsScope(metricsScope).setUsingVirtualThreads(options.isUsingVirtualThreadsOnLocalActivityWorker()).build();
    }

    private static SingleWorkerOptions.Builder toSingleWorkerOptions(WorkerFactoryOptions factoryOptions, WorkerOptions options, WorkflowClientOptions clientOptions, List<ContextPropagator> contextPropagators) {
        String buildId = null;
        if (options.getBuildId() != null) {
            buildId = options.getBuildId();
        } else if (clientOptions.getBinaryChecksum() != null) {
            buildId = clientOptions.getBinaryChecksum();
        }
        String identity = clientOptions.getIdentity();
        if (options.getIdentity() != null) {
            identity = options.getIdentity();
        }
        return SingleWorkerOptions.newBuilder().setDataConverter(clientOptions.getDataConverter()).setIdentity(identity).setBuildId(buildId).setUseBuildIdForVersioning(options.isUsingBuildIdForVersioning()).setEnableLoggingInReplay(factoryOptions.isEnableLoggingInReplay()).setContextPropagators(contextPropagators).setWorkerInterceptors(factoryOptions.getWorkerInterceptors()).setMaxHeartbeatThrottleInterval(options.getMaxHeartbeatThrottleInterval()).setDefaultHeartbeatThrottleInterval(options.getDefaultHeartbeatThrottleInterval());
    }

    private static void attachMetricsToResourceController(Scope metricsScope, SlotSupplier<?> supplier) {
        if (supplier instanceof ResourceBasedSlotSupplier) {
            ((ResourceBasedSlotSupplier)supplier).getResourceController().setMetricsScope(metricsScope);
        }
    }
}

