/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.nexus;

import io.nexusrpc.handler.OperationHandler;
import io.temporal.common.Experimental;
import io.temporal.internal.nexus.CurrentNexusOperationContext;
import io.temporal.internal.nexus.NexusOperationContextImpl;
import io.temporal.nexus.RunWorkflowOperation;
import io.temporal.nexus.SynchronousWorkflowClientOperationFunction;
import io.temporal.nexus.WorkflowHandle;
import io.temporal.nexus.WorkflowHandleFactory;
import io.temporal.nexus.WorkflowMethodFactory;

@Experimental
public final class WorkflowClientOperationHandlers {
    public static <T, R> OperationHandler<T, R> sync(SynchronousWorkflowClientOperationFunction<T, R> func) {
        return OperationHandler.sync((ctx, details, input) -> {
            NexusOperationContextImpl nexusCtx = CurrentNexusOperationContext.get();
            return func.apply(ctx, details, nexusCtx.getWorkflowClient(), input);
        });
    }

    public static <T, R> OperationHandler<T, R> fromWorkflowMethod(WorkflowMethodFactory<T, R> startMethod) {
        return new RunWorkflowOperation((context, details, client, input) -> WorkflowHandle.fromWorkflowMethod(startMethod.apply(context, details, client, input), input));
    }

    public static <T, R> OperationHandler<T, R> fromWorkflowHandle(WorkflowHandleFactory<T, R> handleFactory) {
        return new RunWorkflowOperation<T, R>(handleFactory);
    }

    private WorkflowClientOperationHandlers() {
    }
}

