/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.nexus;

import io.nexusrpc.OperationInfo;
import io.nexusrpc.OperationUnsuccessfulException;
import io.nexusrpc.handler.OperationCancelDetails;
import io.nexusrpc.handler.OperationContext;
import io.nexusrpc.handler.OperationFetchInfoDetails;
import io.nexusrpc.handler.OperationFetchResultDetails;
import io.nexusrpc.handler.OperationHandler;
import io.nexusrpc.handler.OperationHandlerException;
import io.nexusrpc.handler.OperationMiddleware;
import io.nexusrpc.handler.OperationStartDetails;
import io.nexusrpc.handler.OperationStartResult;
import io.temporal.common.interceptors.NexusOperationInboundCallsInterceptor;
import io.temporal.common.interceptors.WorkerInterceptor;
import io.temporal.internal.nexus.CurrentNexusOperationContext;
import io.temporal.internal.nexus.RootNexusOperationInboundCallsInterceptor;
import io.temporal.internal.nexus.RootNexusOperationOutboundCallsInterceptor;

public class TemporalInterceptorMiddleware
implements OperationMiddleware {
    private final WorkerInterceptor[] interceptors;
    RootNexusOperationInboundCallsInterceptor rootInboundCallsInterceptor;

    public TemporalInterceptorMiddleware(WorkerInterceptor[] interceptors) {
        this.interceptors = interceptors;
    }

    public OperationHandler<Object, Object> intercept(OperationContext context, OperationHandler<Object, Object> operationHandler) {
        NexusOperationInboundCallsInterceptor inboundCallsInterceptor = this.rootInboundCallsInterceptor = new RootNexusOperationInboundCallsInterceptor(operationHandler);
        for (WorkerInterceptor interceptor : this.interceptors) {
            inboundCallsInterceptor = interceptor.interceptNexusOperation(context, inboundCallsInterceptor);
        }
        inboundCallsInterceptor.init(new RootNexusOperationOutboundCallsInterceptor(CurrentNexusOperationContext.get().getMetricsScope()));
        return new OperationInterceptorConverter(inboundCallsInterceptor);
    }

    static class OperationInterceptorConverter
    implements OperationHandler<Object, Object> {
        private final NexusOperationInboundCallsInterceptor next;

        public OperationInterceptorConverter(NexusOperationInboundCallsInterceptor next) {
            this.next = next;
        }

        public OperationStartResult<Object> start(OperationContext operationContext, OperationStartDetails operationStartDetails, Object o) throws OperationUnsuccessfulException {
            return this.next.startOperation(new NexusOperationInboundCallsInterceptor.StartOperationInput(operationContext, operationStartDetails, o)).getResult();
        }

        public Object fetchResult(OperationContext operationContext, OperationFetchResultDetails operationFetchResultDetails) throws OperationHandlerException {
            throw new UnsupportedOperationException("Not implemented");
        }

        public OperationInfo fetchInfo(OperationContext operationContext, OperationFetchInfoDetails operationFetchInfoDetails) throws OperationHandlerException {
            throw new UnsupportedOperationException("Not implemented");
        }

        public void cancel(OperationContext operationContext, OperationCancelDetails operationCancelDetails) {
            this.next.cancelOperation(new NexusOperationInboundCallsInterceptor.CancelOperationInput(operationContext, operationCancelDetails));
        }
    }
}

