/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.common;

import com.google.common.base.Defaults;
import io.temporal.api.common.v1.Callback;
import io.temporal.api.common.v1.Link;
import io.temporal.api.enums.v1.TaskQueueKind;
import io.temporal.api.nexus.v1.Link;
import io.temporal.api.taskqueue.v1.TaskQueue;
import io.temporal.client.WorkflowOptions;
import io.temporal.client.WorkflowStub;
import io.temporal.internal.client.NexusStartWorkflowRequest;
import io.temporal.internal.common.LinkConverter;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InternalUtils {
    private static final Logger log = LoggerFactory.getLogger(InternalUtils.class);

    public static TaskQueue createStickyTaskQueue(String stickyTaskQueueName, String normalTaskQueueName) {
        return TaskQueue.newBuilder().setName(stickyTaskQueueName).setKind(TaskQueueKind.TASK_QUEUE_KIND_STICKY).setNormalName(normalTaskQueueName).build();
    }

    public static TaskQueue createNormalTaskQueue(String taskQueueName) {
        return TaskQueue.newBuilder().setName(taskQueueName).setKind(TaskQueueKind.TASK_QUEUE_KIND_NORMAL).build();
    }

    public static Object getValueOrDefault(Object value, Class<?> valueClass) {
        if (value != null) {
            return value;
        }
        return Defaults.defaultValue(valueClass);
    }

    public static WorkflowStub createNexusBoundStub(WorkflowStub stub, NexusStartWorkflowRequest request) {
        if (!stub.getOptions().isPresent()) {
            throw new IllegalArgumentException("Options are expected to be set on the stub");
        }
        WorkflowOptions options = stub.getOptions().get();
        if (options.getWorkflowId() == null) {
            throw new IllegalArgumentException("WorkflowId is expected to be set on WorkflowOptions when used with Nexus");
        }
        Map headers = request.getCallbackHeaders().entrySet().stream().collect(Collectors.toMap(k -> ((String)k.getKey()).toLowerCase(), Map.Entry::getValue, (a, b) -> a, () -> new TreeMap(String.CASE_INSENSITIVE_ORDER)));
        if (!headers.containsKey("Nexus-Operation-Id")) {
            headers.put("Nexus-Operation-Id".toLowerCase(), options.getWorkflowId());
        }
        WorkflowOptions.Builder nexusWorkflowOptions = WorkflowOptions.newBuilder(options).setRequestId(request.getRequestId()).setCompletionCallbacks(Arrays.asList(Callback.newBuilder().setNexus(Callback.Nexus.newBuilder().setUrl(request.getCallbackUrl()).putAllHeader(headers).build()).build()));
        if (options.getTaskQueue() == null) {
            nexusWorkflowOptions.setTaskQueue(request.getTaskQueue());
        }
        if (request.getLinks() != null) {
            nexusWorkflowOptions.setLinks(request.getLinks().stream().map(link -> {
                if (Link.WorkflowEvent.getDescriptor().getFullName().equals(link.getType())) {
                    Link nexusLink = Link.newBuilder().setType(link.getType()).setUrl(link.getUri().toString()).build();
                    return LinkConverter.nexusLinkToWorkflowEvent(nexusLink);
                }
                log.warn("ignoring unsupported link data type: {}", (Object)link.getType());
                return null;
            }).filter(link -> link != null).collect(Collectors.toList()));
        }
        return stub.newInstance(nexusWorkflowOptions.build());
    }

    private InternalUtils() {
    }
}

