/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.common.metadata;

import io.temporal.common.metadata.POJOWorkflowMethod;
import io.temporal.common.metadata.POJOWorkflowMethodMetadata;
import io.temporal.common.metadata.WorkflowMethodType;
import io.temporal.workflow.UpdateValidatorMethod;
import io.temporal.workflow.WorkflowInterface;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public final class POJOWorkflowInterfaceMetadata {
    private POJOWorkflowMethodMetadata workflowMethod;
    private final Class<?> interfaceClass;
    private final Map<Method, POJOWorkflowMethodMetadata> methods = new HashMap<Method, POJOWorkflowMethodMetadata>();

    @Deprecated
    public static POJOWorkflowInterfaceMetadata newInstanceSkipWorkflowAnnotationCheck(Class<?> anInterface) {
        return POJOWorkflowInterfaceMetadata.newInstance(anInterface, false);
    }

    public static POJOWorkflowInterfaceMetadata newInstance(Class<?> anInterface) {
        return POJOWorkflowInterfaceMetadata.newInstanceInternal(anInterface, true, true);
    }

    public static POJOWorkflowInterfaceMetadata newInstance(Class<?> anInterface, boolean validateWorkflowAnnotation) {
        return POJOWorkflowInterfaceMetadata.newInstanceInternal(anInterface, validateWorkflowAnnotation, true);
    }

    static POJOWorkflowInterfaceMetadata newImplementationInstance(Class<?> anInterface, boolean forceProcessWorkflowMethods) {
        return POJOWorkflowInterfaceMetadata.newInstanceInternal(anInterface, false, forceProcessWorkflowMethods);
    }

    private static POJOWorkflowInterfaceMetadata newInstanceInternal(Class<?> anInterface, boolean validateWorkflowAnnotation, boolean forceProcessWorkflowMethods) {
        if (!anInterface.isInterface()) {
            throw new IllegalArgumentException("Not an interface: " + anInterface);
        }
        if (validateWorkflowAnnotation) {
            WorkflowInterface annotation = anInterface.getAnnotation(WorkflowInterface.class);
            if (annotation == null) {
                throw new IllegalArgumentException("Missing required @WorkflowInterface annotation: " + anInterface);
            }
            POJOWorkflowInterfaceMetadata.validateModifierAccess(anInterface);
        }
        POJOWorkflowInterfaceMetadata result = new POJOWorkflowInterfaceMetadata(anInterface, forceProcessWorkflowMethods);
        if (result.methods.isEmpty() && validateWorkflowAnnotation) {
            throw new IllegalArgumentException("Interface doesn't contain any methods: " + anInterface.getName());
        }
        HashMap<String, POJOWorkflowMethodMetadata> updateMethods = new HashMap<String, POJOWorkflowMethodMetadata>();
        for (POJOWorkflowMethodMetadata methodMetadata : result.methods.values()) {
            if (methodMetadata.getType() != WorkflowMethodType.UPDATE) continue;
            updateMethods.put(methodMetadata.getName(), methodMetadata);
        }
        for (POJOWorkflowMethodMetadata methodMetadata : result.methods.values()) {
            if (methodMetadata.getType() != WorkflowMethodType.UPDATE_VALIDATOR) continue;
            UpdateValidatorMethod validator = methodMetadata.getWorkflowMethod().getAnnotation(UpdateValidatorMethod.class);
            POJOWorkflowMethodMetadata update = (POJOWorkflowMethodMetadata)updateMethods.get(validator.updateName());
            if (update == null) {
                throw new IllegalArgumentException("Missing @UpdateMethod with name \"" + validator.updateName() + "\" for @UpdateValidatorMethod \"" + methodMetadata.getWorkflowMethod().getName() + "\"");
            }
            if (Arrays.equals(update.getWorkflowMethod().getGenericParameterTypes(), methodMetadata.getWorkflowMethod().getGenericParameterTypes())) continue;
            throw new IllegalArgumentException("Update method \"" + update.getWorkflowMethod().getName() + "\" and Validator method \"" + methodMetadata.getWorkflowMethod().getName() + "\" do not have the same parameters");
        }
        return result;
    }

    private POJOWorkflowInterfaceMetadata(Class<?> anInterface, boolean forceProcessWorkflowMethods) {
        this.interfaceClass = anInterface;
        HashMap<EqualsByName, Method> dedupeMap = new HashMap<EqualsByName, Method>();
        this.getWorkflowInterfaceMethods(anInterface, forceProcessWorkflowMethods, dedupeMap);
    }

    public Optional<POJOWorkflowMethodMetadata> getWorkflowMethod() {
        return Optional.ofNullable(this.workflowMethod);
    }

    public Class<?> getInterfaceClass() {
        return this.interfaceClass;
    }

    public Optional<String> getWorkflowType() {
        if (this.workflowMethod == null) {
            return Optional.empty();
        }
        return Optional.of(this.workflowMethod.getName());
    }

    public POJOWorkflowMethodMetadata getMethodMetadata(Method method) {
        POJOWorkflowMethodMetadata result = this.methods.get(method);
        if (result == null) {
            throw new IllegalArgumentException("Unknown method: " + method);
        }
        return result;
    }

    public List<POJOWorkflowMethodMetadata> getMethodsMetadata() {
        return new ArrayList<POJOWorkflowMethodMetadata>(this.methods.values());
    }

    private Set<POJOWorkflowMethod> getWorkflowInterfaceMethods(Class<?> current, boolean forceProcessWorkflowMethods, Map<EqualsByName, Method> dedupeMap) {
        Class<?>[] interfaces;
        boolean isCurrentAWorkflowInterface;
        WorkflowInterface annotation = current.getAnnotation(WorkflowInterface.class);
        boolean bl = isCurrentAWorkflowInterface = annotation != null;
        if (isCurrentAWorkflowInterface) {
            POJOWorkflowInterfaceMetadata.validateModifierAccess(current);
        }
        HashSet<POJOWorkflowMethod> result = new HashSet<POJOWorkflowMethod>();
        for (Class<?> anInterface : interfaces = current.getInterfaces()) {
            Set<POJOWorkflowMethod> parentMethods = this.getWorkflowInterfaceMethods(anInterface, false, dedupeMap);
            POJOWorkflowInterfaceMetadata.addParentMethods(parentMethods, current, result);
        }
        Method[] declaredMethods = current.getDeclaredMethods();
        for (Method declaredMethod : declaredMethods) {
            POJOWorkflowMethod methodMetadata = new POJOWorkflowMethod(declaredMethod);
            if (!POJOWorkflowInterfaceMetadata.validateAndQualifiedForWorkflowMethod(methodMetadata)) continue;
            result.add(methodMetadata);
        }
        if (isCurrentAWorkflowInterface || forceProcessWorkflowMethods) {
            for (POJOWorkflowMethod workflowMethod : result) {
                if (workflowMethod.getType() != WorkflowMethodType.NONE) {
                    POJOWorkflowInterfaceMetadata.dedupeAndAdd(workflowMethod, dedupeMap);
                    POJOWorkflowMethodMetadata methodMetadata = new POJOWorkflowMethodMetadata(workflowMethod, current);
                    this.methods.put(workflowMethod.getMethod(), methodMetadata);
                    if (workflowMethod.getType() != WorkflowMethodType.WORKFLOW) continue;
                    if (this.workflowMethod != null) {
                        throw new IllegalArgumentException("Duplicated @WorkflowMethod: " + workflowMethod.getMethod() + " and " + this.workflowMethod.getWorkflowMethod());
                    }
                    this.workflowMethod = methodMetadata;
                    continue;
                }
                if (!isCurrentAWorkflowInterface) continue;
                throw new IllegalArgumentException("Missing @WorkflowMethod, @SignalMethod or @QueryMethod annotation on " + workflowMethod.getMethod());
            }
            return Collections.emptySet();
        }
        return result;
    }

    private static void dedupeAndAdd(POJOWorkflowMethod workflowMethod, Map<EqualsByName, Method> dedupeMap) {
        Method method = workflowMethod.getMethod();
        EqualsByName wrapped = new EqualsByName(method, workflowMethod.getNameFromAnnotation().orElse(null));
        Method registeredBefore = dedupeMap.put(wrapped, method);
        if (registeredBefore != null && !registeredBefore.equals(method)) {
            throw new IllegalArgumentException("Duplicated methods (overloads are not allowed in workflow interfaces): \"" + registeredBefore + "\" and \"" + method + "\"");
        }
    }

    private static void addParentMethods(Set<POJOWorkflowMethod> parentMethods, Class<?> currentInterface, Set<POJOWorkflowMethod> toSet) {
        for (POJOWorkflowMethod parentMethod : parentMethods) {
            if (parentMethod.getType() == WorkflowMethodType.NONE) {
                Method method = parentMethod.getMethod();
                try {
                    currentInterface.getMethod(method.getName(), method.getParameterTypes());
                }
                catch (NoSuchMethodException e) {
                    toSet.add(parentMethod);
                }
                continue;
            }
            toSet.add(parentMethod);
        }
    }

    private static void validateModifierAccess(Class<?> workflowInterface) {
        if (!Modifier.isPublic(workflowInterface.getModifiers())) {
            throw new IllegalArgumentException("Interface with @WorkflowInterface annotation must be public: " + workflowInterface);
        }
    }

    private static boolean validateAndQualifiedForWorkflowMethod(POJOWorkflowMethod workflowMethod) {
        boolean isAnnotatedWorkflowMethod;
        Method method = workflowMethod.getMethod();
        boolean bl = isAnnotatedWorkflowMethod = !workflowMethod.getType().equals((Object)WorkflowMethodType.NONE);
        if (Modifier.isStatic(method.getModifiers())) {
            if (isAnnotatedWorkflowMethod) {
                throw new IllegalArgumentException("Workflow Method can't be static: " + method);
            }
            return false;
        }
        if (isAnnotatedWorkflowMethod) {
            return true;
        }
        return !method.isSynthetic();
    }

    private static class EqualsByName {
        private final Method method;
        private final String nameFromAnnotation;

        EqualsByName(Method method, String nameFromAnnotation) {
            this.method = method;
            this.nameFromAnnotation = nameFromAnnotation;
        }

        public Method getMethod() {
            return this.method;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EqualsByName that = (EqualsByName)o;
            return this.method.equals(that.method) && Objects.equals(this.nameFromAnnotation, that.nameFromAnnotation);
        }

        public int hashCode() {
            return Objects.hash(this.method, this.nameFromAnnotation);
        }
    }
}

