/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.worker;

import io.temporal.internal.worker.CircularLongBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class Throttler {
    private static final Logger log = LoggerFactory.getLogger(Throttler.class);
    private final String name;
    private CircularLongBuffer checkPointTimes;
    private long index;
    private long rateInterval;
    private final long rateIntervalMilliseconds;
    private long overslept;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Throttler(String name, double maxRatePerSecond, long rateIntervalMilliseconds) {
        if (null == name) {
            throw new IllegalArgumentException("null name");
        }
        this.name = name;
        if (maxRatePerSecond <= 0.0) {
            throw new IllegalArgumentException("0 or negative maxRatePerSecond");
        }
        if (rateIntervalMilliseconds <= 0L) {
            throw new IllegalArgumentException("0 or negative rateIntervalMilliseconds");
        }
        Throttler throttler = this;
        synchronized (throttler) {
            this.rateIntervalMilliseconds = rateIntervalMilliseconds;
            this.setMaxRatePerSecond(maxRatePerSecond);
        }
    }

    public synchronized void setMaxRatePerSecond(double maxRatePerSecond) {
        int maxMessagesPerRateInterval = (int)(maxRatePerSecond * (double)this.rateIntervalMilliseconds / 1000.0);
        if (maxMessagesPerRateInterval == 0) {
            maxMessagesPerRateInterval = 1;
            this.rateInterval = (long)(1.0 / maxRatePerSecond * 1000.0);
        } else {
            this.rateInterval = this.rateIntervalMilliseconds;
        }
        if (this.checkPointTimes != null) {
            int oldSize = this.checkPointTimes.size();
            this.checkPointTimes = this.checkPointTimes.copy(this.index - (long)maxMessagesPerRateInterval, maxMessagesPerRateInterval);
            this.index = Math.min(this.checkPointTimes.size(), oldSize);
        } else {
            this.checkPointTimes = new CircularLongBuffer(maxMessagesPerRateInterval);
            this.index = 0L;
        }
        log.debug("new rate=" + maxRatePerSecond + " (msg/sec)");
    }

    public synchronized void throttle(int count) throws InterruptedException {
        for (int i = 0; i < count; ++i) {
            this.throttle();
        }
    }

    public synchronized void throttle() throws InterruptedException {
        long elapsed;
        long now = System.currentTimeMillis();
        long checkPoint = this.checkPointTimes.get(this.index);
        if (checkPoint > 0L && (elapsed = now - checkPoint) >= 0L && elapsed < this.rateInterval) {
            long sleepInterval = this.rateInterval - elapsed - this.overslept;
            this.overslept = 0L;
            if (sleepInterval > 0L) {
                if (log.isTraceEnabled()) {
                    log.debug("Throttling " + this.name + ": called " + this.checkPointTimes.size() + " times in last " + elapsed + " milliseconds. Going to sleep for " + sleepInterval + " milliseconds.");
                }
                long t = System.currentTimeMillis();
                Thread.sleep(sleepInterval);
                this.overslept = System.currentTimeMillis() - t - sleepInterval;
            }
        }
        this.checkPointTimes.set(this.index++, System.currentTimeMillis());
    }
}

