/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.worker;

import io.temporal.client.WorkflowClient;
import io.temporal.internal.nexus.NexusTaskHandlerImpl;
import io.temporal.internal.worker.NexusWorker;
import io.temporal.internal.worker.ShutdownManager;
import io.temporal.internal.worker.SingleWorkerOptions;
import io.temporal.internal.worker.SuspendableWorker;
import io.temporal.internal.worker.WorkerLifecycleState;
import io.temporal.worker.tuning.NexusSlotInfo;
import io.temporal.worker.tuning.SlotSupplier;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncNexusWorker
implements SuspendableWorker {
    private static final Logger log = LoggerFactory.getLogger(SyncNexusWorker.class);
    private final String identity;
    private final String namespace;
    private final String taskQueue;
    private final NexusTaskHandlerImpl taskHandler;
    private final NexusWorker worker;

    public SyncNexusWorker(WorkflowClient client, String namespace, String taskQueue, SingleWorkerOptions options, SlotSupplier<NexusSlotInfo> slotSupplier) {
        this.identity = options.getIdentity();
        this.namespace = namespace;
        this.taskQueue = taskQueue;
        this.taskHandler = new NexusTaskHandlerImpl(client, namespace, taskQueue, options.getDataConverter());
        this.worker = new NexusWorker(client.getWorkflowServiceStubs(), namespace, taskQueue, options, this.taskHandler, slotSupplier);
    }

    @Override
    public CompletableFuture<Void> shutdown(ShutdownManager shutdownManager, boolean interruptTasks) {
        return ((CompletableFuture)this.worker.shutdown(shutdownManager, interruptTasks).thenCompose(r -> this.taskHandler.shutdown(shutdownManager, interruptTasks))).exceptionally(e -> {
            log.error("[BUG] Unexpected exception during shutdown", e);
            return null;
        });
    }

    @Override
    public void awaitTermination(long timeout, TimeUnit unit) {
        long timeoutMillis = unit.toMillis(timeout);
        ShutdownManager.awaitTermination(this.worker, timeoutMillis);
    }

    @Override
    public boolean start() {
        return this.worker.start();
    }

    @Override
    public void suspendPolling() {
        this.worker.suspendPolling();
    }

    @Override
    public void resumePolling() {
        this.worker.resumePolling();
    }

    @Override
    public boolean isSuspended() {
        return this.worker.isSuspended();
    }

    @Override
    public boolean isShutdown() {
        return this.worker.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.worker.isTerminated();
    }

    @Override
    public WorkerLifecycleState getLifecycleState() {
        return this.worker.getLifecycleState();
    }

    public String toString() {
        return String.format("SyncNexusWorker{namespace=%s, taskQueue=%s, identity=%s}", this.namespace, this.taskQueue, this.identity);
    }

    public void registerNexusServiceImplementation(Object ... nexusServiceImplementations) {
        this.taskHandler.registerNexusServiceImplementations(nexusServiceImplementations);
    }
}

