/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.nexus;

import io.temporal.internal.nexus.NexusOperationContextImpl;

public final class CurrentNexusOperationContext {
    private static final ThreadLocal<NexusOperationContextImpl> CURRENT = new ThreadLocal();

    public static NexusOperationContextImpl get() {
        NexusOperationContextImpl result = CURRENT.get();
        if (result == null) {
            throw new IllegalStateException("NexusOperationContext can be used only inside of nexus operation handler implementation methods and in the same thread that invoked the operation.");
        }
        return CURRENT.get();
    }

    public static void set(NexusOperationContextImpl context) {
        if (context == null) {
            throw new IllegalArgumentException("null context");
        }
        if (CURRENT.get() != null) {
            throw new IllegalStateException("current already set");
        }
        CURRENT.set(context);
    }

    public static void unset() {
        CURRENT.set(null);
    }

    private CurrentNexusOperationContext() {
    }
}

