/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.common.metadata;

import com.google.common.base.Objects;
import com.uber.m3.util.ImmutableList;
import io.temporal.activity.ActivityInterface;
import io.temporal.activity.ActivityMethod;
import io.temporal.common.metadata.POJOActivityMethodMetadata;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;

public final class POJOActivityInterfaceMetadata {
    private final Class<?> interfaceClass;
    private final Map<Method, POJOActivityMethodMetadata> methods = new HashMap<Method, POJOActivityMethodMetadata>();

    public static POJOActivityInterfaceMetadata newInstance(Class<?> anInterface) {
        if (!anInterface.isInterface()) {
            throw new IllegalArgumentException("Interface expected: " + anInterface);
        }
        ActivityInterface annotation = anInterface.getAnnotation(ActivityInterface.class);
        if (annotation == null) {
            throw new IllegalArgumentException("Missing required @ActivityInterface annotation: " + anInterface);
        }
        POJOActivityInterfaceMetadata.validateModifierAccess(anInterface);
        POJOActivityInterfaceMetadata result = new POJOActivityInterfaceMetadata(anInterface);
        if (result.methods.isEmpty()) {
            throw new IllegalArgumentException("Interface doesn't contain any methods: " + anInterface.getName());
        }
        return result;
    }

    static POJOActivityInterfaceMetadata newImplementationInterface(Class<?> anInterface) {
        return new POJOActivityInterfaceMetadata(anInterface);
    }

    private POJOActivityInterfaceMetadata(Class<?> anInterface) {
        if (!anInterface.isInterface()) {
            throw new IllegalArgumentException("not an interface: " + anInterface);
        }
        this.interfaceClass = anInterface;
        HashMap<EqualsByMethodName, POJOActivityMethodMetadata> dedupeMap = new HashMap<EqualsByMethodName, POJOActivityMethodMetadata>();
        POJOActivityInterfaceMetadata.getActivityInterfaceMethods(anInterface, dedupeMap);
        dedupeMap.forEach((k, v) -> this.methods.put(k.getMethod(), (POJOActivityMethodMetadata)v));
    }

    public Class<?> getInterfaceClass() {
        return this.interfaceClass;
    }

    public List<POJOActivityMethodMetadata> getMethodsMetadata() {
        return new ImmutableList(this.methods.values());
    }

    @Nonnull
    public POJOActivityMethodMetadata getMethodMetadata(Method method) {
        POJOActivityMethodMetadata result = this.methods.get(method);
        if (result == null) {
            throw new IllegalArgumentException("Unknown method: " + method);
        }
        return result;
    }

    private static Set<Method> getActivityInterfaceMethods(Class<?> current, Map<EqualsByMethodName, POJOActivityMethodMetadata> dedupeMap) {
        Method[] declaredMethods;
        Class<?>[] interfaces;
        boolean isCurrentAnActivityInterface;
        ActivityInterface annotation = current.getAnnotation(ActivityInterface.class);
        boolean bl = isCurrentAnActivityInterface = annotation != null;
        if (isCurrentAnActivityInterface) {
            POJOActivityInterfaceMetadata.validateModifierAccess(current);
        }
        HashSet<Method> result = new HashSet<Method>();
        for (Class<?> anInterface : interfaces = current.getInterfaces()) {
            Set<Method> parentMethods = POJOActivityInterfaceMetadata.getActivityInterfaceMethods(anInterface, dedupeMap);
            POJOActivityInterfaceMetadata.addParentMethods(parentMethods, current, result);
        }
        for (Method declaredMethod : declaredMethods = current.getDeclaredMethods()) {
            if (!POJOActivityInterfaceMetadata.validateAndQualifiedForActivityMethod(declaredMethod)) continue;
            result.add(declaredMethod);
        }
        if (isCurrentAnActivityInterface) {
            result.stream().map(method -> new POJOActivityMethodMetadata((Method)method, current, annotation)).forEach(methodMetadata -> POJOActivityInterfaceMetadata.dedupeAndAdd(methodMetadata, dedupeMap));
            return Collections.emptySet();
        }
        return result;
    }

    private static void dedupeAndAdd(POJOActivityMethodMetadata methodMetadata, Map<EqualsByMethodName, POJOActivityMethodMetadata> toDedupeMap) {
        EqualsByMethodName wrapped = new EqualsByMethodName(methodMetadata.getMethod());
        POJOActivityMethodMetadata registeredBefore = toDedupeMap.put(wrapped, methodMetadata);
        if (registeredBefore != null) {
            throw new IllegalArgumentException("Duplicated methods (overloads are not allowed in activity interfaces): \"" + registeredBefore.getMethod() + " through \"" + registeredBefore.getInterfaceType() + "\" and \"" + methodMetadata.getMethod() + "\" through \"" + methodMetadata.getInterfaceType() + "\"");
        }
    }

    private static void addParentMethods(Set<Method> parentMethods, Class<?> currentInterface, Set<Method> toSet) {
        for (Method parentMethod : parentMethods) {
            ActivityMethod activityMethod = parentMethod.getAnnotation(ActivityMethod.class);
            if (activityMethod == null) {
                try {
                    Method method = currentInterface.getDeclaredMethod(parentMethod.getName(), parentMethod.getParameterTypes());
                }
                catch (NoSuchMethodException e) {
                    toSet.add(parentMethod);
                }
                continue;
            }
            toSet.add(parentMethod);
        }
    }

    private static void validateModifierAccess(Class<?> activityInterface) {
        if (!Modifier.isPublic(activityInterface.getModifiers())) {
            throw new IllegalArgumentException("Interface with @ActivityInterface annotation must be public: " + activityInterface);
        }
    }

    private static boolean validateAndQualifiedForActivityMethod(Method method) {
        boolean isAnnotatedActivityMethod;
        boolean bl = isAnnotatedActivityMethod = method.getAnnotation(ActivityMethod.class) != null;
        if (Modifier.isStatic(method.getModifiers())) {
            if (isAnnotatedActivityMethod) {
                throw new IllegalArgumentException("Method with @ActivityMethod annotation can't be static: " + method);
            }
            return false;
        }
        if (isAnnotatedActivityMethod) {
            return true;
        }
        return !method.isSynthetic();
    }

    private static class EqualsByMethodName {
        private final Method method;

        EqualsByMethodName(Method method) {
            this.method = method;
        }

        public Method getMethod() {
            return this.method;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EqualsByMethodName that = (EqualsByMethodName)o;
            return Objects.equal((Object)this.method.getName(), (Object)that.method.getName());
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.method.getName()});
        }
    }
}

