/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.worker;

import io.temporal.internal.activity.ActivityExecutionContextFactoryImpl;
import io.temporal.internal.activity.ActivityTaskHandlerImpl;
import io.temporal.internal.worker.ActivityWorker;
import io.temporal.internal.worker.EagerActivityDispatcher;
import io.temporal.internal.worker.ExecutorThreadFactory;
import io.temporal.internal.worker.ShutdownManager;
import io.temporal.internal.worker.SingleWorkerOptions;
import io.temporal.internal.worker.SuspendableWorker;
import io.temporal.internal.worker.WorkerLifecycleState;
import io.temporal.internal.worker.WorkerThreadsNameHelper;
import io.temporal.serviceclient.WorkflowServiceStubs;
import io.temporal.worker.tuning.ActivitySlotInfo;
import io.temporal.worker.tuning.SlotSupplier;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncActivityWorker
implements SuspendableWorker {
    private static final Logger log = LoggerFactory.getLogger(SyncActivityWorker.class);
    private final String identity;
    private final String namespace;
    private final String taskQueue;
    private final ScheduledExecutorService heartbeatExecutor;
    private final ActivityTaskHandlerImpl taskHandler;
    private final ActivityWorker worker;

    public SyncActivityWorker(WorkflowServiceStubs service, String namespace, String taskQueue, double taskQueueActivitiesPerSecond, SingleWorkerOptions options, SlotSupplier<ActivitySlotInfo> slotSupplier) {
        this.identity = options.getIdentity();
        this.namespace = namespace;
        this.taskQueue = taskQueue;
        this.heartbeatExecutor = Executors.newScheduledThreadPool(4, new ExecutorThreadFactory(WorkerThreadsNameHelper.getActivityHeartbeatThreadPrefix(namespace, taskQueue), null));
        ActivityExecutionContextFactoryImpl activityExecutionContextFactory = new ActivityExecutionContextFactoryImpl(service, this.identity, namespace, options.getMaxHeartbeatThrottleInterval(), options.getDefaultHeartbeatThrottleInterval(), options.getDataConverter(), this.heartbeatExecutor);
        this.taskHandler = new ActivityTaskHandlerImpl(namespace, taskQueue, options.getDataConverter(), activityExecutionContextFactory, options.getWorkerInterceptors(), options.getContextPropagators());
        this.worker = new ActivityWorker(service, namespace, taskQueue, taskQueueActivitiesPerSecond, options, this.taskHandler, slotSupplier);
    }

    public void registerActivityImplementations(Object ... activitiesImplementation) {
        this.taskHandler.registerActivityImplementations(activitiesImplementation);
    }

    @Override
    public boolean start() {
        return this.worker.start();
    }

    @Override
    public CompletableFuture<Void> shutdown(ShutdownManager shutdownManager, boolean interruptTasks) {
        return ((CompletableFuture)shutdownManager.shutdownExecutor(this.heartbeatExecutor, this + "#heartbeatExecutor", Duration.ofSeconds(5L)).thenCompose(r -> this.worker.shutdown(shutdownManager, interruptTasks))).exceptionally(e -> {
            log.error("[BUG] Unexpected exception during shutdown", e);
            return null;
        });
    }

    @Override
    public void awaitTermination(long timeout, TimeUnit unit) {
        long timeoutMillis = unit.toMillis(timeout);
        timeoutMillis = ShutdownManager.awaitTermination(this.worker, timeoutMillis);
        ShutdownManager.awaitTermination(this.heartbeatExecutor, timeoutMillis);
    }

    @Override
    public void suspendPolling() {
        this.worker.suspendPolling();
    }

    @Override
    public void resumePolling() {
        this.worker.resumePolling();
    }

    @Override
    public boolean isSuspended() {
        return this.worker.isSuspended();
    }

    @Override
    public boolean isShutdown() {
        return this.worker.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.worker.isTerminated() && this.heartbeatExecutor.isTerminated();
    }

    @Override
    public WorkerLifecycleState getLifecycleState() {
        WorkerLifecycleState lifecycleState = this.worker.getLifecycleState();
        if (WorkerLifecycleState.TERMINATED.equals((Object)lifecycleState)) {
            return this.heartbeatExecutor.isTerminated() ? WorkerLifecycleState.TERMINATED : WorkerLifecycleState.SHUTDOWN;
        }
        return lifecycleState;
    }

    public EagerActivityDispatcher getEagerActivityDispatcher() {
        return this.worker.getEagerActivityDispatcher();
    }

    public String toString() {
        return String.format("SyncActivityWorker{namespace=%s, taskQueue=%s, identity=%s}", this.namespace, this.taskQueue, this.identity);
    }
}

