/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.common;

import com.google.common.base.CaseFormat;
import com.google.common.collect.ImmutableMap;
import io.temporal.api.enums.v1.CommandType;
import io.temporal.api.enums.v1.IndexedValueType;
import io.temporal.api.enums.v1.WorkflowTaskFailedCause;
import java.util.Map;
import javax.annotation.Nonnull;

public class ProtoEnumNameUtils {
    public static final String WORKFLOW_TASK_FAILED_CAUSE_PREFIX = "WORKFLOW_TASK_FAILED_CAUSE_";
    public static final String INDEXED_VALUE_TYPE_PREFIX = "INDEXED_VALUE_TYPE_";
    public static final String COMMAND_TYPE_PREFIX = "COMMAND_TYPE_";
    public static final Map<Class<?>, String> ENUM_CLASS_TO_PREFIX = ImmutableMap.of(WorkflowTaskFailedCause.class, (Object)"WORKFLOW_TASK_FAILED_CAUSE_", IndexedValueType.class, (Object)"INDEXED_VALUE_TYPE_", CommandType.class, (Object)"COMMAND_TYPE_");

    @Nonnull
    public static String uniqueToSimplifiedName(@Nonnull Enum<?> enumm) {
        String protoEnumName = enumm.name();
        String prefix = ENUM_CLASS_TO_PREFIX.get(enumm.getClass());
        if (prefix == null) {
            throw new IllegalStateException("Enum " + enumm.getClass() + " must be explicitly registered in #ENUM_CLASS_TO_PREFIX to be used in this method");
        }
        if (!protoEnumName.startsWith(prefix)) {
            throw new IllegalArgumentException("protoEnumName should start with " + prefix + " prefix");
        }
        protoEnumName = protoEnumName.substring(prefix.length());
        return ProtoEnumNameUtils.screamingCaseEventTypeToCamelCase(protoEnumName);
    }

    public static String uniqueToSimplifiedName(String protoEnumName, String prefix) {
        if (!protoEnumName.startsWith(prefix)) {
            throw new IllegalArgumentException("protoEnumName should start with " + prefix + " prefix");
        }
        protoEnumName = protoEnumName.substring(prefix.length());
        return ProtoEnumNameUtils.screamingCaseEventTypeToCamelCase(protoEnumName);
    }

    public static String simplifiedToUniqueName(String enumName, String prefix) {
        return prefix + ProtoEnumNameUtils.camelCaseToScreamingCase(enumName);
    }

    private static String camelCaseToScreamingCase(String camel) {
        return (String)CaseFormat.UPPER_CAMEL.converterTo(CaseFormat.UPPER_UNDERSCORE).convert((Object)camel);
    }

    private static String screamingCaseEventTypeToCamelCase(String screaming) {
        return (String)CaseFormat.UPPER_UNDERSCORE.converterTo(CaseFormat.UPPER_CAMEL).convert((Object)screaming);
    }
}

