/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.client;

import com.google.common.base.Preconditions;
import com.google.protobuf.ByteString;
import com.uber.m3.tally.Scope;
import io.temporal.api.common.v1.Payloads;
import io.temporal.api.common.v1.WorkflowExecution;
import io.temporal.api.workflowservice.v1.RecordActivityTaskHeartbeatByIdRequest;
import io.temporal.api.workflowservice.v1.RecordActivityTaskHeartbeatByIdResponse;
import io.temporal.api.workflowservice.v1.RecordActivityTaskHeartbeatRequest;
import io.temporal.api.workflowservice.v1.RecordActivityTaskHeartbeatResponse;
import io.temporal.api.workflowservice.v1.WorkflowServiceGrpc;
import io.temporal.serviceclient.MetricsTag;
import io.temporal.serviceclient.WorkflowServiceStubs;
import java.util.Optional;
import javax.annotation.Nonnull;

public final class ActivityClientHelper {
    private ActivityClientHelper() {
    }

    public static RecordActivityTaskHeartbeatResponse sendHeartbeatRequest(WorkflowServiceStubs service, String namespace, String identity, byte[] taskToken, Optional<Payloads> payloads, Scope metricsScope) {
        RecordActivityTaskHeartbeatRequest.Builder request = RecordActivityTaskHeartbeatRequest.newBuilder().setTaskToken(ByteString.copyFrom((byte[])taskToken)).setNamespace(namespace).setIdentity(identity);
        payloads.ifPresent(arg_0 -> ((RecordActivityTaskHeartbeatRequest.Builder)request).setDetails(arg_0));
        return ((WorkflowServiceGrpc.WorkflowServiceBlockingStub)((WorkflowServiceGrpc.WorkflowServiceBlockingStub)service.blockingStub()).withOption(MetricsTag.METRICS_TAGS_CALL_OPTIONS_KEY, (Object)metricsScope)).recordActivityTaskHeartbeat(request.build());
    }

    public static RecordActivityTaskHeartbeatByIdResponse recordActivityTaskHeartbeatById(WorkflowServiceStubs service, String namespace, String identity, WorkflowExecution execution, @Nonnull String activityId, Optional<Payloads> payloads, Scope metricsScope) {
        Preconditions.checkNotNull((Object)activityId, (Object)"Either activity id or task token are required");
        RecordActivityTaskHeartbeatByIdRequest.Builder request = RecordActivityTaskHeartbeatByIdRequest.newBuilder().setRunId(execution.getRunId()).setWorkflowId(execution.getWorkflowId()).setActivityId(activityId).setNamespace(namespace).setIdentity(identity);
        payloads.ifPresent(arg_0 -> ((RecordActivityTaskHeartbeatByIdRequest.Builder)request).setDetails(arg_0));
        return ((WorkflowServiceGrpc.WorkflowServiceBlockingStub)((WorkflowServiceGrpc.WorkflowServiceBlockingStub)service.blockingStub()).withOption(MetricsTag.METRICS_TAGS_CALL_OPTIONS_KEY, (Object)metricsScope)).recordActivityTaskHeartbeatById(request.build());
    }
}

