/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.activity;

import io.temporal.activity.Activity;
import io.temporal.activity.ActivityExecutionContext;
import io.temporal.activity.DynamicActivity;
import io.temporal.common.converter.EncodedValues;
import io.temporal.common.interceptors.ActivityInboundCallsInterceptor;
import io.temporal.internal.activity.CurrentActivityExecutionContext;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

abstract class RootActivityInboundCallsInterceptor
implements ActivityInboundCallsInterceptor {
    private ActivityExecutionContext context;

    RootActivityInboundCallsInterceptor() {
    }

    @Override
    public void init(ActivityExecutionContext context) {
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ActivityInboundCallsInterceptor.ActivityOutput execute(ActivityInboundCallsInterceptor.ActivityInput input) {
        CurrentActivityExecutionContext.set(this.context);
        try {
            Object result = this.executeActivity(input);
            ActivityInboundCallsInterceptor.ActivityOutput activityOutput = new ActivityInboundCallsInterceptor.ActivityOutput(result);
            return activityOutput;
        }
        finally {
            CurrentActivityExecutionContext.unset();
        }
    }

    protected abstract Object executeActivity(ActivityInboundCallsInterceptor.ActivityInput var1);

    static class DynamicActivityInboundCallsInterceptor
    extends RootActivityInboundCallsInterceptor {
        private final DynamicActivity activity;

        DynamicActivityInboundCallsInterceptor(DynamicActivity activity) {
            this.activity = activity;
        }

        @Override
        protected Object executeActivity(ActivityInboundCallsInterceptor.ActivityInput input) {
            try {
                return this.activity.execute((EncodedValues)input.getArguments()[0]);
            }
            catch (Exception e) {
                throw Activity.wrap(e);
            }
        }
    }

    static class POJOActivityInboundCallsInterceptor
    extends RootActivityInboundCallsInterceptor {
        private final Object activity;
        private final Method method;

        POJOActivityInboundCallsInterceptor(Object activity, Method method) {
            this.activity = activity;
            this.method = method;
        }

        @Override
        protected Object executeActivity(ActivityInboundCallsInterceptor.ActivityInput input) {
            try {
                return this.method.invoke(this.activity, input.getArguments());
            }
            catch (InvocationTargetException e) {
                throw Activity.wrap(e.getTargetException());
            }
            catch (Exception e) {
                throw Activity.wrap(e);
            }
        }
    }
}

