/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.worker.tuning;

import io.temporal.common.Experimental;
import io.temporal.worker.tuning.ActivitySlotInfo;
import io.temporal.worker.tuning.LocalActivitySlotInfo;
import io.temporal.worker.tuning.ResourceBasedController;
import io.temporal.worker.tuning.ResourceBasedControllerOptions;
import io.temporal.worker.tuning.ResourceBasedSlotOptions;
import io.temporal.worker.tuning.ResourceBasedSlotSupplier;
import io.temporal.worker.tuning.SlotSupplier;
import io.temporal.worker.tuning.WorkerTuner;
import io.temporal.worker.tuning.WorkflowSlotInfo;
import java.time.Duration;
import javax.annotation.Nonnull;

@Experimental
public class ResourceBasedTuner
implements WorkerTuner {
    public static final ResourceBasedSlotOptions DEFAULT_WORKFLOW_SLOT_OPTIONS = ResourceBasedSlotOptions.newBuilder().setMinimumSlots(5).setMaximumSlots(500).setRampThrottle(Duration.ZERO).build();
    public static final ResourceBasedSlotOptions DEFAULT_ACTIVITY_SLOT_OPTIONS = ResourceBasedSlotOptions.newBuilder().setMinimumSlots(1).setMaximumSlots(1000).setRampThrottle(Duration.ofMillis(50L)).build();
    private final ResourceBasedController controller;
    private final ResourceBasedSlotOptions workflowSlotOptions;
    private final ResourceBasedSlotOptions activitySlotOptions;
    private final ResourceBasedSlotOptions localActivitySlotOptions;

    public static Builder newBuilder() {
        return new Builder();
    }

    public ResourceBasedTuner(ResourceBasedControllerOptions controllerOptions, ResourceBasedSlotOptions workflowSlotOptions, ResourceBasedSlotOptions activitySlotOptions, ResourceBasedSlotOptions localActivitySlotOptions) {
        this.controller = ResourceBasedController.newSystemInfoController(controllerOptions);
        this.workflowSlotOptions = workflowSlotOptions;
        this.activitySlotOptions = activitySlotOptions;
        this.localActivitySlotOptions = localActivitySlotOptions;
    }

    @Override
    @Nonnull
    public SlotSupplier<WorkflowSlotInfo> getWorkflowTaskSlotSupplier() {
        return ResourceBasedSlotSupplier.createForWorkflow(this.controller, this.workflowSlotOptions);
    }

    @Override
    @Nonnull
    public SlotSupplier<ActivitySlotInfo> getActivityTaskSlotSupplier() {
        return ResourceBasedSlotSupplier.createForActivity(this.controller, this.activitySlotOptions);
    }

    @Override
    @Nonnull
    public SlotSupplier<LocalActivitySlotInfo> getLocalActivitySlotSupplier() {
        return ResourceBasedSlotSupplier.createForLocalActivity(this.controller, this.localActivitySlotOptions);
    }

    public static final class Builder {
        private ResourceBasedControllerOptions controllerOptions;
        @Nonnull
        private ResourceBasedSlotOptions workflowSlotOptions = DEFAULT_WORKFLOW_SLOT_OPTIONS;
        @Nonnull
        private ResourceBasedSlotOptions activitySlotOptions = DEFAULT_ACTIVITY_SLOT_OPTIONS;
        @Nonnull
        private ResourceBasedSlotOptions localActivitySlotOptions = DEFAULT_ACTIVITY_SLOT_OPTIONS;

        private Builder() {
        }

        public Builder setControllerOptions(ResourceBasedControllerOptions controllerOptions) {
            this.controllerOptions = controllerOptions;
            return this;
        }

        public Builder setWorkflowSlotOptions(@Nonnull ResourceBasedSlotOptions workflowSlotOptions) {
            this.workflowSlotOptions = workflowSlotOptions;
            return this;
        }

        public Builder setActivitySlotOptions(@Nonnull ResourceBasedSlotOptions activitySlotOptions) {
            this.activitySlotOptions = activitySlotOptions;
            return this;
        }

        public Builder setLocalActivitySlotOptions(@Nonnull ResourceBasedSlotOptions localActivitySlotOptions) {
            this.localActivitySlotOptions = localActivitySlotOptions;
            return this;
        }

        public ResourceBasedTuner build() {
            return new ResourceBasedTuner(this.controllerOptions, this.workflowSlotOptions, this.activitySlotOptions, this.localActivitySlotOptions);
        }
    }
}

