/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.statemachines;

import com.google.common.base.Preconditions;
import io.temporal.api.command.v1.Command;
import io.temporal.api.command.v1.RecordMarkerCommandAttributes;
import io.temporal.api.common.v1.ActivityType;
import io.temporal.api.common.v1.Payloads;
import io.temporal.api.enums.v1.CommandType;
import io.temporal.api.enums.v1.EventType;
import io.temporal.api.failure.v1.ActivityFailureInfo;
import io.temporal.api.failure.v1.CanceledFailureInfo;
import io.temporal.api.failure.v1.Failure;
import io.temporal.api.history.v1.MarkerRecordedEventAttributes;
import io.temporal.api.workflowservice.v1.RespondActivityTaskCanceledRequest;
import io.temporal.api.workflowservice.v1.RespondActivityTaskCompletedRequest;
import io.temporal.common.converter.DefaultDataConverter;
import io.temporal.internal.history.LocalActivityMarkerMetadata;
import io.temporal.internal.history.LocalActivityMarkerUtils;
import io.temporal.internal.statemachines.CancellableCommand;
import io.temporal.internal.statemachines.EntityStateMachineInitialCommand;
import io.temporal.internal.statemachines.ExecuteLocalActivityParameters;
import io.temporal.internal.statemachines.LocalActivityCallback;
import io.temporal.internal.statemachines.StateMachine;
import io.temporal.internal.statemachines.StateMachineDefinition;
import io.temporal.internal.worker.LocalActivityResult;
import io.temporal.workflow.Functions;
import java.time.Duration;
import java.util.HashMap;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

final class LocalActivityStateMachine
extends EntityStateMachineInitialCommand<State, ExplicitEvent, LocalActivityStateMachine> {
    static final String LOCAL_ACTIVITY_FAILED_MESSAGE = "Local Activity task failed";
    static final String LOCAL_ACTIVITY_TIMED_OUT_MESSAGE = "Local Activity task timed out";
    static final String LOCAL_ACTIVITY_CANCELED_MESSAGE = "Local Activity canceled";
    private final Functions.Proc1<ExecuteLocalActivityParameters> localActivityRequestSink;
    private final LocalActivityCallback callback;
    private ExecuteLocalActivityParameters localActivityParameters;
    private final Functions.Func<Boolean> replaying;
    private final Functions.Func1<Long, Long> setCurrentTimeCallback;
    private final String activityId;
    private final ActivityType activityType;
    private final long originalScheduledTimestamp;
    private final long workflowTimeMillisWhenStarted;
    private final long systemNanoTimeWhenStarted;
    @Nullable
    private LocalActivityResult executionResult;
    @Nullable
    private Optional<Payloads> executionSuccess;
    @Nullable
    private LocalActivityCallback.LocalActivityFailedException executionFailure;
    public static final StateMachineDefinition<State, ExplicitEvent, LocalActivityStateMachine> STATE_MACHINE_DEFINITION = StateMachineDefinition.newInstance("LocalActivity", State.CREATED, State.MARKER_COMMAND_RECORDED).add(State.CREATED, ExplicitEvent.CHECK_EXECUTION_STATE, (State[])new State[]{State.REPLAYING, State.EXECUTING}, LocalActivityStateMachine::getExecutionState).add(State.EXECUTING, ExplicitEvent.SCHEDULE, State.REQUEST_PREPARED, LocalActivityStateMachine::sendRequest).add(State.REQUEST_PREPARED, ExplicitEvent.MARK_AS_SENT, State.REQUEST_SENT).add(State.REQUEST_PREPARED, ExplicitEvent.NON_REPLAY_WORKFLOW_TASK_STARTED, State.REQUEST_PREPARED).add(State.REQUEST_SENT, ExplicitEvent.NON_REPLAY_WORKFLOW_TASK_STARTED, State.REQUEST_SENT).add(State.REQUEST_SENT, ExplicitEvent.HANDLE_RESULT, State.MARKER_COMMAND_CREATED, LocalActivityStateMachine::createMarker).add(State.MARKER_COMMAND_CREATED, CommandType.COMMAND_TYPE_RECORD_MARKER, State.RESULT_NOTIFIED, LocalActivityStateMachine::notifyResultFromResponse).add(State.RESULT_NOTIFIED, EventType.EVENT_TYPE_MARKER_RECORDED, State.MARKER_COMMAND_RECORDED).add(State.REPLAYING, ExplicitEvent.SCHEDULE, State.WAITING_MARKER_EVENT).add(State.WAITING_MARKER_EVENT, EventType.EVENT_TYPE_MARKER_RECORDED, State.MARKER_COMMAND_RECORDED, LocalActivityStateMachine::notifyResultFromEvent).add(State.WAITING_MARKER_EVENT, ExplicitEvent.NON_REPLAY_WORKFLOW_TASK_STARTED, State.REQUEST_PREPARED, LocalActivityStateMachine::sendRequest);

    public static LocalActivityStateMachine newInstance(Functions.Func<Boolean> replaying, Functions.Func1<Long, Long> setCurrentTimeCallback, ExecuteLocalActivityParameters localActivityParameters, LocalActivityCallback callback, Functions.Proc1<ExecuteLocalActivityParameters> localActivityRequestSink, Functions.Proc1<CancellableCommand> commandSink, Functions.Proc1<StateMachine> stateMachineSink, long workflowTimeMillisWhenStarted) {
        return new LocalActivityStateMachine(replaying, setCurrentTimeCallback, localActivityParameters, callback, localActivityRequestSink, commandSink, stateMachineSink, workflowTimeMillisWhenStarted, System.nanoTime());
    }

    private LocalActivityStateMachine(Functions.Func<Boolean> replaying, Functions.Func1<Long, Long> setCurrentTimeCallback, ExecuteLocalActivityParameters localActivityParameters, LocalActivityCallback callback, Functions.Proc1<ExecuteLocalActivityParameters> localActivityRequestSink, Functions.Proc1<CancellableCommand> commandSink, Functions.Proc1<StateMachine> stateMachineSink, long workflowTimeMillisWhenStarted, long systemNanoTimeWhenStarted) {
        super(STATE_MACHINE_DEFINITION, commandSink, stateMachineSink);
        this.replaying = replaying;
        this.setCurrentTimeCallback = setCurrentTimeCallback;
        this.localActivityParameters = localActivityParameters;
        this.activityId = localActivityParameters.getActivityId();
        this.activityType = localActivityParameters.getActivityType();
        this.originalScheduledTimestamp = localActivityParameters.getOriginalScheduledTimestamp();
        this.localActivityRequestSink = localActivityRequestSink;
        this.callback = callback;
        this.workflowTimeMillisWhenStarted = workflowTimeMillisWhenStarted;
        this.systemNanoTimeWhenStarted = systemNanoTimeWhenStarted;
        this.explicitEvent(ExplicitEvent.CHECK_EXECUTION_STATE);
        this.explicitEvent(ExplicitEvent.SCHEDULE);
    }

    State getExecutionState() {
        return this.replaying.apply() != false ? State.REPLAYING : State.EXECUTING;
    }

    public void cancel() {
    }

    public void sendRequest() {
        this.localActivityRequestSink.apply(this.localActivityParameters);
        if (this.localActivityParameters.isDoNotIncludeArgumentsIntoMarker()) {
            this.localActivityParameters = null;
        }
    }

    public void markAsSent() {
        this.explicitEvent(ExplicitEvent.MARK_AS_SENT);
    }

    public void handleCompletion(LocalActivityResult result) {
        this.executionResult = result;
        this.explicitEvent(ExplicitEvent.HANDLE_RESULT);
    }

    public void nonReplayWorkflowTaskStarted() {
        this.explicitEvent(ExplicitEvent.NON_REPLAY_WORKFLOW_TASK_STARTED);
    }

    private void createMarker() {
        RecordMarkerCommandAttributes.Builder markerAttributes = RecordMarkerCommandAttributes.newBuilder();
        HashMap<String, Payloads> details = new HashMap<String, Payloads>();
        if (!this.replaying.apply().booleanValue()) {
            markerAttributes.setMarkerName("LocalActivity");
            Payloads id = DefaultDataConverter.STANDARD_INSTANCE.toPayloads(this.activityId).get();
            details.put("activityId", id);
            Payloads type = DefaultDataConverter.STANDARD_INSTANCE.toPayloads(this.activityType.getName()).get();
            details.put("type", type);
            long elapsedNanoseconds = System.nanoTime() - this.systemNanoTimeWhenStarted;
            long currentTime = this.setCurrentTimeCallback.apply(this.workflowTimeMillisWhenStarted + TimeUnit.NANOSECONDS.toMillis(elapsedNanoseconds));
            Payloads t = DefaultDataConverter.STANDARD_INSTANCE.toPayloads(currentTime).get();
            details.put("time", t);
            if (this.localActivityParameters != null && !this.localActivityParameters.isDoNotIncludeArgumentsIntoMarker()) {
                details.put("input", this.localActivityParameters.getInput());
            }
            Preconditions.checkState((this.executionResult != null ? 1 : 0) != 0, (Object)"Local activity execution result should be populated before triggering createMarker()");
            LocalActivityMarkerMetadata localActivityMarkerMetadata = new LocalActivityMarkerMetadata(this.executionResult.getLastAttempt(), this.originalScheduledTimestamp);
            if (this.executionResult.getExecutionCompleted() != null) {
                RespondActivityTaskCompletedRequest completed = this.executionResult.getExecutionCompleted();
                if (completed.hasResult()) {
                    Payloads p = completed.getResult();
                    this.executionSuccess = Optional.of(p);
                    details.put("result", p);
                } else {
                    this.executionSuccess = Optional.empty();
                }
            } else if (this.executionResult.getExecutionFailed() != null) {
                LocalActivityResult.ExecutionFailedResult failedResult = this.executionResult.getExecutionFailed();
                String message = failedResult.isTimeout() ? LOCAL_ACTIVITY_TIMED_OUT_MESSAGE : LOCAL_ACTIVITY_FAILED_MESSAGE;
                Failure failure = Failure.newBuilder().setMessage(message).setActivityFailureInfo(ActivityFailureInfo.newBuilder().setRetryState(failedResult.getRetryState()).setActivityId(this.activityId).setActivityType(this.activityType)).setCause(failedResult.getFailure()).build();
                markerAttributes.setFailure(failure);
                localActivityMarkerMetadata.setBackoff(failedResult.getBackoff());
                this.executionFailure = new LocalActivityCallback.LocalActivityFailedException(failure, this.originalScheduledTimestamp, localActivityMarkerMetadata.getAttempt(), failedResult.getBackoff());
            } else if (this.executionResult.getExecutionCanceled() != null) {
                RespondActivityTaskCanceledRequest failed = this.executionResult.getExecutionCanceled();
                Failure failure = Failure.newBuilder().setMessage(LOCAL_ACTIVITY_CANCELED_MESSAGE).setCanceledFailureInfo(CanceledFailureInfo.newBuilder().setDetails(failed.getDetails())).build();
                markerAttributes.setFailure(failure);
                this.executionFailure = new LocalActivityCallback.LocalActivityFailedException(failure, this.originalScheduledTimestamp, localActivityMarkerMetadata.getAttempt(), null);
            }
            details.put("meta", DefaultDataConverter.STANDARD_INSTANCE.toPayloads(localActivityMarkerMetadata).get());
            markerAttributes.putAllDetails(details);
        }
        this.addCommand(Command.newBuilder().setCommandType(CommandType.COMMAND_TYPE_RECORD_MARKER).setRecordMarkerCommandAttributes(markerAttributes.build()).build());
    }

    private void notifyResultFromEvent() {
        MarkerRecordedEventAttributes attributes = this.currentEvent.getMarkerRecordedEventAttributes();
        Preconditions.checkState((boolean)LocalActivityMarkerUtils.hasLocalActivityStructure(this.currentEvent), (String)"Expected LocalActivity, received: %s", (Object)attributes);
        long time = (Long)Preconditions.checkNotNull((Object)LocalActivityMarkerUtils.getTime(attributes), (Object)"'time' payload of a LocalActivity marker can't be empty");
        this.setCurrentTimeCallback.apply(time);
        if (attributes.hasFailure()) {
            LocalActivityMarkerMetadata metadata = LocalActivityMarkerUtils.getMetadata(attributes);
            long originalScheduledTimestamp = metadata != null ? metadata.getOriginalScheduledTimestamp() : -1L;
            int lastAttempt = metadata != null ? metadata.getAttempt() : 0;
            Duration backoff = metadata != null ? metadata.getBackoff() : null;
            LocalActivityCallback.LocalActivityFailedException localActivityFailedException = new LocalActivityCallback.LocalActivityFailedException(attributes.getFailure(), originalScheduledTimestamp, lastAttempt, backoff);
            this.callback.apply(null, localActivityFailedException);
        } else {
            Optional<Payloads> result = Optional.ofNullable(LocalActivityMarkerUtils.getResult(attributes));
            this.callback.apply(result, null);
        }
    }

    private void notifyResultFromResponse() {
        this.callback.apply(this.executionSuccess, this.executionFailure);
    }

    static enum State {
        CREATED,
        REPLAYING,
        EXECUTING,
        WAITING_MARKER_EVENT,
        REQUEST_PREPARED,
        REQUEST_SENT,
        MARKER_COMMAND_CREATED,
        RESULT_NOTIFIED,
        MARKER_COMMAND_RECORDED;

    }

    static enum ExplicitEvent {
        CHECK_EXECUTION_STATE,
        SCHEDULE,
        MARK_AS_SENT,
        HANDLE_RESULT,
        NON_REPLAY_WORKFLOW_TASK_STARTED;

    }
}

