/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.client.schedules;

import io.temporal.api.enums.v1.ScheduleOverlapPolicy;
import java.time.Instant;
import java.util.Objects;

public final class ScheduleBackfill {
    private final Instant startAt;
    private final Instant endAt;
    private final ScheduleOverlapPolicy overlapPolicy;

    public ScheduleBackfill(Instant startAt, Instant endAt) {
        this(startAt, endAt, ScheduleOverlapPolicy.SCHEDULE_OVERLAP_POLICY_UNSPECIFIED);
    }

    public ScheduleBackfill(Instant startAt, Instant endAt, ScheduleOverlapPolicy overlapPolicy) {
        this.startAt = startAt;
        this.endAt = endAt;
        this.overlapPolicy = overlapPolicy;
    }

    public Instant getStartAt() {
        return this.startAt;
    }

    public Instant getEndAt() {
        return this.endAt;
    }

    public ScheduleOverlapPolicy getOverlapPolicy() {
        return this.overlapPolicy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScheduleBackfill that = (ScheduleBackfill)o;
        return Objects.equals(this.startAt, that.startAt) && Objects.equals(this.endAt, that.endAt) && this.overlapPolicy == that.overlapPolicy;
    }

    public int hashCode() {
        return Objects.hash(this.startAt, this.endAt, this.overlapPolicy);
    }

    public String toString() {
        return "ScheduleBackfill{startAt=" + this.startAt + ", endAt=" + this.endAt + ", overlapPolicy=" + this.overlapPolicy + '}';
    }
}

