/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.worker;

import io.temporal.api.workflowservice.v1.PollActivityTaskQueueResponse;
import io.temporal.internal.worker.LocalActivityExecutionContext;
import io.temporal.workflow.Functions;
import java.util.concurrent.ScheduledFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

class LocalActivityAttemptTask {
    @Nonnull
    private final LocalActivityExecutionContext executionContext;
    @Nonnull
    private final PollActivityTaskQueueResponse.Builder attemptTask;
    @Nullable
    private final Functions.Proc takenFromQueueCallback;
    @Nullable
    private final ScheduledFuture<?> scheduleToStartFuture;

    public LocalActivityAttemptTask(@Nonnull LocalActivityExecutionContext executionContext, @Nonnull PollActivityTaskQueueResponse.Builder attemptTask, @Nullable Functions.Proc takenFromQueueCallback, @Nullable ScheduledFuture<?> scheduleToStartFuture) {
        this.executionContext = executionContext;
        this.attemptTask = attemptTask;
        this.takenFromQueueCallback = takenFromQueueCallback;
        this.scheduleToStartFuture = scheduleToStartFuture;
    }

    @Nonnull
    public LocalActivityExecutionContext getExecutionContext() {
        return this.executionContext;
    }

    public String getActivityId() {
        return this.executionContext.getActivityId();
    }

    @Nonnull
    public PollActivityTaskQueueResponse.Builder getAttemptTask() {
        return this.attemptTask;
    }

    public void markAsTakenFromQueue() {
        this.executionContext.newAttempt();
        if (this.takenFromQueueCallback != null) {
            this.takenFromQueueCallback.apply();
        }
    }

    @Nullable
    public ScheduledFuture<?> getScheduleToStartFuture() {
        return this.scheduleToStartFuture;
    }
}

