/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.payload.context;

import io.temporal.activity.ActivityInfo;
import io.temporal.common.Experimental;
import io.temporal.payload.context.HasWorkflowSerializationContext;
import java.util.Objects;
import javax.annotation.Nonnull;

@Experimental
public class ActivitySerializationContext
implements HasWorkflowSerializationContext {
    @Nonnull
    private final String namespace;
    @Nonnull
    private final String workflowId;
    @Nonnull
    private final String workflowType;
    @Nonnull
    private final String activityType;
    @Nonnull
    private final String activityTaskQueue;
    private final boolean local;

    public ActivitySerializationContext(@Nonnull String namespace, @Nonnull String workflowId, @Nonnull String workflowType, @Nonnull String activityType, @Nonnull String activityTaskQueue, boolean local) {
        this.namespace = Objects.requireNonNull(namespace);
        this.workflowId = Objects.requireNonNull(workflowId);
        this.workflowType = Objects.requireNonNull(workflowType);
        this.activityType = Objects.requireNonNull(activityType);
        this.activityTaskQueue = Objects.requireNonNull(activityTaskQueue);
        this.local = local;
    }

    public ActivitySerializationContext(ActivityInfo info) {
        this(info.getNamespace(), info.getWorkflowId(), info.getWorkflowType(), info.getActivityType(), info.getActivityTaskQueue(), info.isLocal());
    }

    @Override
    @Nonnull
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    @Nonnull
    public String getWorkflowId() {
        return this.workflowId;
    }

    @Nonnull
    public String getWorkflowType() {
        return this.workflowType;
    }

    @Nonnull
    public String getActivityType() {
        return this.activityType;
    }

    @Nonnull
    public String getActivityTaskQueue() {
        return this.activityTaskQueue;
    }

    public boolean isLocal() {
        return this.local;
    }
}

