/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.worker;

import com.google.common.base.Preconditions;
import io.temporal.internal.worker.BlockCallerPolicy;
import io.temporal.internal.worker.ExecutorThreadFactory;
import io.temporal.internal.worker.PollerOptions;
import io.temporal.internal.worker.ShutdownManager;
import io.temporal.internal.worker.ShutdownableTaskExecutor;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.slf4j.MDC;

final class PollTaskExecutor<T>
implements ShutdownableTaskExecutor<T> {
    private final String namespace;
    private final String taskQueue;
    private final String identity;
    private final TaskHandler<T> handler;
    private final PollerOptions pollerOptions;
    private final ThreadPoolExecutor taskExecutor;
    private final String pollThreadNamePrefix;

    PollTaskExecutor(@Nonnull String namespace, @Nonnull String taskQueue, @Nonnull String identity, @Nonnull TaskHandler<T> handler, @Nonnull PollerOptions pollerOptions, int workerTaskSlots, boolean synchronousQueue) {
        this.namespace = Objects.requireNonNull(namespace);
        this.taskQueue = Objects.requireNonNull(taskQueue);
        this.identity = Objects.requireNonNull(identity);
        this.handler = Objects.requireNonNull(handler);
        this.pollerOptions = Objects.requireNonNull(pollerOptions);
        this.taskExecutor = new ThreadPoolExecutor(synchronousQueue ? 0 : workerTaskSlots, workerTaskSlots, 10L, TimeUnit.SECONDS, (BlockingQueue<Runnable>)((Object)(synchronousQueue ? new SynchronousQueue() : new LinkedBlockingQueue())));
        this.taskExecutor.allowCoreThreadTimeOut(true);
        this.pollThreadNamePrefix = pollerOptions.getPollThreadNamePrefix().replaceFirst("Poller", "Executor");
        this.taskExecutor.setThreadFactory(new ExecutorThreadFactory(pollerOptions.getPollThreadNamePrefix().replaceFirst("Poller", "Executor"), pollerOptions.getUncaughtExceptionHandler()));
        this.taskExecutor.setRejectedExecutionHandler(new BlockCallerPolicy());
    }

    @Override
    public void process(@Nonnull T task) {
        Preconditions.checkNotNull(task, (Object)"task");
        this.taskExecutor.execute(() -> {
            try {
                MDC.put((String)"Namespace", (String)this.namespace);
                MDC.put((String)"TaskQueue", (String)this.taskQueue);
                this.handler.handle(task);
            }
            catch (Throwable e) {
                if (!this.isShutdown()) {
                    this.pollerOptions.getUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), this.handler.wrapFailure(task, e));
                }
            }
            finally {
                MDC.remove((String)"Namespace");
                MDC.remove((String)"TaskQueue");
            }
        });
    }

    @Override
    public boolean isShutdown() {
        return this.taskExecutor.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.taskExecutor.isTerminated();
    }

    @Override
    public CompletableFuture<Void> shutdown(ShutdownManager shutdownManager, boolean interruptTasks) {
        String taskExecutorName = this + "#taskExecutor";
        return interruptTasks ? shutdownManager.shutdownExecutorNowUntimed(this.taskExecutor, taskExecutorName) : shutdownManager.shutdownExecutorUntimed(this.taskExecutor, taskExecutorName);
    }

    @Override
    public void awaitTermination(long timeout, TimeUnit unit) {
        ShutdownManager.awaitTermination(this.taskExecutor, unit.toMillis(timeout));
    }

    public String toString() {
        return String.format("PollTaskExecutor{name=%s, identity=%s}", this.pollThreadNamePrefix, this.identity);
    }

    public static interface TaskHandler<TT> {
        public void handle(TT var1) throws Exception;

        public Throwable wrapFailure(TT var1, Throwable var2);
    }
}

