/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.replay;

import com.uber.m3.tally.Scope;
import io.temporal.api.command.v1.ContinueAsNewWorkflowExecutionCommandAttributes;
import io.temporal.api.command.v1.SignalExternalWorkflowExecutionCommandAttributes;
import io.temporal.api.common.v1.Payload;
import io.temporal.api.common.v1.Payloads;
import io.temporal.api.common.v1.SearchAttributes;
import io.temporal.api.common.v1.WorkflowExecution;
import io.temporal.api.common.v1.WorkflowType;
import io.temporal.api.failure.v1.Failure;
import io.temporal.common.RetryOptions;
import io.temporal.internal.common.SdkFlag;
import io.temporal.internal.replay.ReplayAware;
import io.temporal.internal.statemachines.ExecuteActivityParameters;
import io.temporal.internal.statemachines.ExecuteLocalActivityParameters;
import io.temporal.internal.statemachines.LocalActivityCallback;
import io.temporal.internal.statemachines.StartChildWorkflowExecutionParameters;
import io.temporal.workflow.Functions;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface ReplayWorkflowContext
extends ReplayAware {
    public WorkflowExecution getWorkflowExecution();

    public WorkflowExecution getParentWorkflowExecution();

    public WorkflowType getWorkflowType();

    @Nonnull
    public String getRunId();

    @Nonnull
    public String getFirstExecutionRunId();

    public Optional<String> getContinuedExecutionRunId();

    @Nonnull
    public String getOriginalExecutionRunId();

    public String getTaskQueue();

    @Nullable
    public RetryOptions getRetryOptions();

    public String getNamespace();

    public String getWorkflowId();

    public Duration getWorkflowRunTimeout();

    public Duration getWorkflowExecutionTimeout();

    public long getRunStartedTimestampMillis();

    @Nonnull
    public Duration getWorkflowTaskTimeout();

    public Payload getMemo(String var1);

    public ScheduleActivityTaskOutput scheduleActivityTask(ExecuteActivityParameters var1, Functions.Proc2<Optional<Payloads>, Failure> var2);

    public Functions.Proc scheduleLocalActivityTask(ExecuteLocalActivityParameters var1, LocalActivityCallback var2);

    public Functions.Proc1<Exception> startChildWorkflow(StartChildWorkflowExecutionParameters var1, Functions.Proc2<WorkflowExecution, Exception> var2, Functions.Proc2<Optional<Payloads>, Exception> var3);

    public Functions.Proc1<Exception> signalExternalWorkflowExecution(SignalExternalWorkflowExecutionCommandAttributes.Builder var1, Functions.Proc2<Void, Failure> var2);

    public void requestCancelExternalWorkflowExecution(WorkflowExecution var1, Functions.Proc2<Void, RuntimeException> var2);

    public long currentTimeMillis();

    public Functions.Proc1<RuntimeException> newTimer(Duration var1, Functions.Proc1<RuntimeException> var2);

    public void sideEffect(Functions.Func<Optional<Payloads>> var1, Functions.Proc1<Optional<Payloads>> var2);

    public void mutableSideEffect(String var1, Functions.Func1<Optional<Payloads>, Optional<Payloads>> var2, Functions.Proc1<Optional<Payloads>> var3);

    public boolean getVersion(String var1, int var2, int var3, Functions.Proc2<Integer, RuntimeException> var4);

    public Random newRandom();

    public Scope getMetricsScope();

    public boolean getEnableLoggingInReplay();

    public UUID randomUUID();

    public int getAttempt();

    public String getCronSchedule();

    @Nullable
    public Payloads getLastCompletionResult();

    @Nullable
    public Failure getPreviousRunFailure();

    @Nullable
    public String getFullReplayDirectQueryName();

    public Map<String, Payload> getHeader();

    public long getLastWorkflowTaskStartedEventId();

    public long getHistorySize();

    public boolean isContinueAsNewSuggested();

    public boolean isCancelRequested();

    public void setCancelRequested();

    public boolean isWorkflowMethodCompleted();

    public void setWorkflowMethodCompleted();

    public ContinueAsNewWorkflowExecutionCommandAttributes getContinueAsNewOnCompletion();

    public void continueAsNewOnCompletion(ContinueAsNewWorkflowExecutionCommandAttributes var1);

    public Throwable getWorkflowTaskFailure();

    public void failWorkflowTask(Throwable var1);

    @Nullable
    public SearchAttributes getSearchAttributes();

    public void upsertSearchAttributes(@Nonnull SearchAttributes var1);

    public boolean tryUseSdkFlag(SdkFlag var1);

    public Optional<String> getCurrentBuildId();

    public static class ScheduleActivityTaskOutput {
        private final String activityId;
        private final Functions.Proc1<Exception> cancellationHandle;

        public ScheduleActivityTaskOutput(String activityId, Functions.Proc1<Exception> cancllationHandle) {
            this.activityId = activityId;
            this.cancellationHandle = cancllationHandle;
        }

        public String getActivityId() {
            return this.activityId;
        }

        public Functions.Proc1<Exception> getCancellationHandle() {
            return this.cancellationHandle;
        }
    }
}

