/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.client;

import com.google.common.base.Objects;
import io.temporal.api.enums.v1.WorkflowIdReusePolicy;
import io.temporal.common.CronSchedule;
import io.temporal.common.MethodRetry;
import io.temporal.common.RetryOptions;
import io.temporal.common.SearchAttributes;
import io.temporal.common.context.ContextPropagator;
import io.temporal.internal.common.OptionsUtils;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public final class WorkflowOptions {
    private static final WorkflowOptions DEFAULT_INSTANCE = WorkflowOptions.newBuilder().build();
    private final String workflowId;
    private final WorkflowIdReusePolicy workflowIdReusePolicy;
    private final Duration workflowRunTimeout;
    private final Duration workflowExecutionTimeout;
    private final Duration workflowTaskTimeout;
    private final String taskQueue;
    private final RetryOptions retryOptions;
    private final String cronSchedule;
    private final Map<String, Object> memo;
    private final Map<String, ?> searchAttributes;
    private final SearchAttributes typedSearchAttributes;
    private final List<ContextPropagator> contextPropagators;
    private final boolean disableEagerExecution;
    private final Duration startDelay;

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(WorkflowOptions options) {
        return new Builder(options);
    }

    public static WorkflowOptions getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static WorkflowOptions merge(MethodRetry methodRetry, CronSchedule cronSchedule, WorkflowOptions o) {
        if (o == null) {
            o = WorkflowOptions.newBuilder().build();
        }
        String cronAnnotation = cronSchedule == null ? "" : cronSchedule.value();
        return WorkflowOptions.newBuilder().setWorkflowId(o.getWorkflowId()).setWorkflowIdReusePolicy(o.getWorkflowIdReusePolicy()).setWorkflowRunTimeout(o.getWorkflowRunTimeout()).setWorkflowExecutionTimeout(o.getWorkflowExecutionTimeout()).setWorkflowTaskTimeout(o.getWorkflowTaskTimeout()).setTaskQueue(o.getTaskQueue()).setRetryOptions(RetryOptions.merge(methodRetry, o.getRetryOptions())).setCronSchedule((String)OptionsUtils.merge((Object)cronAnnotation, (Object)o.getCronSchedule(), String.class)).setMemo(o.getMemo()).setSearchAttributes(o.getSearchAttributes()).setTypedSearchAttributes(o.getTypedSearchAttributes()).setContextPropagators(o.getContextPropagators()).setDisableEagerExecution(o.isDisableEagerExecution()).setStartDelay(o.getStartDelay()).validateBuildWithDefaults();
    }

    private WorkflowOptions(String workflowId, WorkflowIdReusePolicy workflowIdReusePolicy, Duration workflowRunTimeout, Duration workflowExecutionTimeout, Duration workflowTaskTimeout, String taskQueue, RetryOptions retryOptions, String cronSchedule, Map<String, Object> memo, Map<String, ?> searchAttributes, SearchAttributes typedSearchAttributes, List<ContextPropagator> contextPropagators, boolean disableEagerExecution, Duration startDelay) {
        this.workflowId = workflowId;
        this.workflowIdReusePolicy = workflowIdReusePolicy;
        this.workflowRunTimeout = workflowRunTimeout;
        this.workflowExecutionTimeout = workflowExecutionTimeout;
        this.workflowTaskTimeout = workflowTaskTimeout;
        this.taskQueue = taskQueue;
        this.retryOptions = retryOptions;
        this.cronSchedule = cronSchedule;
        this.memo = memo;
        this.searchAttributes = searchAttributes;
        this.typedSearchAttributes = typedSearchAttributes;
        this.contextPropagators = contextPropagators;
        this.disableEagerExecution = disableEagerExecution;
        this.startDelay = startDelay;
    }

    public String getWorkflowId() {
        return this.workflowId;
    }

    public WorkflowIdReusePolicy getWorkflowIdReusePolicy() {
        return this.workflowIdReusePolicy;
    }

    public Duration getWorkflowRunTimeout() {
        return this.workflowRunTimeout;
    }

    public Duration getWorkflowExecutionTimeout() {
        return this.workflowExecutionTimeout;
    }

    public Duration getWorkflowTaskTimeout() {
        return this.workflowTaskTimeout;
    }

    public String getTaskQueue() {
        return this.taskQueue;
    }

    public RetryOptions getRetryOptions() {
        return this.retryOptions;
    }

    public String getCronSchedule() {
        return this.cronSchedule;
    }

    public Map<String, Object> getMemo() {
        return this.memo;
    }

    @Deprecated
    public Map<String, ?> getSearchAttributes() {
        return this.searchAttributes;
    }

    public SearchAttributes getTypedSearchAttributes() {
        return this.typedSearchAttributes;
    }

    @Nullable
    public List<ContextPropagator> getContextPropagators() {
        return this.contextPropagators;
    }

    public boolean isDisableEagerExecution() {
        return this.disableEagerExecution;
    }

    @Nullable
    public Duration getStartDelay() {
        return this.startDelay;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkflowOptions that = (WorkflowOptions)o;
        return Objects.equal((Object)this.workflowId, (Object)that.workflowId) && this.workflowIdReusePolicy == that.workflowIdReusePolicy && Objects.equal((Object)this.workflowRunTimeout, (Object)that.workflowRunTimeout) && Objects.equal((Object)this.workflowExecutionTimeout, (Object)that.workflowExecutionTimeout) && Objects.equal((Object)this.workflowTaskTimeout, (Object)that.workflowTaskTimeout) && Objects.equal((Object)this.taskQueue, (Object)that.taskQueue) && Objects.equal((Object)this.retryOptions, (Object)that.retryOptions) && Objects.equal((Object)this.cronSchedule, (Object)that.cronSchedule) && Objects.equal(this.memo, that.memo) && Objects.equal(this.searchAttributes, that.searchAttributes) && Objects.equal((Object)this.typedSearchAttributes, (Object)that.typedSearchAttributes) && Objects.equal(this.contextPropagators, that.contextPropagators) && Objects.equal((Object)this.disableEagerExecution, (Object)that.disableEagerExecution) && Objects.equal((Object)this.startDelay, (Object)that.startDelay);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.workflowId, this.workflowIdReusePolicy, this.workflowRunTimeout, this.workflowExecutionTimeout, this.workflowTaskTimeout, this.taskQueue, this.retryOptions, this.cronSchedule, this.memo, this.searchAttributes, this.typedSearchAttributes, this.contextPropagators, this.disableEagerExecution, this.startDelay});
    }

    public String toString() {
        return "WorkflowOptions{workflowId='" + this.workflowId + '\'' + ", workflowIdReusePolicy=" + this.workflowIdReusePolicy + ", workflowRunTimeout=" + this.workflowRunTimeout + ", workflowExecutionTimeout=" + this.workflowExecutionTimeout + ", workflowTaskTimeout=" + this.workflowTaskTimeout + ", taskQueue='" + this.taskQueue + '\'' + ", retryOptions=" + this.retryOptions + ", cronSchedule='" + this.cronSchedule + '\'' + ", memo=" + this.memo + ", searchAttributes=" + this.searchAttributes + ", typedSearchAttributes=" + this.typedSearchAttributes + ", contextPropagators=" + this.contextPropagators + ", disableEagerExecution=" + this.disableEagerExecution + ", startDelay=" + this.startDelay + '}';
    }

    public static final class Builder {
        private String workflowId;
        private WorkflowIdReusePolicy workflowIdReusePolicy;
        private Duration workflowRunTimeout;
        private Duration workflowExecutionTimeout;
        private Duration workflowTaskTimeout;
        private String taskQueue;
        private RetryOptions retryOptions;
        private String cronSchedule;
        private Map<String, Object> memo;
        private Map<String, ?> searchAttributes;
        private SearchAttributes typedSearchAttributes;
        private List<ContextPropagator> contextPropagators;
        private boolean disableEagerExecution = true;
        private Duration startDelay;

        private Builder() {
        }

        private Builder(WorkflowOptions options) {
            if (options == null) {
                return;
            }
            this.workflowIdReusePolicy = options.workflowIdReusePolicy;
            this.workflowId = options.workflowId;
            this.workflowTaskTimeout = options.workflowTaskTimeout;
            this.workflowRunTimeout = options.workflowRunTimeout;
            this.workflowExecutionTimeout = options.workflowExecutionTimeout;
            this.taskQueue = options.taskQueue;
            this.retryOptions = options.retryOptions;
            this.cronSchedule = options.cronSchedule;
            this.memo = options.memo;
            this.searchAttributes = options.searchAttributes;
            this.typedSearchAttributes = options.typedSearchAttributes;
            this.contextPropagators = options.contextPropagators;
            this.disableEagerExecution = options.disableEagerExecution;
            this.startDelay = options.startDelay;
        }

        public Builder setWorkflowId(String workflowId) {
            this.workflowId = workflowId;
            return this;
        }

        public Builder setWorkflowIdReusePolicy(WorkflowIdReusePolicy workflowIdReusePolicy) {
            this.workflowIdReusePolicy = workflowIdReusePolicy;
            return this;
        }

        public Builder setWorkflowRunTimeout(Duration workflowRunTimeout) {
            this.workflowRunTimeout = workflowRunTimeout;
            return this;
        }

        public Builder setWorkflowExecutionTimeout(Duration workflowExecutionTimeout) {
            this.workflowExecutionTimeout = workflowExecutionTimeout;
            return this;
        }

        public Builder setWorkflowTaskTimeout(Duration workflowTaskTimeout) {
            this.workflowTaskTimeout = workflowTaskTimeout;
            return this;
        }

        public Builder setTaskQueue(String taskQueue) {
            this.taskQueue = taskQueue;
            return this;
        }

        public Builder setRetryOptions(RetryOptions retryOptions) {
            this.retryOptions = retryOptions;
            return this;
        }

        public Builder setCronSchedule(String cronSchedule) {
            this.cronSchedule = cronSchedule;
            return this;
        }

        public Builder setMemo(Map<String, Object> memo) {
            this.memo = memo;
            return this;
        }

        @Deprecated
        public Builder setSearchAttributes(Map<String, ?> searchAttributes) {
            if (searchAttributes != null && !searchAttributes.isEmpty() && this.typedSearchAttributes != null) {
                throw new IllegalArgumentException("Cannot have search attributes and typed search attributes");
            }
            this.searchAttributes = searchAttributes;
            return this;
        }

        public Builder setTypedSearchAttributes(SearchAttributes typedSearchAttributes) {
            if (typedSearchAttributes != null && this.searchAttributes != null && !this.searchAttributes.isEmpty()) {
                throw new IllegalArgumentException("Cannot have typed search attributes and search attributes");
            }
            this.typedSearchAttributes = typedSearchAttributes;
            return this;
        }

        public Builder setContextPropagators(@Nullable List<ContextPropagator> contextPropagators) {
            this.contextPropagators = contextPropagators;
            return this;
        }

        public Builder setDisableEagerExecution(boolean disableEagerExecution) {
            this.disableEagerExecution = disableEagerExecution;
            return this;
        }

        public Builder setStartDelay(Duration startDelay) {
            this.startDelay = startDelay;
            return this;
        }

        public WorkflowOptions build() {
            return new WorkflowOptions(this.workflowId, this.workflowIdReusePolicy, this.workflowRunTimeout, this.workflowExecutionTimeout, this.workflowTaskTimeout, this.taskQueue, this.retryOptions, this.cronSchedule, this.memo, this.searchAttributes, this.typedSearchAttributes, this.contextPropagators, this.disableEagerExecution, this.startDelay);
        }

        public WorkflowOptions validateBuildWithDefaults() {
            return new WorkflowOptions(this.workflowId, this.workflowIdReusePolicy, this.workflowRunTimeout, this.workflowExecutionTimeout, this.workflowTaskTimeout, this.taskQueue, this.retryOptions, this.cronSchedule, this.memo, this.searchAttributes, this.typedSearchAttributes, this.contextPropagators, this.disableEagerExecution, this.startDelay);
        }
    }
}

