/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.common.metadata;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import io.temporal.common.Experimental;
import io.temporal.common.metadata.POJOReflectionUtils;
import io.temporal.common.metadata.POJOWorkflowInterfaceMetadata;
import io.temporal.common.metadata.POJOWorkflowMethodMetadata;
import io.temporal.common.metadata.WorkflowMethodType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public final class POJOWorkflowImplMetadata {
    private final List<POJOWorkflowInterfaceMetadata> workflowInterfaces;
    private final List<POJOWorkflowMethodMetadata> workflowMethods;
    private final List<POJOWorkflowMethodMetadata> signalMethods;
    private final List<POJOWorkflowMethodMetadata> queryMethods;
    private final List<POJOWorkflowMethodMetadata> updateMethods;
    private final List<POJOWorkflowMethodMetadata> updateValidatorMethods;

    public static POJOWorkflowImplMetadata newInstance(Class<?> implClass) {
        return new POJOWorkflowImplMetadata(implClass, false);
    }

    public static POJOWorkflowImplMetadata newListenerInstance(Class<?> implClass) {
        return new POJOWorkflowImplMetadata(implClass, true);
    }

    private POJOWorkflowImplMetadata(Class<?> implClass, boolean listener) {
        if (implClass.isInterface() || implClass.isPrimitive() || implClass.isAnnotation() || implClass.isArray() || implClass.isEnum()) {
            throw new IllegalArgumentException("concrete class expected: " + implClass);
        }
        ArrayList<POJOWorkflowInterfaceMetadata> workflowInterfaces = new ArrayList<POJOWorkflowInterfaceMetadata>();
        HashMap<String, POJOWorkflowMethodMetadata> workflowMethods = new HashMap<String, POJOWorkflowMethodMetadata>();
        HashMap<String, POJOWorkflowMethodMetadata> queryMethods = new HashMap<String, POJOWorkflowMethodMetadata>();
        HashMap<String, POJOWorkflowMethodMetadata> signalMethods = new HashMap<String, POJOWorkflowMethodMetadata>();
        HashMap<String, POJOWorkflowMethodMetadata> updateMethods = new HashMap<String, POJOWorkflowMethodMetadata>();
        HashMap<String, POJOWorkflowMethodMetadata> updateValidatorMethods = new HashMap<String, POJOWorkflowMethodMetadata>();
        HashMap<EqualsByNameType, POJOWorkflowMethodMetadata> byNameType = new HashMap<EqualsByNameType, POJOWorkflowMethodMetadata>();
        Set<Class<?>> interfaces = POJOReflectionUtils.getTopLevelInterfaces(implClass);
        for (Class<?> anInterface : interfaces) {
            POJOWorkflowInterfaceMetadata interfaceMetadata = POJOWorkflowInterfaceMetadata.newImplementationInstance(anInterface, listener);
            List<POJOWorkflowMethodMetadata> methods = interfaceMetadata.getMethodsMetadata();
            if (!methods.isEmpty()) {
                workflowInterfaces.add(interfaceMetadata);
            }
            for (POJOWorkflowMethodMetadata methodMetadata : methods) {
                EqualsByNameType key = new EqualsByNameType(methodMetadata.getName(), methodMetadata.getType());
                POJOWorkflowMethodMetadata registeredMM = byNameType.put(key, methodMetadata);
                if (registeredMM != null && !registeredMM.getWorkflowMethod().equals(methodMetadata.getWorkflowMethod())) {
                    throw new IllegalArgumentException("Duplicated name of " + (Object)((Object)methodMetadata.getType()) + ": \"" + methodMetadata.getName() + "\" declared at \"" + registeredMM.getWorkflowMethod() + "\" and \"" + methodMetadata.getWorkflowMethod() + "\"");
                }
                switch (methodMetadata.getType()) {
                    case WORKFLOW: {
                        workflowMethods.put(methodMetadata.getName(), methodMetadata);
                        break;
                    }
                    case SIGNAL: {
                        signalMethods.put(methodMetadata.getName(), methodMetadata);
                        break;
                    }
                    case QUERY: {
                        queryMethods.put(methodMetadata.getName(), methodMetadata);
                        break;
                    }
                    case UPDATE: {
                        updateMethods.put(methodMetadata.getName(), methodMetadata);
                        break;
                    }
                    case UPDATE_VALIDATOR: {
                        updateValidatorMethods.put(methodMetadata.getName(), methodMetadata);
                    }
                }
            }
        }
        if (byNameType.isEmpty() && !listener) {
            throw new IllegalArgumentException("Class doesn't implement any non empty public interface annotated with @WorkflowInterface: " + implClass.getName());
        }
        this.workflowInterfaces = ImmutableList.copyOf(workflowInterfaces);
        this.workflowMethods = ImmutableList.copyOf(workflowMethods.values());
        this.signalMethods = ImmutableList.copyOf(signalMethods.values());
        this.queryMethods = ImmutableList.copyOf(queryMethods.values());
        this.updateMethods = ImmutableList.copyOf(updateMethods.values());
        this.updateValidatorMethods = ImmutableList.copyOf(updateValidatorMethods.values());
    }

    public List<POJOWorkflowInterfaceMetadata> getWorkflowInterfaces() {
        return this.workflowInterfaces;
    }

    public List<POJOWorkflowMethodMetadata> getWorkflowMethods() {
        return this.workflowMethods;
    }

    public List<POJOWorkflowMethodMetadata> getSignalMethods() {
        return this.signalMethods;
    }

    public List<POJOWorkflowMethodMetadata> getQueryMethods() {
        return this.queryMethods;
    }

    @Experimental
    public List<POJOWorkflowMethodMetadata> getUpdateMethods() {
        return this.updateMethods;
    }

    @Experimental
    public List<POJOWorkflowMethodMetadata> getUpdateValidatorMethods() {
        return this.updateValidatorMethods;
    }

    private static class EqualsByNameType {
        private final String name;
        private final WorkflowMethodType type;

        EqualsByNameType(String name, WorkflowMethodType type) {
            this.name = name;
            this.type = type;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EqualsByNameType that = (EqualsByNameType)o;
            return Objects.equal((Object)this.name, (Object)that.name) && this.type == that.type;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.name, this.type});
        }
    }
}

