/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.client.schedules;

import java.util.Objects;

public final class ScheduleState {
    private final String note;
    private final boolean paused;
    private final boolean limitedAction;
    private final long remainingActions;

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(ScheduleState options) {
        return new Builder(options);
    }

    private ScheduleState(String note, boolean paused, boolean limitedAction, long remainingActions) {
        this.note = note;
        this.paused = paused;
        this.limitedAction = limitedAction;
        this.remainingActions = remainingActions;
    }

    public String getNote() {
        return this.note;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public boolean isLimitedAction() {
        return this.limitedAction;
    }

    public long getRemainingActions() {
        return this.remainingActions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScheduleState that = (ScheduleState)o;
        return this.paused == that.paused && this.limitedAction == that.limitedAction && this.remainingActions == that.remainingActions && Objects.equals(this.note, that.note);
    }

    public int hashCode() {
        return Objects.hash(this.note, this.paused, this.limitedAction, this.remainingActions);
    }

    public String toString() {
        return "ScheduleState{note='" + this.note + '\'' + ", paused=" + this.paused + ", limitedAction=" + this.limitedAction + ", remainingActions=" + this.remainingActions + '}';
    }

    public static final class Builder {
        private String note;
        private boolean paused;
        private boolean limitedAction;
        private long remainingActions;

        private Builder() {
        }

        private Builder(ScheduleState options) {
            if (options == null) {
                return;
            }
            this.note = options.note;
            this.paused = options.paused;
            this.limitedAction = options.limitedAction;
            this.remainingActions = options.remainingActions;
        }

        public Builder setNote(String note) {
            this.note = note;
            return this;
        }

        public Builder setPaused(boolean paused) {
            this.paused = paused;
            return this;
        }

        public Builder setLimitedAction(boolean limitedAction) {
            this.limitedAction = limitedAction;
            return this;
        }

        public Builder setRemainingActions(long remainingActions) {
            this.remainingActions = remainingActions;
            return this;
        }

        public ScheduleState build() {
            return new ScheduleState(this.note, this.paused, this.limitedAction, this.remainingActions);
        }
    }
}

