/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.sync;

import io.temporal.api.common.v1.Payloads;
import io.temporal.api.workflowservice.v1.PollWorkflowTaskQueueResponse;
import io.temporal.common.converter.DataConverter;
import io.temporal.common.interceptors.WorkerInterceptor;
import io.temporal.internal.activity.LocalActivityExecutionContextFactoryImpl;
import io.temporal.internal.activity.POJOActivityTaskHandler;
import io.temporal.internal.common.InternalUtils;
import io.temporal.internal.common.WorkflowExecutionHistory;
import io.temporal.internal.replay.ReplayWorkflowTaskHandler;
import io.temporal.internal.replay.WorkflowExecutorCache;
import io.temporal.internal.sync.POJOWorkflowImplementationFactory;
import io.temporal.internal.sync.WorkflowThreadExecutor;
import io.temporal.internal.worker.LocalActivityWorker;
import io.temporal.internal.worker.QueryReplayHelper;
import io.temporal.internal.worker.ShutdownManager;
import io.temporal.internal.worker.SingleWorkerOptions;
import io.temporal.internal.worker.SuspendableWorker;
import io.temporal.internal.worker.WorkflowWorker;
import io.temporal.serviceclient.WorkflowServiceStubs;
import io.temporal.worker.WorkflowImplementationOptions;
import io.temporal.workflow.Functions;
import java.lang.reflect.Type;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncWorkflowWorker
implements SuspendableWorker,
Functions.Proc1<PollWorkflowTaskQueueResponse> {
    private static final Logger log = LoggerFactory.getLogger(SyncWorkflowWorker.class);
    private final String identity;
    private final String namespace;
    private final String taskQueue;
    private final WorkflowWorker workflowWorker;
    private final QueryReplayHelper queryReplayHelper;
    private final LocalActivityWorker laWorker;
    private final POJOWorkflowImplementationFactory factory;
    private final DataConverter dataConverter;
    private final POJOActivityTaskHandler laTaskHandler;

    public SyncWorkflowWorker(WorkflowServiceStubs service, String namespace, String taskQueue, WorkerInterceptor[] workerInterceptors, SingleWorkerOptions singleWorkerOptions, SingleWorkerOptions localActivityOptions, WorkflowExecutorCache cache, String stickyTaskQueueName, Duration stickyWorkflowTaskScheduleToStartTimeout, WorkflowThreadExecutor workflowThreadExecutor) {
        this.identity = singleWorkerOptions.getIdentity();
        this.namespace = namespace;
        this.taskQueue = taskQueue;
        this.dataConverter = singleWorkerOptions.getDataConverter();
        this.factory = new POJOWorkflowImplementationFactory(singleWorkerOptions, Objects.requireNonNull(workflowThreadExecutor), workerInterceptors, cache);
        LocalActivityExecutionContextFactoryImpl laActivityExecutionContextFactory = new LocalActivityExecutionContextFactoryImpl();
        this.laTaskHandler = new POJOActivityTaskHandler(namespace, localActivityOptions.getDataConverter(), workerInterceptors, laActivityExecutionContextFactory);
        this.laWorker = new LocalActivityWorker(namespace, taskQueue, localActivityOptions, this.laTaskHandler);
        ReplayWorkflowTaskHandler taskHandler = new ReplayWorkflowTaskHandler(namespace, this.factory, cache, singleWorkerOptions, stickyTaskQueueName, stickyWorkflowTaskScheduleToStartTimeout, service, this.laWorker.getLocalActivityTaskPoller());
        this.workflowWorker = new WorkflowWorker(service, namespace, taskQueue, stickyTaskQueueName, singleWorkerOptions, taskHandler);
        ReplayWorkflowTaskHandler nonStickyReplayTaskHandler = new ReplayWorkflowTaskHandler(namespace, this.factory, null, singleWorkerOptions, null, stickyWorkflowTaskScheduleToStartTimeout, service, this.laWorker.getLocalActivityTaskPoller());
        this.queryReplayHelper = new QueryReplayHelper(nonStickyReplayTaskHandler);
    }

    public void registerWorkflowImplementationTypes(WorkflowImplementationOptions options, Class<?>[] workflowImplementationTypes) {
        this.factory.registerWorkflowImplementationTypes(options, workflowImplementationTypes);
    }

    public <R> void addWorkflowImplementationFactory(WorkflowImplementationOptions options, Class<R> clazz, Functions.Func<R> factory) {
        this.factory.addWorkflowImplementationFactory(options, clazz, factory);
    }

    public <R> void addWorkflowImplementationFactory(Class<R> clazz, Functions.Func<R> factory) {
        this.factory.addWorkflowImplementationFactory(clazz, factory);
    }

    public void registerLocalActivityImplementations(Object ... activitiesImplementation) {
        this.laTaskHandler.registerActivityImplementations(activitiesImplementation);
    }

    @Override
    public void start() {
        this.workflowWorker.start();
        if (this.workflowWorker.isStarted()) {
            this.laWorker.start();
        }
    }

    @Override
    public boolean isStarted() {
        return this.workflowWorker.isStarted() && (this.laWorker.isStarted() || !this.laWorker.isAnyTypeSupported());
    }

    @Override
    public boolean isShutdown() {
        return this.workflowWorker.isShutdown() || this.laWorker.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.workflowWorker.isTerminated() && this.laWorker.isTerminated();
    }

    @Override
    public CompletableFuture<Void> shutdown(ShutdownManager shutdownManager, boolean interruptTasks) {
        return ((CompletableFuture)this.workflowWorker.shutdown(shutdownManager, interruptTasks).thenCompose(ignore -> this.laWorker.shutdown(shutdownManager, interruptTasks))).exceptionally(e -> {
            log.error("[BUG] Unexpected exception during shutdown", e);
            return null;
        });
    }

    @Override
    public void awaitTermination(long timeout, TimeUnit unit) {
        long timeoutMillis = InternalUtils.awaitTermination(this.laWorker, unit.toMillis(timeout));
        InternalUtils.awaitTermination(this.workflowWorker, timeoutMillis);
    }

    @Override
    public void suspendPolling() {
        this.workflowWorker.suspendPolling();
        this.laWorker.suspendPolling();
    }

    @Override
    public void resumePolling() {
        this.workflowWorker.resumePolling();
        this.laWorker.resumePolling();
    }

    @Override
    public boolean isSuspended() {
        return this.workflowWorker.isSuspended() && this.laWorker.isSuspended();
    }

    public <R> R queryWorkflowExecution(WorkflowExecutionHistory history, String queryType, Class<R> resultClass, Type resultType, Object[] args) throws Exception {
        Optional<Payloads> serializedArgs = this.dataConverter.toPayloads(args);
        Optional<Payloads> result = this.queryReplayHelper.queryWorkflowExecution(history, queryType, serializedArgs);
        return this.dataConverter.fromPayloads(0, result, resultClass, resultType);
    }

    @Override
    public void apply(PollWorkflowTaskQueueResponse pollWorkflowTaskQueueResponse) {
        this.workflowWorker.apply(pollWorkflowTaskQueueResponse);
    }

    public String toString() {
        return String.format("SyncWorkflowWorker{namespace=%s, taskQueue=%s, identity=%s}", this.namespace, this.taskQueue, this.identity);
    }
}

