/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.sync;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import io.temporal.common.context.ContextPropagator;
import io.temporal.internal.WorkflowThreadMarker;
import io.temporal.internal.context.ContextThreadLocal;
import io.temporal.internal.replay.WorkflowExecutorCache;
import io.temporal.internal.sync.CancellationScopeImpl;
import io.temporal.internal.sync.DeterministicRunner;
import io.temporal.internal.sync.PotentialDeadlockException;
import io.temporal.internal.sync.RunnerLocalInternal;
import io.temporal.internal.sync.SyncWorkflowContext;
import io.temporal.internal.sync.WorkflowInternal;
import io.temporal.internal.sync.WorkflowThread;
import io.temporal.internal.sync.WorkflowThreadExecutor;
import io.temporal.internal.sync.WorkflowThreadImpl;
import io.temporal.serviceclient.CheckedExceptionWrapper;
import io.temporal.workflow.Promise;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DeterministicRunnerImpl
implements DeterministicRunner {
    private static final int ROOT_THREAD_PRIORITY = 0;
    private static final int CALLBACK_THREAD_PRIORITY = 10;
    private static final int WORKFLOW_THREAD_PRIORITY = 20000000;
    static final String WORKFLOW_ROOT_THREAD_NAME = "workflow-root";
    private static final Logger log = LoggerFactory.getLogger(DeterministicRunnerImpl.class);
    private static final ThreadLocal<WorkflowThread> currentThreadThreadLocal = new ThreadLocal();
    private final Set<WorkflowThread> threads = new TreeSet<WorkflowThread>((t1, t2) -> Ints.compare((int)t1.getPriority(), (int)t2.getPriority()));
    private final Map<RunnerLocalInternal<?>, Object> runnerLocalMap = new HashMap();
    private final List<WorkflowThread> workflowThreadsToAdd = Collections.synchronizedList(new ArrayList());
    private final List<WorkflowThread> callbackThreadsToAdd = Collections.synchronizedList(new ArrayList());
    private final List<NamedRunnable> toExecuteInWorkflowThread = new ArrayList<NamedRunnable>();
    private final Lock lock = new ReentrantLock();
    private final Runnable rootRunnable;
    private final WorkflowThreadExecutor workflowThreadExecutor;
    private final SyncWorkflowContext workflowContext;
    private final WorkflowExecutorCache cache;
    private boolean inRunUntilAllBlocked;
    private boolean closeRequested;
    private boolean closed;
    private int addedThreads;
    private final Set<Promise> failedPromises = new HashSet<Promise>();
    private boolean exitRequested;
    private Object exitValue;
    private WorkflowThread rootWorkflowThread;
    private final CancellationScopeImpl runnerCancellationScope;

    static WorkflowThread currentThreadInternal() {
        WorkflowThread result = currentThreadThreadLocal.get();
        if (result == null) {
            throw new Error("Called from non workflow or workflow callback thread");
        }
        return result;
    }

    static Optional<WorkflowThread> currentThreadInternalIfPresent() {
        WorkflowThread result = currentThreadThreadLocal.get();
        if (result == null) {
            return Optional.empty();
        }
        return Optional.of(result);
    }

    static void setCurrentThreadInternal(WorkflowThread coroutine) {
        if (coroutine != null) {
            currentThreadThreadLocal.set(coroutine);
            WorkflowThreadMarkerAccessor.markAsWorkflowThread();
        } else {
            currentThreadThreadLocal.set(null);
            WorkflowThreadMarkerAccessor.markAsNonWorkflowThread();
        }
    }

    DeterministicRunnerImpl(WorkflowThreadExecutor workflowThreadExecutor, @Nonnull SyncWorkflowContext workflowContext, Runnable root) {
        this(workflowThreadExecutor, workflowContext, root, null);
    }

    DeterministicRunnerImpl(WorkflowThreadExecutor workflowThreadExecutor, @Nonnull SyncWorkflowContext workflowContext, Runnable root, WorkflowExecutorCache cache) {
        this.workflowThreadExecutor = workflowThreadExecutor;
        if (workflowContext == null) {
            throw new NullPointerException("workflowContext can't be null");
        }
        this.workflowContext = workflowContext;
        this.workflowContext.setRunner(this);
        this.cache = cache;
        this.runnerCancellationScope = new CancellationScopeImpl(true, null, null);
        this.rootRunnable = root;
    }

    SyncWorkflowContext getWorkflowContext() {
        return this.workflowContext;
    }

    @Override
    public void runUntilAllBlocked(long deadlockDetectionTimeout) {
        block18: {
            if (this.rootWorkflowThread == null) {
                this.rootWorkflowThread = this.newRootThread(this.rootRunnable);
                this.threads.add(this.rootWorkflowThread);
                this.rootWorkflowThread.start();
            }
            if (!this.rootWorkflowThread.isStarted()) {
                throw new IllegalStateException("start not called");
            }
            this.lock.lock();
            try {
                boolean progress;
                this.checkClosed();
                this.inRunUntilAllBlocked = true;
                Throwable unhandledException = null;
                do {
                    if (!this.toExecuteInWorkflowThread.isEmpty()) {
                        for (NamedRunnable nr : this.toExecuteInWorkflowThread) {
                            Object callbackThread = this.workflowContext.getWorkflowInboundInterceptor().newCallbackThread(nr.runnable, nr.name);
                            Preconditions.checkState((callbackThread != null ? 1 : 0) != 0, (Object)"[BUG] One of the custom interceptors illegally overrode newCallbackThread result to null. Check WorkflowInboundCallsInterceptor#newCallbackThread contract.");
                            Preconditions.checkState((boolean)(callbackThread instanceof WorkflowThread), (Object)("[BUG] One of the custom interceptors illegally overrode newCallbackThread result. Check WorkflowInboundCallsInterceptor#newCallbackThread contract. Illegal object returned from the interceptors chain: " + callbackThread));
                        }
                        for (int i = this.callbackThreadsToAdd.size() - 1; i >= 0; --i) {
                            this.threads.add(this.callbackThreadsToAdd.get(i));
                        }
                        this.callbackThreadsToAdd.clear();
                    }
                    this.toExecuteInWorkflowThread.clear();
                    progress = false;
                    Iterator<WorkflowThread> ci = this.threads.iterator();
                    while (ci.hasNext()) {
                        WorkflowThread c = ci.next();
                        boolean bl = progress = c.runUntilBlocked(deadlockDetectionTimeout) || progress;
                        if (this.exitRequested) {
                            this.close();
                            break block18;
                        }
                        if (!c.isDone()) continue;
                        ci.remove();
                        if (c.getUnhandledException() == null) continue;
                        unhandledException = c.getUnhandledException();
                        break;
                    }
                    if (unhandledException != null) {
                        this.close();
                        throw WorkflowInternal.wrap(unhandledException);
                    }
                    this.threads.addAll(this.workflowThreadsToAdd);
                    this.workflowThreadsToAdd.clear();
                } while (progress && !this.threads.isEmpty());
            }
            catch (PotentialDeadlockException e) {
                String triggerThreadStackTrace = "";
                StringBuilder otherThreadsDump = new StringBuilder();
                for (WorkflowThread t : this.threads) {
                    if (t.getWorkflowThreadContext() != e.getWorkflowThreadContext()) {
                        if (otherThreadsDump.length() > 0) {
                            otherThreadsDump.append("\n");
                        }
                        otherThreadsDump.append(t.getStackTrace());
                        continue;
                    }
                    triggerThreadStackTrace = t.getStackTrace();
                }
                e.setStackDump(triggerThreadStackTrace, otherThreadsDump.toString(), System.currentTimeMillis());
                throw e;
            }
            finally {
                this.inRunUntilAllBlocked = false;
                this.lock.unlock();
                if (this.closeRequested) {
                    this.close();
                }
            }
        }
    }

    @Override
    public boolean isDone() {
        this.lock.lock();
        try {
            boolean bl = this.closed || this.threads.isEmpty();
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public Object getExitValue() {
        this.lock.lock();
        try {
            if (!this.closed) {
                throw new Error("not done");
            }
        }
        finally {
            this.lock.unlock();
        }
        return this.exitValue;
    }

    @Override
    public void cancel(String reason) {
        this.executeInWorkflowThread("cancel workflow callback", () -> this.rootWorkflowThread.cancel(reason));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        ArrayList threadFutures = new ArrayList();
        this.lock.lock();
        if (this.closed) {
            this.lock.unlock();
            return;
        }
        this.closeRequested = true;
        if (this.inRunUntilAllBlocked) {
            this.lock.unlock();
            return;
        }
        try {
            for (WorkflowThread workflowThread : this.workflowThreadsToAdd) {
                this.threads.add(workflowThread);
            }
            this.workflowThreadsToAdd.clear();
            for (WorkflowThread workflowThread : this.threads) {
                threadFutures.add(workflowThread.stopNow());
            }
            this.threads.clear();
            HashSet<Promise> failedPromisesLoop = new HashSet<Promise>(this.failedPromises);
            for (Promise f : failedPromisesLoop) {
                if (!f.isCompleted()) {
                    throw new Error("expected failed");
                }
                try {
                    f.get();
                    throw new Error("unreachable");
                }
                catch (RuntimeException e) {
                    log.warn("Promise completed with exception and was never accessed. The ignored exception:", CheckedExceptionWrapper.unwrap((Throwable)e));
                }
            }
        }
        finally {
            this.closed = true;
            this.lock.unlock();
        }
        for (Future future : threadFutures) {
            try {
                future.get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new Error("Unexpected interrupt", e);
            }
            catch (ExecutionException e) {
                throw new Error("Unexpected failure stopping coroutine", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String stackTrace() {
        StringBuilder result = new StringBuilder();
        this.lock.lock();
        try {
            if (this.closed) {
                String string = "Workflow is closed.";
                return string;
            }
            for (WorkflowThread coroutine : this.threads) {
                if (result.length() > 0) {
                    result.append("\n");
                }
                coroutine.addStackTrace(result);
            }
        }
        finally {
            this.lock.unlock();
        }
        return result.toString();
    }

    private void checkClosed() {
        if (this.closed) {
            throw new Error("closed");
        }
    }

    private WorkflowThread newRootThread(Runnable runnable) {
        String name = WORKFLOW_ROOT_THREAD_NAME;
        if (this.rootWorkflowThread != null) {
            throw new IllegalStateException("newRootThread can be called only if there is no existing root workflow thread");
        }
        this.rootWorkflowThread = new WorkflowThreadImpl(this.workflowThreadExecutor, this, name, 0, false, this.runnerCancellationScope, runnable, this.cache, this.getContextPropagators(), this.getPropagatedContexts());
        return this.rootWorkflowThread;
    }

    @Override
    @Nonnull
    public WorkflowThread newWorkflowThread(Runnable runnable, boolean detached, @Nullable String name) {
        if (name == null) {
            name = "workflow[" + this.workflowContext.getContext().getWorkflowId() + "]-" + this.addedThreads;
        }
        if (this.rootWorkflowThread == null) {
            throw new IllegalStateException("newChildThread can be called only with existing root workflow thread");
        }
        this.checkWorkflowThreadOnly();
        this.checkClosed();
        WorkflowThreadImpl result = new WorkflowThreadImpl(this.workflowThreadExecutor, this, name, 20000000 + this.addedThreads++, detached, CancellationScopeImpl.current(), runnable, this.cache, this.getContextPropagators(), this.getPropagatedContexts());
        this.workflowThreadsToAdd.add(result);
        return result;
    }

    @Override
    @Nonnull
    public WorkflowThread newCallbackThread(Runnable runnable, @Nullable String name) {
        if (name == null) {
            name = "workflow[" + this.workflowContext.getContext().getWorkflowId() + "]-" + this.addedThreads;
        }
        WorkflowThreadImpl result = new WorkflowThreadImpl(this.workflowThreadExecutor, this, name, 10 + this.addedThreads++, false, this.runnerCancellationScope, runnable, this.cache, this.getContextPropagators(), this.getPropagatedContexts());
        this.callbackThreadsToAdd.add(result);
        return result;
    }

    @Override
    public void executeInWorkflowThread(String name, Runnable runnable) {
        this.lock.lock();
        try {
            this.toExecuteInWorkflowThread.add(new NamedRunnable(name, runnable));
        }
        finally {
            this.lock.unlock();
        }
    }

    Lock getLock() {
        return this.lock;
    }

    void registerFailedPromise(Promise promise) {
        this.failedPromises.add(promise);
    }

    void forgetFailedPromise(Promise promise) {
        this.failedPromises.remove(promise);
    }

    <R> void exit(R value) {
        this.checkClosed();
        this.checkWorkflowThreadOnly();
        this.exitValue = value;
        this.exitRequested = true;
    }

    private void checkWorkflowThreadOnly() {
        if (!this.inRunUntilAllBlocked) {
            throw new Error("called from non workflow thread");
        }
    }

    <T> Optional<T> getRunnerLocal(RunnerLocalInternal<T> key) {
        if (!this.runnerLocalMap.containsKey(key)) {
            return Optional.empty();
        }
        return Optional.of(this.runnerLocalMap.get(key));
    }

    <T> void setRunnerLocal(RunnerLocalInternal<T> key, T value) {
        this.runnerLocalMap.put(key, value);
    }

    private Map<String, Object> getPropagatedContexts() {
        if (currentThreadThreadLocal.get() != null) {
            return ContextThreadLocal.getCurrentContextForPropagation();
        }
        return this.workflowContext.getContext().getPropagatedContexts();
    }

    private List<ContextPropagator> getContextPropagators() {
        if (currentThreadThreadLocal.get() != null) {
            return ContextThreadLocal.getContextPropagators();
        }
        return this.workflowContext.getContext().getContextPropagators();
    }

    private static class WorkflowThreadMarkerAccessor
    extends WorkflowThreadMarker {
        private WorkflowThreadMarkerAccessor() {
        }

        public static void markAsWorkflowThread() {
            isWorkflowThreadThreadLocal.set(true);
        }

        public static void markAsNonWorkflowThread() {
            isWorkflowThreadThreadLocal.set(false);
        }
    }

    private static class NamedRunnable {
        private final String name;
        private final Runnable runnable;

        private NamedRunnable(String name, Runnable runnable) {
            this.name = name;
            this.runnable = runnable;
        }
    }
}

