/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.replay;

import com.google.protobuf.ByteString;
import com.uber.m3.tally.Scope;
import io.grpc.Status;
import io.temporal.api.history.v1.History;
import io.temporal.api.history.v1.HistoryEvent;
import io.temporal.api.workflowservice.v1.GetWorkflowExecutionHistoryRequest;
import io.temporal.api.workflowservice.v1.GetWorkflowExecutionHistoryResponse;
import io.temporal.api.workflowservice.v1.PollWorkflowTaskQueueResponseOrBuilder;
import io.temporal.api.workflowservice.v1.WorkflowServiceGrpc;
import io.temporal.internal.retryer.GrpcRetryer;
import io.temporal.serviceclient.MetricsTag;
import io.temporal.serviceclient.RpcRetryOptions;
import io.temporal.serviceclient.WorkflowServiceStubs;
import java.time.Duration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;

class WorkflowHistoryIterator
implements Iterator<HistoryEvent> {
    private final Duration retryServiceOperationInitialInterval = Duration.ofMillis(200L);
    private final Duration retryServiceOperationMaxInterval = Duration.ofSeconds(4L);
    private final Duration paginationStart = Duration.ofMillis(System.currentTimeMillis());
    public final WorkflowServiceStubs service;
    private final Duration workflowTaskTimeout;
    private final String namespace;
    private final Scope metricsScope;
    private final PollWorkflowTaskQueueResponseOrBuilder task;
    private Iterator<HistoryEvent> current;
    ByteString nextPageToken;

    WorkflowHistoryIterator(WorkflowServiceStubs service, String namespace, PollWorkflowTaskQueueResponseOrBuilder task, Duration workflowTaskTimeout, Scope metricsScope) {
        this.service = service;
        this.namespace = namespace;
        this.task = task;
        this.workflowTaskTimeout = Objects.requireNonNull(workflowTaskTimeout);
        this.metricsScope = metricsScope;
        History history = task.getHistory();
        this.current = history.getEventsList().iterator();
        this.nextPageToken = task.getNextPageToken();
    }

    @Override
    public boolean hasNext() {
        if (this.current.hasNext()) {
            return true;
        }
        if (this.nextPageToken.isEmpty()) {
            return false;
        }
        GetWorkflowExecutionHistoryResponse response = this.queryWorkflowExecutionHistory();
        this.current = response.getHistory().getEventsList().iterator();
        this.nextPageToken = response.getNextPageToken();
        return this.current.hasNext();
    }

    @Override
    public HistoryEvent next() {
        if (this.hasNext()) {
            return this.current.next();
        }
        throw new NoSuchElementException();
    }

    GetWorkflowExecutionHistoryResponse queryWorkflowExecutionHistory() {
        Duration passed = Duration.ofMillis(System.currentTimeMillis()).minus(this.paginationStart);
        Duration expiration = this.workflowTaskTimeout.minus(passed);
        if (expiration.isZero() || expiration.isNegative()) {
            throw Status.DEADLINE_EXCEEDED.withDescription("getWorkflowExecutionHistory pagination took longer than workflow task timeout").asRuntimeException();
        }
        RpcRetryOptions retryOptions = RpcRetryOptions.newBuilder().setExpiration(expiration).setInitialInterval(this.retryServiceOperationInitialInterval).setMaximumInterval(this.retryServiceOperationMaxInterval).build();
        GetWorkflowExecutionHistoryRequest request = GetWorkflowExecutionHistoryRequest.newBuilder().setNamespace(this.namespace).setExecution(this.task.getWorkflowExecution()).setNextPageToken(this.nextPageToken).build();
        try {
            return (GetWorkflowExecutionHistoryResponse)GrpcRetryer.retryWithResult(() -> ((WorkflowServiceGrpc.WorkflowServiceBlockingStub)((WorkflowServiceGrpc.WorkflowServiceBlockingStub)this.service.blockingStub()).withOption(MetricsTag.METRICS_TAGS_CALL_OPTIONS_KEY, (Object)this.metricsScope)).getWorkflowExecutionHistory(request), (RpcRetryOptions)retryOptions);
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }
}

