/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.common;

import com.google.common.annotations.VisibleForTesting;
import io.temporal.internal.common.env.EnvironmentVariablesProvider;
import io.temporal.internal.common.env.SystemEnvironmentVariablesProvider;

public class DebugModeUtils {
    private static boolean TEMPORAL_DEBUG_MODE = DebugModeUtils.readTemporalDebugMode(SystemEnvironmentVariablesProvider.INSTANCE);

    public static boolean isTemporalDebugModeOn() {
        return TEMPORAL_DEBUG_MODE;
    }

    private static boolean readTemporalDebugMode(EnvironmentVariablesProvider envProvider) {
        String temporalDebugValue = envProvider.getenv("TEMPORAL_DEBUG");
        if (temporalDebugValue == null) {
            return false;
        }
        temporalDebugValue = temporalDebugValue.trim();
        return !Boolean.FALSE.toString().equalsIgnoreCase(temporalDebugValue) && !"0".equals(temporalDebugValue);
    }

    @VisibleForTesting
    public static void override(boolean debugMode) {
        TEMPORAL_DEBUG_MODE = debugMode;
    }

    @VisibleForTesting
    public static void reset() {
        TEMPORAL_DEBUG_MODE = DebugModeUtils.readTemporalDebugMode(SystemEnvironmentVariablesProvider.INSTANCE);
    }
}

