/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.client;

import io.temporal.api.common.v1.WorkflowExecution;
import io.temporal.api.enums.v1.EventType;
import io.temporal.api.enums.v1.RetryState;
import io.temporal.client.WorkflowException;

public final class WorkflowFailedException
extends WorkflowException {
    private final EventType workflowCloseEventType;
    private final RetryState retryState;
    private final long workflowTaskCompletedEventId;

    public WorkflowFailedException(WorkflowExecution workflowExecution, String workflowType, EventType workflowCloseEventType, long workflowTaskCompletedEventId, RetryState retryState, Throwable cause) {
        super(WorkflowFailedException.getMessage(workflowExecution, workflowType, workflowCloseEventType, workflowTaskCompletedEventId, retryState), workflowExecution, workflowType, cause);
        this.workflowCloseEventType = workflowCloseEventType;
        this.retryState = retryState;
        this.workflowTaskCompletedEventId = workflowTaskCompletedEventId;
    }

    public RetryState getRetryState() {
        return this.retryState;
    }

    public long getWorkflowTaskCompletedEventId() {
        return this.workflowTaskCompletedEventId;
    }

    public EventType getWorkflowCloseEventType() {
        return this.workflowCloseEventType;
    }

    private static String getMessage(WorkflowExecution workflowExecution, String workflowType, EventType closeEventType, long workflowTaskCompletedEventId, RetryState retryState) {
        return "Workflow execution {workflowId='" + workflowExecution.getWorkflowId() + "', runId='" + workflowExecution.getRunId() + (workflowType == null ? "'" : "', workflowType='" + workflowType + "'") + "} " + WorkflowFailedException.getAction(closeEventType) + ". Metadata: {closeEventType='" + closeEventType + "', retryState='" + retryState + (workflowTaskCompletedEventId == -1L ? "'" : "', workflowTaskCompletedEventId=" + workflowTaskCompletedEventId + "'") + "}";
    }

    private static String getAction(EventType closeEventType) {
        switch (closeEventType) {
            case EVENT_TYPE_WORKFLOW_EXECUTION_CANCELED: {
                return "was cancelled";
            }
            case EVENT_TYPE_WORKFLOW_EXECUTION_TERMINATED: {
                return "was terminated";
            }
            case EVENT_TYPE_WORKFLOW_EXECUTION_TIMED_OUT: {
                return "timed out";
            }
            case EVENT_TYPE_WORKFLOW_EXECUTION_FAILED: {
                return "failed";
            }
        }
        return "failed with an unexpected closing event type " + closeEventType;
    }
}

