/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.worker.workflow;

import com.google.common.base.Preconditions;
import io.temporal.api.common.v1.WorkflowExecution;
import io.temporal.internal.worker.workflow.WorkflowMethodThreadNameStrategy;
import javax.annotation.Nonnull;

public class ExecutionInfoStrategy
implements WorkflowMethodThreadNameStrategy {
    public static final ExecutionInfoStrategy INSTANCE = new ExecutionInfoStrategy();
    private static final int WORKFLOW_ID_TRIM_LENGTH = 50;
    private static final String TRIM_MARKER = "...";

    private ExecutionInfoStrategy() {
    }

    @Override
    @Nonnull
    public String createThreadName(@Nonnull WorkflowExecution workflowExecution) {
        Preconditions.checkNotNull((Object)workflowExecution, (Object)"workflowExecution");
        String workflowId = workflowExecution.getWorkflowId();
        String trimmedWorkflowId = workflowId.length() > 50 ? workflowId.substring(0, 50) + TRIM_MARKER : workflowId;
        return "workflow-method-" + trimmedWorkflowId + "-" + workflowExecution.getRunId();
    }
}

