/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.sync;

import io.temporal.common.RetryOptions;
import io.temporal.internal.async.MethodReferenceDisassembler;
import io.temporal.internal.sync.WorkflowRetryerInternal;
import io.temporal.internal.sync.WorkflowThread;
import io.temporal.workflow.CompletablePromise;
import io.temporal.workflow.Functions;
import io.temporal.workflow.Promise;
import io.temporal.workflow.Workflow;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;

public final class AsyncInternal {
    private static final ThreadLocal<AtomicReference<Promise<?>>> asyncResult = new ThreadLocal();

    public static <R> Promise<R> function(Functions.Func<R> function) {
        return AsyncInternal.execute(AsyncInternal.isAsync(function), () -> function.apply());
    }

    public static <A1, R> Promise<R> function(Functions.Func1<A1, R> function, A1 arg1) {
        return AsyncInternal.execute(AsyncInternal.isAsync(function), () -> function.apply(arg1));
    }

    public static <A1, A2, R> Promise<R> function(Functions.Func2<A1, A2, R> function, A1 arg1, A2 arg2) {
        return AsyncInternal.execute(AsyncInternal.isAsync(function), () -> function.apply(arg1, arg2));
    }

    public static <A1, A2, A3, R> Promise<R> function(Functions.Func3<A1, A2, A3, R> function, A1 arg1, A2 arg2, A3 arg3) {
        return AsyncInternal.execute(AsyncInternal.isAsync(function), () -> function.apply(arg1, arg2, arg3));
    }

    public static <A1, A2, A3, A4, R> Promise<R> function(Functions.Func4<A1, A2, A3, A4, R> function, A1 arg1, A2 arg2, A3 arg3, A4 arg4) {
        return AsyncInternal.execute(AsyncInternal.isAsync(function), () -> function.apply(arg1, arg2, arg3, arg4));
    }

    public static <A1, A2, A3, A4, A5, R> Promise<R> function(Functions.Func5<A1, A2, A3, A4, A5, R> function, A1 arg1, A2 arg2, A3 arg3, A4 arg4, A5 arg5) {
        return AsyncInternal.execute(AsyncInternal.isAsync(function), () -> function.apply(arg1, arg2, arg3, arg4, arg5));
    }

    public static <A1, A2, A3, A4, A5, A6, R> Promise<R> function(Functions.Func6<A1, A2, A3, A4, A5, A6, R> function, A1 arg1, A2 arg2, A3 arg3, A4 arg4, A5 arg5, A6 arg6) {
        return AsyncInternal.execute(AsyncInternal.isAsync(function), () -> function.apply(arg1, arg2, arg3, arg4, arg5, arg6));
    }

    public static Promise<Void> procedure(Functions.Proc procedure) {
        return AsyncInternal.execute(AsyncInternal.isAsync(procedure), () -> {
            procedure.apply();
            return null;
        });
    }

    private static Promise<Void> procedure(boolean async, Functions.Proc procedure) {
        return AsyncInternal.execute(async, () -> {
            procedure.apply();
            return null;
        });
    }

    public static <A1> Promise<Void> procedure(Functions.Proc1<A1> procedure, A1 arg1) {
        return AsyncInternal.procedure(AsyncInternal.isAsync(procedure), () -> procedure.apply(arg1));
    }

    public static <A1, A2> Promise<Void> procedure(Functions.Proc2<A1, A2> procedure, A1 arg1, A2 arg2) {
        return AsyncInternal.procedure(AsyncInternal.isAsync(procedure), () -> procedure.apply(arg1, arg2));
    }

    public static <A1, A2, A3> Promise<Void> procedure(Functions.Proc3<A1, A2, A3> procedure, A1 arg1, A2 arg2, A3 arg3) {
        return AsyncInternal.procedure(AsyncInternal.isAsync(procedure), () -> procedure.apply(arg1, arg2, arg3));
    }

    public static <A1, A2, A3, A4> Promise<Void> procedure(Functions.Proc4<A1, A2, A3, A4> procedure, A1 arg1, A2 arg2, A3 arg3, A4 arg4) {
        return AsyncInternal.procedure(AsyncInternal.isAsync(procedure), () -> procedure.apply(arg1, arg2, arg3, arg4));
    }

    public static <A1, A2, A3, A4, A5> Promise<Void> procedure(Functions.Proc5<A1, A2, A3, A4, A5> procedure, A1 arg1, A2 arg2, A3 arg3, A4 arg4, A5 arg5) {
        return AsyncInternal.procedure(AsyncInternal.isAsync(procedure), () -> procedure.apply(arg1, arg2, arg3, arg4, arg5));
    }

    public static <A1, A2, A3, A4, A5, A6> Promise<Void> procedure(Functions.Proc6<A1, A2, A3, A4, A5, A6> procedure, A1 arg1, A2 arg2, A3 arg3, A4 arg4, A5 arg5, A6 arg6) {
        return AsyncInternal.procedure(AsyncInternal.isAsync(procedure), () -> procedure.apply(arg1, arg2, arg3, arg4, arg5, arg6));
    }

    public static <R> Promise<R> retry(RetryOptions options, Optional<Duration> expiration, Functions.Func<Promise<R>> fn) {
        return WorkflowRetryerInternal.retryAsync(options, expiration, fn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <R> Promise<R> execute(boolean temporalStub, Functions.Func<R> func) {
        if (temporalStub) {
            AsyncInternal.initAsyncInvocation();
            try {
                func.apply();
                Promise<R> promise = AsyncInternal.getAsyncInvocationResult();
                return promise;
            }
            catch (Exception e) {
                Promise promise = Workflow.newFailedPromise(Workflow.wrap(e));
                return promise;
            }
            finally {
                AsyncInternal.closeAsyncInvocation();
            }
        }
        CompletablePromise result = Workflow.newPromise();
        WorkflowThread.newThread(() -> {
            try {
                result.complete(func.apply());
            }
            catch (Exception e) {
                result.completeExceptionally(Workflow.wrap(e));
            }
        }, false).start();
        return result;
    }

    public static boolean isAsync(Object func) {
        return MethodReferenceDisassembler.isAsync(func);
    }

    public static boolean isAsync() {
        return asyncResult.get() != null;
    }

    public static <R> void setAsyncResult(Promise<R> result) {
        AtomicReference<Promise<?>> placeholder = asyncResult.get();
        if (placeholder == null) {
            throw new IllegalStateException("not in invoke invocation");
        }
        placeholder.set(result);
    }

    private static void initAsyncInvocation() {
        if (asyncResult.get() != null) {
            throw new IllegalStateException("already in start invocation");
        }
        asyncResult.set(new AtomicReference());
    }

    private static <R> Promise<R> getAsyncInvocationResult() {
        AtomicReference<Promise<?>> reference = asyncResult.get();
        if (reference == null) {
            throw new IllegalStateException("initAsyncInvocation wasn't called");
        }
        Promise<?> result = reference.get();
        if (result == null) {
            throw new IllegalStateException("start result wasn't set");
        }
        return result;
    }

    public static void closeAsyncInvocation() {
        asyncResult.remove();
    }

    private AsyncInternal() {
    }

    public static interface AsyncMarker {
    }
}

