/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.history;

import com.google.common.base.Preconditions;
import io.temporal.api.command.v1.RecordMarkerCommandAttributes;
import io.temporal.api.common.v1.Payloads;
import io.temporal.api.history.v1.HistoryEvent;
import io.temporal.api.history.v1.MarkerRecordedEventAttributes;
import io.temporal.internal.history.MarkerUtils;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;

public class VersionMarkerUtils {
    public static final String MARKER_CHANGE_ID_KEY = "changeId";
    public static final String MARKER_VERSION_KEY = "version";

    @Nullable
    public static String tryGetChangeIdFromVersionMarkerEvent(HistoryEvent event) {
        if (!VersionMarkerUtils.hasVersionMarkerStructure(event)) {
            return null;
        }
        Map detailsMap = event.getMarkerRecordedEventAttributes().getDetailsMap();
        Optional<Payloads> oid = Optional.ofNullable((Payloads)detailsMap.get(MARKER_CHANGE_ID_KEY));
        String changeId = MarkerUtils.DATA_CONVERTER.fromPayloads(0, oid, String.class, (Type)((Object)String.class));
        return changeId;
    }

    public static boolean hasVersionMarkerStructure(HistoryEvent event) {
        return MarkerUtils.verifyMarkerName(event, "Version");
    }

    @Nullable
    public static String getChangeId(MarkerRecordedEventAttributes markerAttributes) {
        return MarkerUtils.getValueFromMarker(markerAttributes, MARKER_CHANGE_ID_KEY, String.class);
    }

    @Nullable
    public static Integer getVersion(MarkerRecordedEventAttributes markerAttributes) {
        return MarkerUtils.getValueFromMarker(markerAttributes, MARKER_VERSION_KEY, Integer.class);
    }

    public static RecordMarkerCommandAttributes createMarkerAttributes(String changeId, Integer version) {
        Preconditions.checkNotNull((Object)version, (Object)MARKER_VERSION_KEY);
        HashMap<String, Payloads> details = new HashMap<String, Payloads>();
        details.put(MARKER_CHANGE_ID_KEY, MarkerUtils.DATA_CONVERTER.toPayloads(changeId).get());
        details.put(MARKER_VERSION_KEY, MarkerUtils.DATA_CONVERTER.toPayloads(version).get());
        return RecordMarkerCommandAttributes.newBuilder().setMarkerName("Version").putAllDetails(details).build();
    }
}

