/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.client;

import com.google.protobuf.ByteString;
import io.grpc.Deadline;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.temporal.api.common.v1.Payloads;
import io.temporal.api.common.v1.WorkflowExecution;
import io.temporal.api.enums.v1.EventType;
import io.temporal.api.enums.v1.WorkflowExecutionStatus;
import io.temporal.api.history.v1.History;
import io.temporal.api.history.v1.HistoryEvent;
import io.temporal.api.history.v1.HistoryEventOrBuilder;
import io.temporal.api.workflowservice.v1.GetWorkflowExecutionHistoryRequest;
import io.temporal.api.workflowservice.v1.GetWorkflowExecutionHistoryResponse;
import io.temporal.common.converter.DataConverter;
import io.temporal.internal.client.WorkflowClientRequestFactory;
import io.temporal.internal.client.external.GenericWorkflowClient;
import io.temporal.internal.common.WorkflowExecutionUtils;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nonnull;

final class WorkflowClientLongPollHelper {
    WorkflowClientLongPollHelper() {
    }

    static Optional<Payloads> getWorkflowExecutionResult(GenericWorkflowClient genericClient, WorkflowClientRequestFactory workflowClientHelper, @Nonnull WorkflowExecution workflowExecution, Optional<String> workflowType, DataConverter converter, long timeout, TimeUnit unit) throws TimeoutException {
        HistoryEvent closeEvent = WorkflowClientLongPollHelper.getInstanceCloseEvent(genericClient, workflowClientHelper, workflowExecution, timeout, unit);
        return WorkflowExecutionUtils.getResultFromCloseEvent(workflowExecution, workflowType, closeEvent, converter);
    }

    static WorkflowExecutionStatus waitForWorkflowInstanceCompletion(GenericWorkflowClient genericClient, WorkflowClientRequestFactory workflowClientHelper, @Nonnull WorkflowExecution workflowExecution, long timeout, TimeUnit unit) throws TimeoutException {
        HistoryEvent closeEvent = WorkflowClientLongPollHelper.getInstanceCloseEvent(genericClient, workflowClientHelper, workflowExecution, timeout, unit);
        return WorkflowExecutionUtils.getCloseStatus(closeEvent);
    }

    private static HistoryEvent getInstanceCloseEvent(GenericWorkflowClient genericClient, WorkflowClientRequestFactory workflowClientHelper, @Nonnull WorkflowExecution workflowExecution, long timeout, TimeUnit unit) throws TimeoutException {
        ByteString pageToken = ByteString.EMPTY;
        Deadline longPollTimeoutDeadline = Deadline.after((long)timeout, (TimeUnit)unit);
        while (true) {
            GetWorkflowExecutionHistoryResponse response;
            GetWorkflowExecutionHistoryRequest request = workflowClientHelper.newHistoryLongPollRequest(workflowExecution, pageToken);
            try {
                response = genericClient.longPollHistory(request, longPollTimeoutDeadline);
            }
            catch (StatusRuntimeException e) {
                if (longPollTimeoutDeadline.isExpired() && Status.Code.DEADLINE_EXCEEDED.equals((Object)e.getStatus().getCode())) {
                    throw WorkflowClientLongPollHelper.newTimeoutException(workflowExecution, timeout, unit);
                }
                throw e;
            }
            History history = response.getHistory();
            if (history.getEventsCount() > 0) {
                HistoryEvent event = history.getEvents(0);
                if (!WorkflowExecutionUtils.isWorkflowExecutionClosedEvent((HistoryEventOrBuilder)event)) {
                    throw new RuntimeException("Unexpected workflow execution closing event: " + event);
                }
                if (event.getEventType() == EventType.EVENT_TYPE_WORKFLOW_EXECUTION_CONTINUED_AS_NEW) {
                    pageToken = ByteString.EMPTY;
                    workflowExecution = WorkflowExecution.newBuilder().setWorkflowId(workflowExecution.getWorkflowId()).setRunId(event.getWorkflowExecutionContinuedAsNewEventAttributes().getNewExecutionRunId()).build();
                    continue;
                }
                return event;
            }
            if (response.getNextPageToken().isEmpty()) continue;
            pageToken = response.getNextPageToken();
        }
    }

    static TimeoutException newTimeoutException(@Nonnull WorkflowExecution workflowExecution, long timeout, TimeUnit unit) {
        return new TimeoutException("WorkflowId=" + workflowExecution.getWorkflowId() + ", runId=" + workflowExecution.getRunId() + ", timeout=" + timeout + ", unit=" + (Object)((Object)unit));
    }
}

