/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.activity;

import com.uber.m3.tally.Scope;
import io.temporal.activity.ActivityExecutionContext;
import io.temporal.activity.ActivityInfo;
import io.temporal.activity.ManualActivityCompletionClient;
import io.temporal.client.ActivityCompletionException;
import io.temporal.common.converter.DataConverter;
import io.temporal.internal.activity.CompletionAwareManualCompletionClient;
import io.temporal.internal.activity.HeartbeatContext;
import io.temporal.internal.activity.HeartbeatContextImpl;
import io.temporal.internal.client.external.ManualActivityCompletionClientFactory;
import io.temporal.serviceclient.WorkflowServiceStubs;
import io.temporal.workflow.Functions;
import java.lang.reflect.Type;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
class ActivityExecutionContextImpl
implements ActivityExecutionContext {
    private final Lock lock = new ReentrantLock();
    private final ManualActivityCompletionClientFactory manualCompletionClientFactory;
    private final Functions.Proc completionHandle;
    private final HeartbeatContext heartbeatContext;
    private final Scope metricsScope;
    private final ActivityInfo info;
    private boolean useLocalManualCompletion;
    private boolean doNotCompleteOnReturn;

    ActivityExecutionContextImpl(WorkflowServiceStubs service, String namespace, ActivityInfo info, DataConverter dataConverter, ScheduledExecutorService heartbeatExecutor, ManualActivityCompletionClientFactory manualCompletionClientFactory, Functions.Proc completionHandle, Scope metricsScope, String identity, Duration maxHeartbeatThrottleInterval, Duration defaultHeartbeatThrottleInterval) {
        this.metricsScope = metricsScope;
        this.info = info;
        this.completionHandle = completionHandle;
        this.manualCompletionClientFactory = manualCompletionClientFactory;
        this.heartbeatContext = new HeartbeatContextImpl(service, namespace, info, dataConverter, heartbeatExecutor, metricsScope, identity, maxHeartbeatThrottleInterval, defaultHeartbeatThrottleInterval);
    }

    @Override
    public <V> void heartbeat(V details) throws ActivityCompletionException {
        this.heartbeatContext.heartbeat(details);
    }

    @Override
    public <V> Optional<V> getHeartbeatDetails(Class<V> detailsClass) {
        return this.getHeartbeatDetails(detailsClass, detailsClass);
    }

    @Override
    public <V> Optional<V> getHeartbeatDetails(Class<V> detailsClass, Type detailsGenericType) {
        return this.heartbeatContext.getHeartbeatDetails(detailsClass, detailsGenericType);
    }

    @Override
    public byte[] getTaskToken() {
        return this.info.getTaskToken();
    }

    @Override
    public void doNotCompleteOnReturn() {
        this.lock.lock();
        try {
            this.doNotCompleteOnReturn = true;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean isDoNotCompleteOnReturn() {
        this.lock.lock();
        try {
            boolean bl = this.doNotCompleteOnReturn;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean isUseLocalManualCompletion() {
        this.lock.lock();
        try {
            boolean bl = this.useLocalManualCompletion;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public ManualActivityCompletionClient useLocalManualCompletion() {
        this.lock.lock();
        try {
            this.doNotCompleteOnReturn();
            this.useLocalManualCompletion = true;
            CompletionAwareManualCompletionClient completionAwareManualCompletionClient = new CompletionAwareManualCompletionClient(this.manualCompletionClientFactory.getClient(this.info.getTaskToken(), this.metricsScope), this.completionHandle);
            return completionAwareManualCompletionClient;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public Scope getMetricsScope() {
        return this.metricsScope;
    }

    @Override
    public ActivityInfo getInfo() {
        return this.info;
    }
}

