/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.common.converter;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.google.protobuf.ByteString;
import io.temporal.api.common.v1.Payload;
import io.temporal.common.converter.DataConverterException;
import io.temporal.common.converter.EncodingKeys;
import io.temporal.common.converter.PayloadConverter;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Optional;

public class JacksonJsonPayloadConverter
implements PayloadConverter {
    private final ObjectMapper mapper;

    public JacksonJsonPayloadConverter() {
        this.mapper = new ObjectMapper();
        this.mapper.configure(DeserializationFeature.ADJUST_DATES_TO_CONTEXT_TIME_ZONE, false);
        this.mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        this.mapper.registerModule((Module)new JavaTimeModule());
        this.mapper.registerModule((Module)new Jdk8Module());
        this.mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
    }

    public JacksonJsonPayloadConverter(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    @Override
    public String getEncodingType() {
        return "json/plain";
    }

    @Override
    public Optional<Payload> toData(Object value) throws DataConverterException {
        try {
            byte[] serialized = this.mapper.writeValueAsBytes(value);
            return Optional.of(Payload.newBuilder().putMetadata("encoding", EncodingKeys.METADATA_ENCODING_JSON).setData(ByteString.copyFrom((byte[])serialized)).build());
        }
        catch (JsonProcessingException e) {
            throw new DataConverterException(e);
        }
    }

    @Override
    public <T> T fromData(Payload content, Class<T> valueClass, Type valueType) throws DataConverterException {
        ByteString data = content.getData();
        if (data.isEmpty()) {
            return null;
        }
        try {
            JavaType reference = this.mapper.getTypeFactory().constructType(valueType, valueClass);
            return (T)this.mapper.readValue(content.getData().toByteArray(), reference);
        }
        catch (IOException e) {
            throw new DataConverterException(e);
        }
    }
}

