/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.client;

import io.temporal.api.common.v1.WorkflowExecution;
import io.temporal.client.ActivityCompletionClient;
import io.temporal.client.BatchRequest;
import io.temporal.client.WorkflowClientOptions;
import io.temporal.client.WorkflowOptions;
import io.temporal.client.WorkflowStub;
import io.temporal.internal.sync.WorkflowClientInternal;
import io.temporal.serviceclient.WorkflowServiceStubs;
import io.temporal.workflow.Functions;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

public interface WorkflowClient {
    public static final String QUERY_TYPE_STACK_TRACE = "__stack_trace";
    public static final String QUERY_TYPE_REPLAY_ONLY = "__replay_only";

    public static WorkflowClient newInstance(WorkflowServiceStubs service) {
        return WorkflowClientInternal.newInstance(service, WorkflowClientOptions.getDefaultInstance());
    }

    public static WorkflowClient newInstance(WorkflowServiceStubs service, WorkflowClientOptions options) {
        return WorkflowClientInternal.newInstance(service, options);
    }

    public WorkflowClientOptions getOptions();

    public <T> T newWorkflowStub(Class<T> var1, WorkflowOptions var2);

    public <T> T newWorkflowStub(Class<T> var1, String var2);

    public <T> T newWorkflowStub(Class<T> var1, String var2, Optional<String> var3);

    public WorkflowStub newUntypedWorkflowStub(String var1);

    public WorkflowStub newUntypedWorkflowStub(String var1, WorkflowOptions var2);

    public WorkflowStub newUntypedWorkflowStub(String var1, Optional<String> var2, Optional<String> var3);

    public WorkflowStub newUntypedWorkflowStub(WorkflowExecution var1, Optional<String> var2);

    public ActivityCompletionClient newActivityCompletionClient();

    public BatchRequest newSignalWithStartRequest();

    public WorkflowExecution signalWithStart(BatchRequest var1);

    public WorkflowServiceStubs getWorkflowServiceStubs();

    public static WorkflowExecution start(Functions.Proc workflow) {
        return WorkflowClientInternal.start(workflow);
    }

    public static <A1> WorkflowExecution start(Functions.Proc1<A1> workflow, A1 arg1) {
        return WorkflowClientInternal.start(workflow, arg1);
    }

    public static <A1, A2> WorkflowExecution start(Functions.Proc2<A1, A2> workflow, A1 arg1, A2 arg2) {
        return WorkflowClientInternal.start(workflow, arg1, arg2);
    }

    public static <A1, A2, A3> WorkflowExecution start(Functions.Proc3<A1, A2, A3> workflow, A1 arg1, A2 arg2, A3 arg3) {
        return WorkflowClientInternal.start(workflow, arg1, arg2, arg3);
    }

    public static <A1, A2, A3, A4> WorkflowExecution start(Functions.Proc4<A1, A2, A3, A4> workflow, A1 arg1, A2 arg2, A3 arg3, A4 arg4) {
        return WorkflowClientInternal.start(workflow, arg1, arg2, arg3, arg4);
    }

    public static <A1, A2, A3, A4, A5> WorkflowExecution start(Functions.Proc5<A1, A2, A3, A4, A5> workflow, A1 arg1, A2 arg2, A3 arg3, A4 arg4, A5 arg5) {
        return WorkflowClientInternal.start(workflow, arg1, arg2, arg3, arg4, arg5);
    }

    public static <A1, A2, A3, A4, A5, A6> WorkflowExecution start(Functions.Proc6<A1, A2, A3, A4, A5, A6> workflow, A1 arg1, A2 arg2, A3 arg3, A4 arg4, A5 arg5, A6 arg6) {
        return WorkflowClientInternal.start(workflow, arg1, arg2, arg3, arg4, arg5, arg6);
    }

    public static <R> WorkflowExecution start(Functions.Func<R> workflow) {
        return WorkflowClientInternal.start(workflow);
    }

    public static <A1, R> WorkflowExecution start(Functions.Func1<A1, R> workflow, A1 arg1) {
        return WorkflowClientInternal.start(workflow, arg1);
    }

    public static <A1, A2, R> WorkflowExecution start(Functions.Func2<A1, A2, R> workflow, A1 arg1, A2 arg2) {
        return WorkflowClientInternal.start(workflow, arg1, arg2);
    }

    public static <A1, A2, A3, R> WorkflowExecution start(Functions.Func3<A1, A2, A3, R> workflow, A1 arg1, A2 arg2, A3 arg3) {
        return WorkflowClientInternal.start(workflow, arg1, arg2, arg3);
    }

    public static <A1, A2, A3, A4, R> WorkflowExecution start(Functions.Func4<A1, A2, A3, A4, R> workflow, A1 arg1, A2 arg2, A3 arg3, A4 arg4) {
        return WorkflowClientInternal.start(workflow, arg1, arg2, arg3, arg4);
    }

    public static <A1, A2, A3, A4, A5, R> WorkflowExecution start(Functions.Func5<A1, A2, A3, A4, A5, R> workflow, A1 arg1, A2 arg2, A3 arg3, A4 arg4, A5 arg5) {
        return WorkflowClientInternal.start(workflow, arg1, arg2, arg3, arg4, arg5);
    }

    public static <A1, A2, A3, A4, A5, A6, R> WorkflowExecution start(Functions.Func6<A1, A2, A3, A4, A5, A6, R> workflow, A1 arg1, A2 arg2, A3 arg3, A4 arg4, A5 arg5, A6 arg6) {
        return WorkflowClientInternal.start(workflow, arg1, arg2, arg3, arg4, arg5, arg6);
    }

    public static CompletableFuture<Void> execute(Functions.Proc workflow) {
        return WorkflowClientInternal.execute(workflow);
    }

    public static <A1> CompletableFuture<Void> execute(Functions.Proc1<A1> workflow, A1 arg1) {
        return WorkflowClientInternal.execute(workflow, arg1);
    }

    public static <A1, A2> CompletableFuture<Void> execute(Functions.Proc2<A1, A2> workflow, A1 arg1, A2 arg2) {
        return WorkflowClientInternal.execute(workflow, arg1, arg2);
    }

    public static <A1, A2, A3> CompletableFuture<Void> execute(Functions.Proc3<A1, A2, A3> workflow, A1 arg1, A2 arg2, A3 arg3) {
        return WorkflowClientInternal.execute(workflow, arg1, arg2, arg3);
    }

    public static <A1, A2, A3, A4> CompletableFuture<Void> execute(Functions.Proc4<A1, A2, A3, A4> workflow, A1 arg1, A2 arg2, A3 arg3, A4 arg4) {
        return WorkflowClientInternal.execute(workflow, arg1, arg2, arg3, arg4);
    }

    public static <A1, A2, A3, A4, A5> CompletableFuture<Void> execute(Functions.Proc5<A1, A2, A3, A4, A5> workflow, A1 arg1, A2 arg2, A3 arg3, A4 arg4, A5 arg5) {
        return WorkflowClientInternal.execute(workflow, arg1, arg2, arg3, arg4, arg5);
    }

    public static <A1, A2, A3, A4, A5, A6> CompletableFuture<Void> execute(Functions.Proc6<A1, A2, A3, A4, A5, A6> workflow, A1 arg1, A2 arg2, A3 arg3, A4 arg4, A5 arg5, A6 arg6) {
        return WorkflowClientInternal.execute(workflow, arg1, arg2, arg3, arg4, arg5, arg6);
    }

    public static <R> CompletableFuture<R> execute(Functions.Func<R> workflow) {
        return WorkflowClientInternal.execute(workflow);
    }

    public static <A1, R> CompletableFuture<R> execute(Functions.Func1<A1, R> workflow, A1 arg1) {
        return WorkflowClientInternal.execute(workflow, arg1);
    }

    public static <A1, A2, R> CompletableFuture<R> execute(Functions.Func2<A1, A2, R> workflow, A1 arg1, A2 arg2) {
        return WorkflowClientInternal.execute(workflow, arg1, arg2);
    }

    public static <A1, A2, A3, R> CompletableFuture<R> execute(Functions.Func3<A1, A2, A3, R> workflow, A1 arg1, A2 arg2, A3 arg3) {
        return WorkflowClientInternal.execute(workflow, arg1, arg2, arg3);
    }

    public static <A1, A2, A3, A4, R> CompletableFuture<R> execute(Functions.Func4<A1, A2, A3, A4, R> workflow, A1 arg1, A2 arg2, A3 arg3, A4 arg4) {
        return WorkflowClientInternal.execute(workflow, arg1, arg2, arg3, arg4);
    }

    public static <A1, A2, A3, A4, A5, R> CompletableFuture<R> execute(Functions.Func5<A1, A2, A3, A4, A5, R> workflow, A1 arg1, A2 arg2, A3 arg3, A4 arg4, A5 arg5) {
        return WorkflowClientInternal.execute(workflow, arg1, arg2, arg3, arg4, arg5);
    }

    public static <A1, A2, A3, A4, A5, A6, R> CompletableFuture<R> execute(Functions.Func6<A1, A2, A3, A4, A5, A6, R> workflow, A1 arg1, A2 arg2, A3 arg3, A4 arg4, A5 arg5, A6 arg6) {
        return WorkflowClientInternal.execute(workflow, arg1, arg2, arg3, arg4, arg5, arg6);
    }
}

