/*
 *  Copyright (C) 2020 Temporal Technologies, Inc. All Rights Reserved.
 *
 *  Copyright 2012-2016 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Modifications copyright (C) 2017 Uber Technologies, Inc.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not
 *  use this file except in compliance with the License. A copy of the License is
 *  located at
 *
 *  http://aws.amazon.com/apache2.0
 *
 *  or in the "license" file accompanying this file. This file is distributed on
 *  an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 *  express or implied. See the License for the specific language governing
 *  permissions and limitations under the License.
 */

package io.temporal.internal.statemachines;

/**
 * Thrown when {@link io.temporal.workflow.Workflow#getVersion(String, int, int)} detects that the
 * workflow history was generated by a code that doesn't comply with specified min and max versions.
 *
 * <p>The reason this class extends Error is for application workflow code to not catch it by
 * mistake. The default behavior of the SDK is to block workflow execution while Error is thrown.
 */
public class UnsupportedVersion extends Error {
  public UnsupportedVersion(String message) {
    super(message);
  }

  public UnsupportedVersion(UnsupportedVersionException e) {
    super(e.getMessage(), e);
  }

  public static class UnsupportedVersionException extends RuntimeException {
    public UnsupportedVersionException(String message) {
      super(message);
    }
  }
}
