/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.sync;

import com.google.protobuf.Timestamp;
import com.google.protobuf.util.Timestamps;
import io.temporal.api.common.v1.Header;
import io.temporal.api.common.v1.Payloads;
import io.temporal.api.workflowservice.v1.PollActivityTaskQueueResponse;
import io.temporal.internal.common.ProtobufTimeUtils;
import io.temporal.internal.sync.ActivityInfoInternal;
import io.temporal.workflow.Functions;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;

final class ActivityInfoImpl
implements ActivityInfoInternal {
    private final PollActivityTaskQueueResponse response;
    private final String activityNamespace;
    private final boolean local;
    private final Functions.Proc completionHandle;

    ActivityInfoImpl(PollActivityTaskQueueResponse response, String activityNamespace, boolean local, Functions.Proc completionHandle) {
        this.response = Objects.requireNonNull(response);
        this.activityNamespace = Objects.requireNonNull(activityNamespace);
        this.local = local;
        this.completionHandle = completionHandle;
    }

    @Override
    public byte[] getTaskToken() {
        return this.response.getTaskToken().toByteArray();
    }

    @Override
    public String getWorkflowId() {
        return this.response.getWorkflowExecution().getWorkflowId();
    }

    @Override
    public String getRunId() {
        return this.response.getWorkflowExecution().getRunId();
    }

    @Override
    public String getActivityId() {
        return this.response.getActivityId();
    }

    @Override
    public String getActivityType() {
        return this.response.getActivityType().getName();
    }

    @Override
    public long getScheduledTimestamp() {
        return Timestamps.toMillis((Timestamp)this.response.getCurrentAttemptScheduledTime());
    }

    @Override
    public Duration getScheduleToCloseTimeout() {
        return ProtobufTimeUtils.toJavaDuration(this.response.getScheduleToCloseTimeout());
    }

    @Override
    public Duration getStartToCloseTimeout() {
        return ProtobufTimeUtils.toJavaDuration(this.response.getStartToCloseTimeout());
    }

    @Override
    public Duration getHeartbeatTimeout() {
        return ProtobufTimeUtils.toJavaDuration(this.response.getHeartbeatTimeout());
    }

    @Override
    public Optional<Payloads> getHeartbeatDetails() {
        if (this.response.hasHeartbeatDetails()) {
            return Optional.of(this.response.getHeartbeatDetails());
        }
        return Optional.empty();
    }

    @Override
    public String getWorkflowType() {
        return this.response.getWorkflowType().getName();
    }

    @Override
    public String getWorkflowNamespace() {
        return this.response.getWorkflowNamespace();
    }

    @Override
    public String getActivityNamespace() {
        return this.activityNamespace;
    }

    @Override
    public int getAttempt() {
        return this.response.getAttempt();
    }

    @Override
    public boolean isLocal() {
        return this.local;
    }

    @Override
    public Functions.Proc getCompletionHandle() {
        return this.completionHandle;
    }

    @Override
    public Optional<Payloads> getInput() {
        if (this.response.hasInput()) {
            return Optional.of(this.response.getInput());
        }
        return Optional.empty();
    }

    @Override
    public Header getHeader() {
        return this.response.getHeader();
    }
}

