/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.common;

import io.temporal.api.common.v1.Header;
import io.temporal.api.common.v1.Payload;
import io.temporal.common.converter.DataConverter;
import io.temporal.common.converter.DataConverterException;
import io.temporal.common.interceptors.Header;
import java.util.HashMap;
import java.util.Map;

public class HeaderUtils {
    public static io.temporal.api.common.v1.Header toHeaderGrpc(Header header, Header overrides) {
        Header.Builder builder = io.temporal.api.common.v1.Header.newBuilder().putAllFields(header.getValues());
        if (overrides != null) {
            for (Map.Entry<String, Payload> item : overrides.getValues().entrySet()) {
                builder.putFields(item.getKey(), item.getValue());
            }
        }
        return builder.build();
    }

    public static Map<String, Payload> intoPayloadMapWithDefaultConverter(Map<String, Object> map) {
        if (map == null) {
            return null;
        }
        DataConverter dataConverter = DataConverter.getDefaultInstance();
        HashMap<String, Payload> result = new HashMap<String, Payload>();
        for (Map.Entry<String, Object> item : map.entrySet()) {
            try {
                result.put(item.getKey(), dataConverter.toPayload(item.getValue()).get());
            }
            catch (DataConverterException e) {
                throw new DataConverterException("Cannot serialize key " + item.getKey(), e.getCause());
            }
        }
        return result;
    }

    private HeaderUtils() {
    }
}

