/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.common.metadata;

import com.google.common.base.Objects;
import io.temporal.common.metadata.POJOWorkflowMethod;
import io.temporal.common.metadata.POJOWorkflowMethodMetadata;
import io.temporal.common.metadata.WorkflowMethodType;
import io.temporal.workflow.WorkflowInterface;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public final class POJOWorkflowInterfaceMetadata {
    private POJOWorkflowMethodMetadata workflowMethod;
    private final Class<?> interfaceClass;
    private final Map<Method, POJOWorkflowMethodMetadata> methods = new HashMap<Method, POJOWorkflowMethodMetadata>();

    public static POJOWorkflowInterfaceMetadata newInstance(Class<?> anInterface) {
        return POJOWorkflowInterfaceMetadata.newInstance(anInterface, true);
    }

    public static POJOWorkflowInterfaceMetadata newInstanceSkipWorkflowAnnotationCheck(Class<?> anInterface) {
        return POJOWorkflowInterfaceMetadata.newInstance(anInterface, false);
    }

    private static POJOWorkflowInterfaceMetadata newInstance(Class<?> anInterface, boolean checkWorkflowInterfaceAnnotation) {
        if (!anInterface.isInterface()) {
            throw new IllegalArgumentException("Not an interface: " + anInterface);
        }
        if (checkWorkflowInterfaceAnnotation) {
            WorkflowInterface annotation = anInterface.getAnnotation(WorkflowInterface.class);
            if (annotation == null) {
                throw new IllegalArgumentException("Missing required @WorkflowInterface annotation: " + anInterface);
            }
            POJOWorkflowInterfaceMetadata.validatePublicModifier(anInterface);
        }
        POJOWorkflowInterfaceMetadata result = new POJOWorkflowInterfaceMetadata(anInterface, false);
        if (result.methods.isEmpty() && checkWorkflowInterfaceAnnotation) {
            throw new IllegalArgumentException("Interface doesn't contain any methods: " + anInterface.getName());
        }
        return result;
    }

    private static void validatePublicModifier(Class<?> anInterface) {
        if (!Modifier.isPublic(anInterface.getModifiers())) {
            throw new IllegalArgumentException("Interface with @WorkflowInterface annotation must be public: " + anInterface);
        }
    }

    static POJOWorkflowInterfaceMetadata newImplementationInterface(Class<?> anInterface) {
        return new POJOWorkflowInterfaceMetadata(anInterface, true);
    }

    private POJOWorkflowInterfaceMetadata(Class<?> anInterface, boolean implementation) {
        this.interfaceClass = anInterface;
        HashMap<EqualsByMethodName, Method> dedupeMap = new HashMap<EqualsByMethodName, Method>();
        this.getWorkflowInterfaceMethods(anInterface, !implementation, dedupeMap);
    }

    public Optional<POJOWorkflowMethodMetadata> getWorkflowMethod() {
        return Optional.ofNullable(this.workflowMethod);
    }

    public Class<?> getInterfaceClass() {
        return this.interfaceClass;
    }

    public Optional<String> getWorkflowType() {
        if (this.workflowMethod == null) {
            return Optional.empty();
        }
        return Optional.of(this.workflowMethod.getName());
    }

    public POJOWorkflowMethodMetadata getMethodMetadata(Method method) {
        POJOWorkflowMethodMetadata result = this.methods.get(method);
        if (result == null) {
            throw new IllegalArgumentException("Unknown method: " + method);
        }
        return result;
    }

    public List<POJOWorkflowMethodMetadata> getMethodsMetadata() {
        return new ArrayList<POJOWorkflowMethodMetadata>(this.methods.values());
    }

    private Set<POJOWorkflowMethod> getWorkflowInterfaceMethods(Class<?> current, boolean rootClass, Map<EqualsByMethodName, Method> dedupeMap) {
        WorkflowInterface annotation = current.getAnnotation(WorkflowInterface.class);
        if (annotation != null) {
            POJOWorkflowInterfaceMetadata.validatePublicModifier(current);
        }
        HashSet<POJOWorkflowMethod> result = new HashSet<POJOWorkflowMethod>();
        Class<?>[] interfaces = current.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            Class<?> anInterface = interfaces[i];
            Set<POJOWorkflowMethod> parentMethods = this.getWorkflowInterfaceMethods(anInterface, false, dedupeMap);
            for (POJOWorkflowMethod parentMethod : parentMethods) {
                block13: {
                    if (parentMethod.getType() == WorkflowMethodType.NONE) {
                        Method method = parentMethod.getMethod();
                        try {
                            current.getMethod(method.getName(), method.getParameterTypes());
                            continue;
                        }
                        catch (NoSuchMethodException e) {
                            if (annotation == null) break block13;
                            throw new IllegalArgumentException("Missing @WorkflowMethod, @SignalMethod or @QueryMethod annotation on " + method);
                        }
                    }
                }
                result.add(parentMethod);
            }
        }
        Method[] declaredMethods = current.getDeclaredMethods();
        for (int i = 0; i < declaredMethods.length; ++i) {
            Method declaredMethod = declaredMethods[i];
            POJOWorkflowMethod methodMetadata = new POJOWorkflowMethod(declaredMethod);
            result.add(methodMetadata);
        }
        if (annotation == null && !rootClass) {
            return result;
        }
        for (POJOWorkflowMethod workflowMethod : result) {
            Method method = workflowMethod.getMethod();
            if (workflowMethod.getType() == WorkflowMethodType.NONE && annotation != null) {
                throw new IllegalArgumentException("Missing @WorkflowMethod, @SignalMethod or @QueryMethod annotation on " + method);
            }
            EqualsByMethodName wrapped = new EqualsByMethodName(method);
            Method registered = dedupeMap.put(wrapped, method);
            if (registered != null && !registered.equals(method)) {
                throw new IllegalArgumentException("Duplicated methods (overloads are not allowed): \"" + registered + "\" and \"" + method + "\"");
            }
            if (workflowMethod.getType() == WorkflowMethodType.NONE && annotation == null) continue;
            POJOWorkflowMethodMetadata methodMetadata = new POJOWorkflowMethodMetadata(workflowMethod, current);
            if (workflowMethod.getType() == WorkflowMethodType.WORKFLOW) {
                if (this.workflowMethod != null) {
                    throw new IllegalArgumentException("Duplicated @WorkflowMethod: " + workflowMethod.getMethod() + " and " + this.workflowMethod.getWorkflowMethod());
                }
                this.workflowMethod = methodMetadata;
            }
            this.methods.put(method, methodMetadata);
        }
        return Collections.emptySet();
    }

    private static class EqualsByMethodName {
        private final Method method;

        EqualsByMethodName(Method method) {
            this.method = method;
        }

        public Method getMethod() {
            return this.method;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EqualsByMethodName that = (EqualsByMethodName)o;
            return Objects.equal((Object)this.method.getName(), (Object)that.method.getName());
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.method.getName()});
        }
    }
}

