/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.sync;

import com.google.common.base.Preconditions;
import io.temporal.api.common.v1.Payloads;
import io.temporal.api.common.v1.WorkflowType;
import io.temporal.api.failure.v1.Failure;
import io.temporal.common.context.ContextPropagator;
import io.temporal.common.converter.DataConverter;
import io.temporal.common.interceptors.Header;
import io.temporal.common.interceptors.WorkerInterceptor;
import io.temporal.common.interceptors.WorkflowInboundCallsInterceptor;
import io.temporal.common.interceptors.WorkflowOutboundCallsInterceptor;
import io.temporal.common.metadata.POJOWorkflowImplMetadata;
import io.temporal.common.metadata.POJOWorkflowInterfaceMetadata;
import io.temporal.common.metadata.POJOWorkflowMethodMetadata;
import io.temporal.failure.CanceledFailure;
import io.temporal.failure.FailureConverter;
import io.temporal.failure.TemporalFailure;
import io.temporal.internal.common.CheckedExceptionWrapper;
import io.temporal.internal.replay.ReplayWorkflow;
import io.temporal.internal.replay.ReplayWorkflowFactory;
import io.temporal.internal.replay.WorkflowExecutorCache;
import io.temporal.internal.sync.DestroyWorkflowThreadError;
import io.temporal.internal.sync.DynamicSyncWorkflowDefinition;
import io.temporal.internal.sync.SyncWorkflow;
import io.temporal.internal.sync.SyncWorkflowContext;
import io.temporal.internal.sync.SyncWorkflowDefinition;
import io.temporal.internal.sync.WorkflowInternal;
import io.temporal.internal.worker.WorkflowExecutionException;
import io.temporal.worker.WorkflowImplementationOptions;
import io.temporal.workflow.DynamicWorkflow;
import io.temporal.workflow.Functions;
import io.temporal.workflow.Workflow;
import io.temporal.workflow.WorkflowInfo;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class POJOWorkflowImplementationFactory
implements ReplayWorkflowFactory {
    private static final Logger log = LoggerFactory.getLogger(POJOWorkflowImplementationFactory.class);
    private final WorkerInterceptor[] workerInterceptors;
    private DataConverter dataConverter;
    private final List<ContextPropagator> contextPropagators;
    private final Map<String, Functions.Func<SyncWorkflowDefinition>> workflowDefinitions = Collections.synchronizedMap(new HashMap());
    private final Map<String, WorkflowImplementationOptions> implementationOptions = Collections.synchronizedMap(new HashMap());
    private final Map<Class<?>, Functions.Func<?>> workflowImplementationFactories = Collections.synchronizedMap(new HashMap());
    private Functions.Func<? extends DynamicWorkflow> dynamicWorkflowImplementationFactory;
    private final ExecutorService threadPool;
    private final WorkflowExecutorCache cache;

    POJOWorkflowImplementationFactory(DataConverter dataConverter, ExecutorService threadPool, WorkerInterceptor[] workerInterceptors, WorkflowExecutorCache cache, List<ContextPropagator> contextPropagators) {
        this.dataConverter = Objects.requireNonNull(dataConverter);
        this.threadPool = Objects.requireNonNull(threadPool);
        this.workerInterceptors = Objects.requireNonNull(workerInterceptors);
        this.cache = cache;
        this.contextPropagators = contextPropagators;
    }

    void registerWorkflowImplementationTypes(WorkflowImplementationOptions options, Class<?>[] workflowImplementationTypes) {
        for (Class<?> type : workflowImplementationTypes) {
            this.registerWorkflowImplementationType(options, type);
        }
    }

    <R> void addWorkflowImplementationFactory(Class<R> clazz, Functions.Func<R> factory) {
        WorkflowImplementationOptions unitTestingOptions = WorkflowImplementationOptions.newBuilder().setFailWorkflowExceptionTypes(Throwable.class).build();
        this.addWorkflowImplementationFactory(unitTestingOptions, clazz, factory);
    }

    <R> void addWorkflowImplementationFactory(WorkflowImplementationOptions options, Class<R> clazz, Functions.Func<R> factory) {
        if (DynamicWorkflow.class.isAssignableFrom(clazz)) {
            if (this.dynamicWorkflowImplementationFactory != null) {
                throw new IllegalStateException("An implementation of DynamicWorkflow or its factory is already registered with the worker");
            }
            this.dynamicWorkflowImplementationFactory = factory;
            return;
        }
        this.workflowImplementationFactories.put(clazz, factory);
        POJOWorkflowInterfaceMetadata workflowMetadata = POJOWorkflowInterfaceMetadata.newInstance(clazz);
        if (!workflowMetadata.getWorkflowMethod().isPresent()) {
            throw new IllegalArgumentException("Workflow interface doesn't contain a method annotated with @WorkflowMethod: " + clazz);
        }
        List<POJOWorkflowMethodMetadata> methodsMetadata = workflowMetadata.getMethodsMetadata();
        for (POJOWorkflowMethodMetadata methodMetadata : methodsMetadata) {
            switch (methodMetadata.getType()) {
                case WORKFLOW: {
                    String workflowName = methodMetadata.getName();
                    if (this.workflowDefinitions.containsKey(workflowName)) {
                        throw new IllegalStateException(workflowName + " workflow type is already registered with the worker");
                    }
                    this.workflowDefinitions.put(workflowName, () -> new POJOWorkflowImplementation(clazz, methodMetadata.getWorkflowMethod()));
                    this.implementationOptions.put(workflowName, options);
                    break;
                }
            }
        }
    }

    private <T> void registerWorkflowImplementationType(WorkflowImplementationOptions options, Class<T> workflowImplementationClass) {
        if (DynamicWorkflow.class.isAssignableFrom(workflowImplementationClass)) {
            this.addWorkflowImplementationFactory(options, workflowImplementationClass, () -> {
                try {
                    return workflowImplementationClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    throw new Error("Failure instantiating workflow implementation class " + workflowImplementationClass.getName(), e);
                }
            });
            return;
        }
        boolean hasWorkflowMethod = false;
        POJOWorkflowImplMetadata workflowMetadata = POJOWorkflowImplMetadata.newInstance(workflowImplementationClass);
        for (POJOWorkflowInterfaceMetadata workflowInterface : workflowMetadata.getWorkflowInterfaces()) {
            Optional<POJOWorkflowMethodMetadata> workflowMethod = workflowInterface.getWorkflowMethod();
            if (!workflowMethod.isPresent()) continue;
            POJOWorkflowMethodMetadata methodMetadata = workflowMethod.get();
            Method method = methodMetadata.getWorkflowMethod();
            Functions.Func<SyncWorkflowDefinition> factory = () -> new POJOWorkflowImplementation(workflowImplementationClass, method);
            String workflowName = methodMetadata.getName();
            if (this.workflowDefinitions.containsKey(workflowName)) {
                throw new IllegalStateException(workflowName + " workflow type is already registered with the worker");
            }
            this.workflowDefinitions.put(workflowName, factory);
            this.implementationOptions.put(workflowName, options);
            hasWorkflowMethod = true;
        }
        if (!hasWorkflowMethod) {
            throw new IllegalArgumentException("Workflow implementation doesn't implement any interface with a workflow method annotated with @WorkflowMethod: " + workflowImplementationClass);
        }
    }

    private SyncWorkflowDefinition getWorkflowDefinition(WorkflowType workflowType) {
        Functions.Func<SyncWorkflowDefinition> factory = this.workflowDefinitions.get(workflowType.getName());
        if (factory == null) {
            if (this.dynamicWorkflowImplementationFactory != null) {
                return new DynamicSyncWorkflowDefinition(this.dynamicWorkflowImplementationFactory, this.workerInterceptors, this.dataConverter);
            }
            throw new Error("Unknown workflow type \"" + workflowType.getName() + "\". Known types are " + this.workflowDefinitions.keySet());
        }
        try {
            return factory.apply();
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    public void setDataConverter(DataConverter dataConverter) {
        this.dataConverter = dataConverter;
    }

    @Override
    public ReplayWorkflow getWorkflow(WorkflowType workflowType) {
        SyncWorkflowDefinition workflow = this.getWorkflowDefinition(workflowType);
        WorkflowImplementationOptions options = this.implementationOptions.get(workflowType.getName());
        return new SyncWorkflow(workflow, options, this.dataConverter, this.threadPool, this.cache, this.contextPropagators);
    }

    @Override
    public boolean isAnyTypeSupported() {
        return !this.workflowDefinitions.isEmpty() || this.dynamicWorkflowImplementationFactory != null;
    }

    static WorkflowExecutionException mapToWorkflowExecutionException(Throwable exception, DataConverter dataConverter) {
        for (Throwable e = exception; e != null; e = e.getCause()) {
            if (!(e instanceof TemporalFailure)) continue;
            ((TemporalFailure)e).setDataConverter(dataConverter);
        }
        Failure failure = FailureConverter.exceptionToFailure(exception);
        return new WorkflowExecutionException(failure);
    }

    public String toString() {
        return "POJOWorkflowImplementationFactory{registeredWorkflowTypes=" + this.workflowDefinitions.keySet() + '}';
    }

    private class POJOWorkflowImplementation
    implements SyncWorkflowDefinition {
        private final Method workflowMethod;
        private final Class<?> workflowImplementationClass;
        private Object workflow;
        private WorkflowInboundCallsInterceptor workflowInvoker;

        public POJOWorkflowImplementation(Class<?> workflowImplementationClass, Method workflowMethod) {
            this.workflowMethod = workflowMethod;
            this.workflowImplementationClass = workflowImplementationClass;
        }

        @Override
        public void initialize() {
            SyncWorkflowContext workflowContext = WorkflowInternal.getRootWorkflowContext();
            this.workflowInvoker = new RootWorkflowInboundCallsInterceptor(workflowContext);
            for (WorkerInterceptor workerInterceptor : POJOWorkflowImplementationFactory.this.workerInterceptors) {
                this.workflowInvoker = workerInterceptor.interceptWorkflow(this.workflowInvoker);
            }
            workflowContext.setHeadInboundCallsInterceptor(this.workflowInvoker);
            this.workflowInvoker.init(workflowContext);
        }

        @Override
        public Optional<Payloads> execute(Header header, Optional<Payloads> input) throws CanceledFailure, WorkflowExecutionException {
            Object[] args = DataConverter.arrayFromPayloads(POJOWorkflowImplementationFactory.this.dataConverter, input, this.workflowMethod.getParameterTypes(), this.workflowMethod.getGenericParameterTypes());
            Preconditions.checkNotNull((Object)this.workflowInvoker, (Object)"initialize not called");
            WorkflowInboundCallsInterceptor.WorkflowOutput result = this.workflowInvoker.execute(new WorkflowInboundCallsInterceptor.WorkflowInput(header, args));
            if (this.workflowMethod.getReturnType() == Void.TYPE) {
                return Optional.empty();
            }
            return POJOWorkflowImplementationFactory.this.dataConverter.toPayloads(result.getResult());
        }

        private void newInstance() {
            if (this.workflow != null) {
                throw new IllegalStateException("Already called");
            }
            Functions.Func factory = (Functions.Func)POJOWorkflowImplementationFactory.this.workflowImplementationFactories.get(this.workflowImplementationClass);
            if (factory != null) {
                this.workflow = factory.apply();
            } else {
                try {
                    this.workflow = this.workflowImplementationClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    throw new Error("Failure instantiating workflow implementation class " + this.workflowImplementationClass.getName(), e);
                }
            }
        }

        private class RootWorkflowInboundCallsInterceptor
        implements WorkflowInboundCallsInterceptor {
            private final SyncWorkflowContext workflowContext;

            public RootWorkflowInboundCallsInterceptor(SyncWorkflowContext workflowContext) {
                this.workflowContext = workflowContext;
            }

            @Override
            public WorkflowInboundCallsInterceptor.WorkflowOutput execute(WorkflowInboundCallsInterceptor.WorkflowInput input) {
                WorkflowInfo info = Workflow.getInfo();
                try {
                    Object result = POJOWorkflowImplementation.this.workflowMethod.invoke(POJOWorkflowImplementation.this.workflow, input.getArguments());
                    return new WorkflowInboundCallsInterceptor.WorkflowOutput(result);
                }
                catch (IllegalAccessException e) {
                    throw new Error(POJOWorkflowImplementationFactory.mapToWorkflowExecutionException(e, POJOWorkflowImplementationFactory.this.dataConverter));
                }
                catch (InvocationTargetException e) {
                    Throwable target = e.getTargetException();
                    if (target instanceof DestroyWorkflowThreadError) {
                        throw (DestroyWorkflowThreadError)target;
                    }
                    Throwable exception = WorkflowInternal.unwrap(target);
                    WorkflowImplementationOptions options = (WorkflowImplementationOptions)POJOWorkflowImplementationFactory.this.implementationOptions.get(info.getWorkflowType());
                    Class<? extends Throwable>[] failTypes = options.getFailWorkflowExceptionTypes();
                    if (exception instanceof TemporalFailure) {
                        this.logWorkflowExecutionException(info, exception);
                        throw POJOWorkflowImplementationFactory.mapToWorkflowExecutionException(exception, POJOWorkflowImplementationFactory.this.dataConverter);
                    }
                    for (Class<? extends Throwable> failType : failTypes) {
                        boolean cancelRequested;
                        if (!failType.isAssignableFrom(exception.getClass())) continue;
                        if (!(!log.isErrorEnabled() || (cancelRequested = WorkflowInternal.getRootWorkflowContext().getContext().isCancelRequested()) && FailureConverter.isCanceledCause(exception))) {
                            this.logWorkflowExecutionException(info, exception);
                        }
                        throw POJOWorkflowImplementationFactory.mapToWorkflowExecutionException(exception, POJOWorkflowImplementationFactory.this.dataConverter);
                    }
                    throw CheckedExceptionWrapper.wrap(exception);
                }
            }

            private void logWorkflowExecutionException(WorkflowInfo info, Throwable exception) {
                log.error("Workflow execution failure WorkflowId=" + info.getWorkflowId() + ", RunId=" + info.getRunId() + ", WorkflowType=" + info.getWorkflowType(), exception);
            }

            @Override
            public void init(WorkflowOutboundCallsInterceptor outboundCalls) {
                WorkflowInternal.getRootWorkflowContext().setHeadInterceptor(outboundCalls);
                POJOWorkflowImplementation.this.newInstance();
                WorkflowInternal.registerListener(POJOWorkflowImplementation.this.workflow);
            }

            @Override
            public void handleSignal(WorkflowInboundCallsInterceptor.SignalInput input) {
                this.workflowContext.handleInterceptedSignal(input);
            }

            @Override
            public WorkflowInboundCallsInterceptor.QueryOutput handleQuery(WorkflowInboundCallsInterceptor.QueryInput input) {
                return this.workflowContext.handleInterceptedQuery(input);
            }
        }
    }
}

