/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.sync;

import io.temporal.api.common.v1.Payloads;
import io.temporal.common.converter.DataConverter;
import io.temporal.common.converter.EncodedValues;
import io.temporal.common.interceptors.Header;
import io.temporal.common.interceptors.WorkerInterceptor;
import io.temporal.common.interceptors.WorkflowInboundCallsInterceptor;
import io.temporal.common.interceptors.WorkflowOutboundCallsInterceptor;
import io.temporal.internal.sync.SyncWorkflowContext;
import io.temporal.internal.sync.SyncWorkflowDefinition;
import io.temporal.internal.sync.WorkflowInternal;
import io.temporal.workflow.DynamicWorkflow;
import io.temporal.workflow.Functions;
import java.util.Optional;

final class DynamicSyncWorkflowDefinition
implements SyncWorkflowDefinition {
    private final Functions.Func<? extends DynamicWorkflow> factory;
    private final WorkerInterceptor[] workerInterceptors;
    private final DataConverter dataConverter;
    private WorkflowInboundCallsInterceptor workflowInvoker;
    private DynamicWorkflow workflow;

    public DynamicSyncWorkflowDefinition(Functions.Func<? extends DynamicWorkflow> factory, WorkerInterceptor[] workerInterceptors, DataConverter dataConverter) {
        this.factory = factory;
        this.workerInterceptors = workerInterceptors;
        this.dataConverter = dataConverter;
    }

    @Override
    public void initialize() {
        SyncWorkflowContext workflowContext = WorkflowInternal.getRootWorkflowContext();
        this.workflowInvoker = new RootWorkflowInboundCallsInterceptor(workflowContext);
        for (WorkerInterceptor workerInterceptor : this.workerInterceptors) {
            this.workflowInvoker = workerInterceptor.interceptWorkflow(this.workflowInvoker);
        }
        workflowContext.setHeadInboundCallsInterceptor(this.workflowInvoker);
        this.workflowInvoker.init(workflowContext);
    }

    @Override
    public Optional<Payloads> execute(Header header, Optional<Payloads> input) {
        EncodedValues args = new EncodedValues(input, this.dataConverter);
        WorkflowInboundCallsInterceptor.WorkflowOutput result = this.workflowInvoker.execute(new WorkflowInboundCallsInterceptor.WorkflowInput(header, new Object[]{args}));
        return this.dataConverter.toPayloads(result.getResult());
    }

    private class RootWorkflowInboundCallsInterceptor
    implements WorkflowInboundCallsInterceptor {
        private final SyncWorkflowContext workflowContext;

        public RootWorkflowInboundCallsInterceptor(SyncWorkflowContext workflowContext) {
            this.workflowContext = workflowContext;
        }

        @Override
        public void init(WorkflowOutboundCallsInterceptor outboundCalls) {
            WorkflowInternal.getRootWorkflowContext().setHeadInterceptor(outboundCalls);
            this.newInstance();
            WorkflowInternal.registerListener(DynamicSyncWorkflowDefinition.this.workflow);
        }

        @Override
        public WorkflowInboundCallsInterceptor.WorkflowOutput execute(WorkflowInboundCallsInterceptor.WorkflowInput input) {
            Object result = DynamicSyncWorkflowDefinition.this.workflow.execute((EncodedValues)input.getArguments()[0]);
            return new WorkflowInboundCallsInterceptor.WorkflowOutput(result);
        }

        @Override
        public void handleSignal(WorkflowInboundCallsInterceptor.SignalInput input) {
            this.workflowContext.handleInterceptedSignal(input);
        }

        @Override
        public WorkflowInboundCallsInterceptor.QueryOutput handleQuery(WorkflowInboundCallsInterceptor.QueryInput input) {
            return this.workflowContext.handleInterceptedQuery(input);
        }

        private void newInstance() {
            if (DynamicSyncWorkflowDefinition.this.workflow != null) {
                throw new IllegalStateException("Already called");
            }
            DynamicSyncWorkflowDefinition.this.workflow = (DynamicWorkflow)DynamicSyncWorkflowDefinition.this.factory.apply();
        }
    }
}

