/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.sync;

import com.google.common.annotations.VisibleForTesting;
import io.temporal.activity.ActivityOptions;
import io.temporal.common.MethodRetry;
import io.temporal.common.interceptors.WorkflowOutboundCallsInterceptor;
import io.temporal.internal.sync.ActivityInvocationHandlerBase;
import io.temporal.internal.sync.ActivityStubImpl;
import io.temporal.workflow.ActivityStub;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.function.Function;

@VisibleForTesting
public class ActivityInvocationHandler
extends ActivityInvocationHandlerBase {
    private final ActivityOptions options;
    private final WorkflowOutboundCallsInterceptor activityExecutor;

    @VisibleForTesting
    public static InvocationHandler newInstance(Class<?> activityInterface, ActivityOptions options, WorkflowOutboundCallsInterceptor activityExecutor) {
        return new ActivityInvocationHandler(activityInterface, activityExecutor, options);
    }

    private ActivityInvocationHandler(Class<?> activityInterface, WorkflowOutboundCallsInterceptor activityExecutor, ActivityOptions options) {
        this.options = options;
        this.activityExecutor = activityExecutor;
        this.init(activityInterface);
    }

    @Override
    protected Function<Object[], Object> getActivityFunc(Method method, MethodRetry methodRetry, String activityName) {
        ActivityOptions mergedOptions = ActivityOptions.newBuilder(this.options).mergeMethodRetry(methodRetry).build();
        ActivityStub stub = ActivityStubImpl.newInstance(mergedOptions, this.activityExecutor);
        Function<Object[], Object> function = a -> stub.execute(activityName, method.getReturnType(), method.getGenericReturnType(), a);
        return function;
    }
}

