/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.statemachines;

import io.temporal.api.enums.v1.CommandType;
import io.temporal.api.enums.v1.EventType;
import io.temporal.internal.statemachines.DynamicCallback;
import io.temporal.internal.statemachines.DynamicTransitionAction;
import io.temporal.internal.statemachines.FixedTransitionAction;
import io.temporal.internal.statemachines.StateMachine;
import io.temporal.internal.statemachines.Transition;
import io.temporal.internal.statemachines.TransitionAction;
import io.temporal.internal.statemachines.TransitionEvent;
import io.temporal.workflow.Functions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

final class StateMachineDefinition<State, ExplicitEvent, Data> {
    private final Map<Transition<State, TransitionEvent<ExplicitEvent>>, TransitionAction<State, Data>> transitions = new LinkedHashMap<Transition<State, TransitionEvent<ExplicitEvent>>, TransitionAction<State, Data>>();
    private final String name;
    private final State initialState;
    private final List<State> finalStates;
    private final Set<EventType> validEventTypes = new HashSet<EventType>();

    public static <State, ExplicitEvent, Data> StateMachineDefinition<State, ExplicitEvent, Data> newInstance(String name, State initialState, State ... finalStates) {
        return new StateMachineDefinition<State, ExplicitEvent, Data>(name, initialState, finalStates);
    }

    private StateMachineDefinition(String name, State initialState, State[] finalStates) {
        this.name = Objects.requireNonNull(name);
        this.initialState = Objects.requireNonNull(initialState);
        this.finalStates = Arrays.asList(finalStates);
    }

    public String getName() {
        return this.name;
    }

    public State getInitialState() {
        return this.initialState;
    }

    public Set<EventType> getValidEventTypes() {
        return this.validEventTypes;
    }

    StateMachineDefinition<State, ExplicitEvent, Data> add(State from, ExplicitEvent explicitEvent, State to, Functions.Proc1<Data> action) {
        this.checkFinalState(from);
        this.add(new Transition<State, TransitionEvent<ExplicitEvent>>(from, new TransitionEvent<ExplicitEvent>(explicitEvent)), new FixedTransitionAction<State, Data>(to, action));
        return this;
    }

    StateMachineDefinition<State, ExplicitEvent, Data> add(State from, ExplicitEvent explicitEvent, State to) {
        this.checkFinalState(from);
        this.add(new Transition<State, TransitionEvent<ExplicitEvent>>(from, new TransitionEvent<ExplicitEvent>(explicitEvent)), new FixedTransitionAction<State, Object>(to, data -> {}));
        return this;
    }

    StateMachineDefinition<State, ExplicitEvent, Data> add(State from, EventType eventType, State to, Functions.Proc1<Data> action) {
        this.checkFinalState(from);
        this.add(new Transition(from, new TransitionEvent(eventType)), new FixedTransitionAction<State, Data>(to, action));
        this.validEventTypes.add(eventType);
        return this;
    }

    StateMachineDefinition<State, ExplicitEvent, Data> add(State from, EventType eventType, State to) {
        this.checkFinalState(from);
        this.add(new Transition(from, new TransitionEvent(eventType)), new FixedTransitionAction<State, Object>(to, data -> {}));
        this.validEventTypes.add(eventType);
        return this;
    }

    StateMachineDefinition<State, ExplicitEvent, Data> add(State from, EventType eventType, State[] toStates, DynamicCallback<State, Data> action) {
        this.checkFinalState(from);
        this.add(new Transition(from, new TransitionEvent(eventType)), new DynamicTransitionAction<State, Data>(toStates, action));
        this.validEventTypes.add(eventType);
        return this;
    }

    StateMachineDefinition<State, ExplicitEvent, Data> add(State from, CommandType commandType, State to, Functions.Proc1<Data> action) {
        this.checkFinalState(from);
        this.add(new Transition(from, new TransitionEvent(commandType)), new FixedTransitionAction<State, Data>(to, action));
        return this;
    }

    StateMachineDefinition<State, ExplicitEvent, Data> add(State from, CommandType commandType, State to) {
        this.checkFinalState(from);
        this.add(new Transition(from, new TransitionEvent(commandType)), new FixedTransitionAction<State, Object>(to, data -> {}));
        return this;
    }

    StateMachineDefinition<State, ExplicitEvent, Data> add(State from, ExplicitEvent explicitEvent, State[] toStates, DynamicCallback<State, Data> action) {
        this.checkFinalState(from);
        this.add(new Transition<State, TransitionEvent<ExplicitEvent>>(from, new TransitionEvent<ExplicitEvent>(explicitEvent)), new DynamicTransitionAction<State, Data>(toStates, action));
        return this;
    }

    public String toString() {
        return "StateMachine{name='" + this.name + "'}";
    }

    private void checkFinalState(State from) {
        if (this.finalStates.contains(from)) {
            throw new IllegalArgumentException("State transition from a final state is not allowed");
        }
    }

    private void add(Transition<State, TransitionEvent<ExplicitEvent>> transition, TransitionAction<State, Data> target) {
        if (this.transitions.containsKey(transition)) {
            throw new IllegalArgumentException("Duplicated transition is not allowed: " + transition);
        }
        this.transitions.put(transition, target);
    }

    public boolean isFinalState(State state) {
        return this.finalStates.contains(state);
    }

    public String asPlantUMLStateDiagram() {
        StringBuilder result = new StringBuilder();
        result.append("@startuml\n");
        result.append("title ");
        result.append(this.getName());
        result.append(" State Transitions\n");
        result.append("\n[*] --> ");
        result.append(this.initialState);
        result.append('\n');
        ArrayList<Transition> transitionList = new ArrayList<Transition>();
        transitionList.addAll(this.transitions.keySet());
        transitionList.sort(Comparator.comparing(tt -> tt.getFrom().toString()));
        for (Transition transition : transitionList) {
            TransitionAction<State, Data> action = this.transitions.get(transition);
            List<State> targets = action.getAllowedStates();
            for (State target : targets) {
                result.append(transition.getFrom());
                result.append(" --> ");
                result.append(target);
                result.append(": ");
                result.append(transition.getExplicitEvent());
                result.append('\n');
            }
        }
        for (Object finalState : this.finalStates) {
            result.append(finalState);
            result.append(" --> [*]\n");
        }
        result.append("center footer Copyright (C) ");
        result.append("2020");
        result.append(" Temporal Technologies, Inc. All Rights Reserved.\n");
        result.append("@enduml\n");
        return result.toString();
    }

    public List<Transition> getUnvisitedTransitions(List<StateMachine<State, ExplicitEvent, Data>> stateMachines) {
        HashSet<Transition<State, TransitionEvent<ExplicitEvent>>> taken = new HashSet<Transition<State, TransitionEvent<ExplicitEvent>>>();
        for (StateMachine<State, ExplicitEvent, Data> stateMachine : stateMachines) {
            List<Transition<State, TransitionEvent<ExplicitEvent>>> history = stateMachine.getTransitionHistory();
            for (Transition<State, TransitionEvent<ExplicitEvent>> transition : history) {
                taken.add(transition);
            }
        }
        ArrayList<Transition> result = new ArrayList<Transition>();
        for (Transition<State, TransitionEvent<ExplicitEvent>> transition : this.transitions.keySet()) {
            if (taken.contains(transition)) continue;
            result.add(transition);
        }
        return result;
    }

    public String asPlantUMLStateDiagramCoverage(List<StateMachine<State, ExplicitEvent, Data>> stateMachines) {
        HashSet<State> visited = new HashSet<State>();
        HashSet<Transition<State, TransitionEvent<ExplicitEvent>>> taken = new HashSet<Transition<State, TransitionEvent<ExplicitEvent>>>();
        for (StateMachine<State, ExplicitEvent, Data> stateMachine : stateMachines) {
            List<Transition<State, TransitionEvent<ExplicitEvent>>> history = stateMachine.getTransitionHistory();
            for (Transition<State, TransitionEvent<ExplicitEvent>> transition : history) {
                visited.add(transition.getFrom());
                taken.add(transition);
            }
        }
        StringBuilder result = new StringBuilder();
        result.append("@startuml\n");
        result.append("title Test Coverage of ");
        result.append(this.getName());
        result.append(" State Transitions\n");
        result.append("skinparam {\n  ArrowColor green\n  ArrowThickness 2\n}\n\nskinparam state {\n BackgroundColor green\n BorderColor black\n BackgroundColor<<NotCovered>> red\n}\n");
        result.append("[*] --> ");
        result.append(this.initialState);
        result.append('\n');
        ArrayList<Transition> transitionList = new ArrayList<Transition>();
        transitionList.addAll(this.transitions.keySet());
        transitionList.sort(Comparator.comparing(tt -> tt.getFrom().toString()));
        for (Transition transition : transitionList) {
            TransitionAction<State, Data> action = this.transitions.get(transition);
            List<State> targets = action.getAllowedStates();
            for (State target : targets) {
                Object from = transition.getFrom();
                result.append(from);
                if (!visited.contains(from)) {
                    result.append("<< NotCovered >>");
                }
                if (taken.contains(transition)) {
                    result.append(" --> ");
                } else {
                    result.append(" -[#red]-> ");
                }
                result.append(target);
                result.append(": ");
                result.append(transition.getExplicitEvent());
                result.append('\n');
            }
        }
        for (Object finalState : this.finalStates) {
            result.append(finalState);
            result.append(" --> [*]\n");
        }
        result.append("center footer Copyright (C) ");
        result.append("2020");
        result.append(" Temporal Technologies, Inc. All Rights Reserved.\n");
        result.append("@enduml\n");
        return result.toString();
    }

    public TransitionAction<State, Data> getTransitionAction(Transition<State, TransitionEvent<ExplicitEvent>> transition) {
        return this.transitions.get(transition);
    }
}

