/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.statemachines;

import io.temporal.api.command.v1.Command;
import io.temporal.api.command.v1.RecordMarkerCommandAttributes;
import io.temporal.api.common.v1.ActivityType;
import io.temporal.api.common.v1.Payloads;
import io.temporal.api.enums.v1.CommandType;
import io.temporal.api.enums.v1.EventType;
import io.temporal.api.enums.v1.RetryState;
import io.temporal.api.failure.v1.ActivityFailureInfo;
import io.temporal.api.failure.v1.CanceledFailureInfo;
import io.temporal.api.failure.v1.Failure;
import io.temporal.api.history.v1.MarkerRecordedEventAttributes;
import io.temporal.api.workflowservice.v1.PollActivityTaskQueueResponse;
import io.temporal.api.workflowservice.v1.RespondActivityTaskCanceledRequest;
import io.temporal.api.workflowservice.v1.RespondActivityTaskCompletedRequest;
import io.temporal.common.converter.DataConverter;
import io.temporal.failure.FailureConverter;
import io.temporal.internal.replay.ExecuteLocalActivityParameters;
import io.temporal.internal.statemachines.CancellableCommand;
import io.temporal.internal.statemachines.EntityStateMachineInitialCommand;
import io.temporal.internal.statemachines.StateMachine;
import io.temporal.internal.statemachines.StateMachineDefinition;
import io.temporal.internal.worker.ActivityTaskHandler;
import io.temporal.workflow.Functions;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

final class LocalActivityStateMachine
extends EntityStateMachineInitialCommand<State, ExplicitEvent, LocalActivityStateMachine> {
    static final String LOCAL_ACTIVITY_MARKER_NAME = "LocalActivity";
    static final String MARKER_ACTIVITY_ID_KEY = "activityId";
    static final String MARKER_TIME_KEY = "time";
    static final String MARKER_DATA_KEY = "data";
    private final DataConverter dataConverter = DataConverter.getDefaultInstance();
    private final Functions.Proc1<ExecuteLocalActivityParameters> localActivityRequestSink;
    private final Functions.Proc2<Optional<Payloads>, Failure> callback;
    private ExecuteLocalActivityParameters localActivityParameters;
    private final Functions.Func<Boolean> replaying;
    private final Functions.Func1<Long, Long> setCurrentTimeCallback;
    private Failure failure;
    private ActivityTaskHandler.Result result;
    private Optional<Payloads> laResult;
    private final boolean hasRetryPolicy;
    private final String activityId;
    private final ActivityType activityType;
    public static final StateMachineDefinition<State, ExplicitEvent, LocalActivityStateMachine> STATE_MACHINE_DEFINITION = StateMachineDefinition.newInstance("LocalActivity", State.CREATED, State.MARKER_COMMAND_RECORDED).add(State.CREATED, ExplicitEvent.CHECK_EXECUTION_STATE, (State[])new State[]{State.REPLAYING, State.EXECUTING}, LocalActivityStateMachine::getExecutionState).add(State.EXECUTING, ExplicitEvent.SCHEDULE, State.REQUEST_PREPARED, LocalActivityStateMachine::sendRequest).add(State.REQUEST_PREPARED, ExplicitEvent.MARK_AS_SENT, State.REQUEST_SENT).add(State.REQUEST_SENT, ExplicitEvent.NON_REPLAY_WORKFLOW_TASK_STARTED, State.REQUEST_SENT).add(State.REQUEST_SENT, ExplicitEvent.HANDLE_RESULT, State.MARKER_COMMAND_CREATED, LocalActivityStateMachine::createMarker).add(State.MARKER_COMMAND_CREATED, CommandType.COMMAND_TYPE_RECORD_MARKER, State.RESULT_NOTIFIED, LocalActivityStateMachine::notifyResultFromResponse).add(State.RESULT_NOTIFIED, EventType.EVENT_TYPE_MARKER_RECORDED, State.MARKER_COMMAND_RECORDED).add(State.REPLAYING, ExplicitEvent.SCHEDULE, State.WAITING_MARKER_EVENT).add(State.WAITING_MARKER_EVENT, EventType.EVENT_TYPE_MARKER_RECORDED, State.MARKER_COMMAND_RECORDED, LocalActivityStateMachine::notifyResultFromEvent).add(State.WAITING_MARKER_EVENT, ExplicitEvent.NON_REPLAY_WORKFLOW_TASK_STARTED, State.REQUEST_PREPARED, LocalActivityStateMachine::sendRequest);

    public static LocalActivityStateMachine newInstance(Functions.Func<Boolean> replaying, Functions.Func1<Long, Long> setCurrentTimeCallback, ExecuteLocalActivityParameters localActivityParameters, Functions.Proc2<Optional<Payloads>, Failure> callback, Functions.Proc1<ExecuteLocalActivityParameters> localActivityRequestSink, Functions.Proc1<CancellableCommand> commandSink, Functions.Proc1<StateMachine> stateMachineSink) {
        return new LocalActivityStateMachine(replaying, setCurrentTimeCallback, localActivityParameters, callback, localActivityRequestSink, commandSink, stateMachineSink);
    }

    private LocalActivityStateMachine(Functions.Func<Boolean> replaying, Functions.Func1<Long, Long> setCurrentTimeCallback, ExecuteLocalActivityParameters localActivityParameters, Functions.Proc2<Optional<Payloads>, Failure> callback, Functions.Proc1<ExecuteLocalActivityParameters> localActivityRequestSink, Functions.Proc1<CancellableCommand> commandSink, Functions.Proc1<StateMachine> stateMachineSink) {
        super(STATE_MACHINE_DEFINITION, commandSink, stateMachineSink);
        this.replaying = replaying;
        this.setCurrentTimeCallback = setCurrentTimeCallback;
        this.localActivityParameters = localActivityParameters;
        PollActivityTaskQueueResponse.Builder activityTask = localActivityParameters.getActivityTask();
        this.hasRetryPolicy = activityTask.hasRetryPolicy();
        this.activityId = activityTask.getActivityId();
        this.activityType = activityTask.getActivityType();
        this.localActivityRequestSink = localActivityRequestSink;
        this.callback = callback;
        this.explicitEvent(ExplicitEvent.CHECK_EXECUTION_STATE);
        this.explicitEvent(ExplicitEvent.SCHEDULE);
    }

    State getExecutionState() {
        return this.replaying.apply() != false ? State.REPLAYING : State.EXECUTING;
    }

    public void cancel() {
    }

    public void sendRequest() {
        this.localActivityRequestSink.apply(this.localActivityParameters);
        this.localActivityParameters = null;
    }

    public void markAsSent() {
        this.explicitEvent(ExplicitEvent.MARK_AS_SENT);
    }

    public void handleCompletion(ActivityTaskHandler.Result result) {
        this.result = result;
        this.explicitEvent(ExplicitEvent.HANDLE_RESULT);
    }

    public void nonReplayWorkflowTaskStarted() {
        this.explicitEvent(ExplicitEvent.NON_REPLAY_WORKFLOW_TASK_STARTED);
    }

    private void createMarker() {
        RecordMarkerCommandAttributes.Builder markerAttributes = RecordMarkerCommandAttributes.newBuilder();
        HashMap<String, Payloads> details = new HashMap<String, Payloads>();
        if (!this.replaying.apply().booleanValue()) {
            markerAttributes.setMarkerName(LOCAL_ACTIVITY_MARKER_NAME);
            Payloads id = this.dataConverter.toPayloads(this.activityId).get();
            details.put(MARKER_ACTIVITY_ID_KEY, id);
            long currentTime = this.setCurrentTimeCallback.apply(System.currentTimeMillis());
            Payloads t = this.dataConverter.toPayloads(currentTime).get();
            details.put(MARKER_TIME_KEY, t);
            if (this.result.getTaskCompleted() != null) {
                RespondActivityTaskCompletedRequest completed = this.result.getTaskCompleted();
                if (completed.hasResult()) {
                    Payloads p = completed.getResult();
                    this.laResult = Optional.of(p);
                    details.put(MARKER_DATA_KEY, p);
                } else {
                    this.laResult = Optional.empty();
                }
            } else if (this.result.getTaskFailed() != null) {
                ActivityTaskHandler.Result.TaskFailedResult failed = this.result.getTaskFailed();
                RetryState retryState = this.hasRetryPolicy ? RetryState.RETRY_STATE_MAXIMUM_ATTEMPTS_REACHED : RetryState.RETRY_STATE_RETRY_POLICY_NOT_SET;
                this.failure = Failure.newBuilder().setActivityFailureInfo(ActivityFailureInfo.newBuilder().setRetryState(retryState).setActivityId(this.activityId).setActivityType(this.activityType)).setCause(FailureConverter.exceptionToFailure(failed.getFailure())).build();
                markerAttributes.setFailure(this.failure);
            } else if (this.result.getTaskCanceled() != null) {
                RespondActivityTaskCanceledRequest failed = this.result.getTaskCanceled();
                markerAttributes.setFailure(Failure.newBuilder().setCanceledFailureInfo(CanceledFailureInfo.newBuilder().setDetails(failed.getDetails())));
            }
            markerAttributes.putAllDetails(details);
        }
        this.addCommand(Command.newBuilder().setCommandType(CommandType.COMMAND_TYPE_RECORD_MARKER).setRecordMarkerCommandAttributes(markerAttributes.build()).build());
    }

    private void createFakeCommand() {
        this.addCommand(Command.newBuilder().setCommandType(CommandType.COMMAND_TYPE_RECORD_MARKER).setRecordMarkerCommandAttributes(RecordMarkerCommandAttributes.getDefaultInstance()).build());
    }

    private void notifyResultFromEvent() {
        MarkerRecordedEventAttributes attributes = this.currentEvent.getMarkerRecordedEventAttributes();
        if (!attributes.getMarkerName().equals(LOCAL_ACTIVITY_MARKER_NAME)) {
            throw new IllegalStateException("Expected LocalActivity, received: " + attributes);
        }
        Map map = attributes.getDetailsMap();
        Optional<Payloads> timePayloads = Optional.ofNullable((Payloads)map.get(MARKER_TIME_KEY));
        long time = this.dataConverter.fromPayloads(0, timePayloads, Long.class, (Type)((Object)Long.class));
        this.setCurrentTimeCallback.apply(time);
        if (attributes.hasFailure()) {
            this.callback.apply(null, attributes.getFailure());
            return;
        }
        Optional<Payloads> fromMaker = Optional.ofNullable((Payloads)map.get(MARKER_DATA_KEY));
        this.callback.apply(fromMaker, null);
    }

    private void notifyResultFromResponse() {
        this.callback.apply(this.laResult, this.failure);
    }

    static enum State {
        CREATED,
        REPLAYING,
        EXECUTING,
        REQUEST_PREPARED,
        REQUEST_SENT,
        RESULT_NOTIFIED,
        MARKER_COMMAND_CREATED,
        MARKER_COMMAND_RECORDED,
        WAITING_MARKER_EVENT,
        RESULT_NOTIFIED_REPLAYING;

    }

    static enum ExplicitEvent {
        CHECK_EXECUTION_STATE,
        SCHEDULE,
        MARK_AS_SENT,
        HANDLE_RESULT,
        NON_REPLAY_WORKFLOW_TASK_STARTED;

    }
}

