/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.external;

import com.google.protobuf.ByteString;
import com.uber.m3.tally.Scope;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.temporal.activity.ManualActivityCompletionClient;
import io.temporal.api.common.v1.Payloads;
import io.temporal.api.common.v1.WorkflowExecution;
import io.temporal.api.workflowservice.v1.RecordActivityTaskHeartbeatByIdRequest;
import io.temporal.api.workflowservice.v1.RecordActivityTaskHeartbeatByIdResponse;
import io.temporal.api.workflowservice.v1.RecordActivityTaskHeartbeatRequest;
import io.temporal.api.workflowservice.v1.RecordActivityTaskHeartbeatResponse;
import io.temporal.api.workflowservice.v1.RespondActivityTaskCanceledByIdRequest;
import io.temporal.api.workflowservice.v1.RespondActivityTaskCanceledRequest;
import io.temporal.api.workflowservice.v1.RespondActivityTaskCompletedByIdRequest;
import io.temporal.api.workflowservice.v1.RespondActivityTaskCompletedRequest;
import io.temporal.api.workflowservice.v1.RespondActivityTaskFailedByIdRequest;
import io.temporal.api.workflowservice.v1.RespondActivityTaskFailedRequest;
import io.temporal.api.workflowservice.v1.WorkflowServiceGrpc;
import io.temporal.client.ActivityCanceledException;
import io.temporal.client.ActivityCompletionFailureException;
import io.temporal.client.ActivityNotExistsException;
import io.temporal.common.converter.DataConverter;
import io.temporal.failure.CanceledFailure;
import io.temporal.failure.FailureConverter;
import io.temporal.failure.TemporalFailure;
import io.temporal.internal.common.GrpcRetryer;
import io.temporal.internal.common.OptionsUtils;
import io.temporal.serviceclient.MetricsTag;
import io.temporal.serviceclient.RpcRetryOptions;
import io.temporal.serviceclient.WorkflowServiceStubs;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ManualActivityCompletionClientImpl
implements ManualActivityCompletionClient {
    private static final Logger log = LoggerFactory.getLogger(ManualActivityCompletionClientImpl.class);
    private final WorkflowServiceStubs service;
    private final byte[] taskToken;
    private final DataConverter dataConverter;
    private final String namespace;
    private final WorkflowExecution execution;
    private final String activityId;
    private final Scope metricsScope;

    ManualActivityCompletionClientImpl(WorkflowServiceStubs service, String namespace, byte[] taskToken, DataConverter dataConverter, Scope metricsScope) {
        this.service = service;
        this.taskToken = taskToken;
        this.dataConverter = dataConverter;
        this.namespace = namespace;
        this.execution = null;
        this.activityId = null;
        this.metricsScope = metricsScope;
    }

    ManualActivityCompletionClientImpl(WorkflowServiceStubs service, String namespace, WorkflowExecution execution, String activityId, DataConverter dataConverter, Scope metricsScope) {
        this.service = service;
        this.taskToken = null;
        this.namespace = namespace;
        this.execution = execution;
        this.activityId = activityId;
        this.dataConverter = dataConverter;
        this.metricsScope = metricsScope;
    }

    @Override
    public void complete(Object result) {
        Optional<Payloads> convertedResult = this.dataConverter.toPayloads(result);
        if (this.taskToken != null) {
            RespondActivityTaskCompletedRequest.Builder request = RespondActivityTaskCompletedRequest.newBuilder().setNamespace(this.namespace).setTaskToken(ByteString.copyFrom((byte[])this.taskToken));
            if (convertedResult.isPresent()) {
                request.setResult(convertedResult.get());
            }
            try {
                GrpcRetryer.retry(RpcRetryOptions.newBuilder().buildWithDefaultsFrom(this.service.getOptions().getRpcRetryOptions()), () -> ((WorkflowServiceGrpc.WorkflowServiceBlockingStub)this.service.blockingStub().withOption(MetricsTag.METRICS_TAGS_CALL_OPTIONS_KEY, (Object)this.metricsScope)).respondActivityTaskCompleted(request.build()));
            }
            catch (StatusRuntimeException e) {
                if (e.getStatus().getCode() == Status.Code.NOT_FOUND) {
                    throw new ActivityNotExistsException(e);
                }
                throw new ActivityCompletionFailureException(e);
            }
            catch (Exception e) {
                throw new ActivityCompletionFailureException(e);
            }
        }
        if (this.activityId == null) {
            throw new IllegalArgumentException("Either activity id or task token are required");
        }
        RespondActivityTaskCompletedByIdRequest.Builder request = RespondActivityTaskCompletedByIdRequest.newBuilder().setActivityId(this.activityId).setNamespace(this.namespace).setWorkflowId(this.execution.getWorkflowId()).setRunId(this.execution.getRunId());
        if (convertedResult.isPresent()) {
            request.setResult(convertedResult.get());
        }
        try {
            ((WorkflowServiceGrpc.WorkflowServiceBlockingStub)this.service.blockingStub().withOption(MetricsTag.METRICS_TAGS_CALL_OPTIONS_KEY, (Object)this.metricsScope)).respondActivityTaskCompletedById(request.build());
        }
        catch (StatusRuntimeException e) {
            if (e.getStatus().getCode() == Status.Code.NOT_FOUND) {
                throw new ActivityNotExistsException(this.activityId, (Throwable)e);
            }
            throw new ActivityCompletionFailureException(this.activityId, (Throwable)e);
        }
        catch (Exception e) {
            throw new ActivityCompletionFailureException(this.activityId, (Throwable)e);
        }
    }

    @Override
    public void fail(Throwable exception) {
        if (exception == null) {
            throw new IllegalArgumentException("null exception");
        }
        if (exception instanceof TemporalFailure) {
            ((TemporalFailure)exception).setDataConverter(this.dataConverter);
        }
        if (this.taskToken != null) {
            RespondActivityTaskFailedRequest request = RespondActivityTaskFailedRequest.newBuilder().setFailure(FailureConverter.exceptionToFailure(exception)).setNamespace(this.namespace).setTaskToken(ByteString.copyFrom((byte[])this.taskToken)).build();
            try {
                GrpcRetryer.retry(RpcRetryOptions.newBuilder().buildWithDefaultsFrom(this.service.getOptions().getRpcRetryOptions()), () -> ((WorkflowServiceGrpc.WorkflowServiceBlockingStub)this.service.blockingStub().withOption(MetricsTag.METRICS_TAGS_CALL_OPTIONS_KEY, (Object)this.metricsScope)).respondActivityTaskFailed(request));
            }
            catch (StatusRuntimeException e) {
                if (e.getStatus().getCode() == Status.Code.NOT_FOUND) {
                    throw new ActivityNotExistsException(e);
                }
                throw new ActivityCompletionFailureException(e);
            }
            catch (Exception e) {
                throw new ActivityCompletionFailureException(e);
            }
        }
        if (this.activityId == null) {
            throw new IllegalArgumentException("Either activity id or task token are required");
        }
        RespondActivityTaskFailedByIdRequest request = RespondActivityTaskFailedByIdRequest.newBuilder().setFailure(FailureConverter.exceptionToFailure(exception)).setNamespace(this.namespace).setWorkflowId(this.execution.getWorkflowId()).setRunId(this.execution.getRunId()).setActivityId(this.activityId).build();
        try {
            GrpcRetryer.retry(RpcRetryOptions.newBuilder().buildWithDefaultsFrom(this.service.getOptions().getRpcRetryOptions()), () -> ((WorkflowServiceGrpc.WorkflowServiceBlockingStub)this.service.blockingStub().withOption(MetricsTag.METRICS_TAGS_CALL_OPTIONS_KEY, (Object)this.metricsScope)).respondActivityTaskFailedById(request));
        }
        catch (StatusRuntimeException e) {
            if (e.getStatus().getCode() == Status.Code.NOT_FOUND) {
                throw new ActivityNotExistsException(this.activityId, (Throwable)e);
            }
            throw new ActivityCompletionFailureException(this.activityId, (Throwable)e);
        }
        catch (Exception e) {
            throw new ActivityCompletionFailureException(this.activityId, (Throwable)e);
        }
    }

    @Override
    public void recordHeartbeat(Object details) throws CanceledFailure {
        block13: {
            Optional<Payloads> convertedDetails = this.dataConverter.toPayloads(details);
            if (this.taskToken != null) {
                RecordActivityTaskHeartbeatRequest.Builder request = RecordActivityTaskHeartbeatRequest.newBuilder().setNamespace(this.namespace).setTaskToken(ByteString.copyFrom((byte[])this.taskToken));
                if (convertedDetails.isPresent()) {
                    request.setDetails(convertedDetails.get());
                }
                try {
                    RecordActivityTaskHeartbeatResponse status = ((WorkflowServiceGrpc.WorkflowServiceBlockingStub)this.service.blockingStub().withOption(MetricsTag.METRICS_TAGS_CALL_OPTIONS_KEY, (Object)this.metricsScope)).recordActivityTaskHeartbeat(request.build());
                    if (status.getCancelRequested()) {
                        throw new ActivityCanceledException();
                    }
                    break block13;
                }
                catch (StatusRuntimeException e) {
                    if (e.getStatus().getCode() == Status.Code.NOT_FOUND) {
                        throw new ActivityNotExistsException(this.activityId, (Throwable)e);
                    }
                    throw new ActivityCompletionFailureException(this.activityId, (Throwable)e);
                }
            }
            if (this.activityId == null) {
                throw new IllegalArgumentException("Either activity id or task token are required");
            }
            RecordActivityTaskHeartbeatByIdRequest.Builder request = RecordActivityTaskHeartbeatByIdRequest.newBuilder().setWorkflowId(this.execution.getWorkflowId()).setNamespace(this.namespace).setRunId(this.execution.getRunId()).setActivityId(this.activityId);
            if (convertedDetails.isPresent()) {
                request.setDetails(convertedDetails.get());
            }
            RecordActivityTaskHeartbeatByIdResponse status = null;
            try {
                status = ((WorkflowServiceGrpc.WorkflowServiceBlockingStub)this.service.blockingStub().withOption(MetricsTag.METRICS_TAGS_CALL_OPTIONS_KEY, (Object)this.metricsScope)).recordActivityTaskHeartbeatById(request.build());
                if (status.getCancelRequested()) {
                    throw new ActivityCanceledException();
                }
            }
            catch (StatusRuntimeException e) {
                if (e.getStatus().getCode() == Status.Code.NOT_FOUND) {
                    throw new ActivityNotExistsException(this.activityId, (Throwable)e);
                }
                throw new ActivityCompletionFailureException(this.activityId, (Throwable)e);
            }
            catch (Exception e) {
                throw new ActivityCompletionFailureException(this.activityId, (Throwable)e);
            }
        }
    }

    @Override
    public void reportCancellation(Object details) {
        Optional<Payloads> convertedDetails = this.dataConverter.toPayloads(details);
        if (this.taskToken != null) {
            RespondActivityTaskCanceledRequest.Builder request = RespondActivityTaskCanceledRequest.newBuilder().setNamespace(this.namespace).setTaskToken(ByteString.copyFrom((byte[])this.taskToken));
            if (convertedDetails.isPresent()) {
                request.setDetails(convertedDetails.get());
            }
            try {
                GrpcRetryer.retry(RpcRetryOptions.newBuilder().buildWithDefaultsFrom(this.service.getOptions().getRpcRetryOptions()), () -> ((WorkflowServiceGrpc.WorkflowServiceBlockingStub)this.service.blockingStub().withOption(MetricsTag.METRICS_TAGS_CALL_OPTIONS_KEY, (Object)this.metricsScope)).respondActivityTaskCanceled(request.build()));
            }
            catch (Exception e) {
                log.info("reportCancellation", (Throwable)e);
            }
        } else {
            if (this.activityId == null) {
                throw new IllegalArgumentException("Either activity id or task token are required");
            }
            RespondActivityTaskCanceledByIdRequest.Builder request = RespondActivityTaskCanceledByIdRequest.newBuilder().setNamespace(this.namespace).setWorkflowId(this.execution.getWorkflowId()).setRunId(OptionsUtils.safeGet(this.execution.getRunId())).setActivityId(this.activityId);
            if (convertedDetails.isPresent()) {
                request.setDetails(convertedDetails.get());
            }
            try {
                GrpcRetryer.retry(RpcRetryOptions.newBuilder().buildWithDefaultsFrom(this.service.getOptions().getRpcRetryOptions()), () -> ((WorkflowServiceGrpc.WorkflowServiceBlockingStub)this.service.blockingStub().withOption(MetricsTag.METRICS_TAGS_CALL_OPTIONS_KEY, (Object)this.metricsScope)).respondActivityTaskCanceledById(request.build()));
            }
            catch (Exception e) {
                log.warn("reportCancellation", (Throwable)e);
            }
        }
    }
}

