/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.activity;

import com.google.common.base.Objects;
import io.temporal.common.MethodRetry;
import io.temporal.common.RetryOptions;
import java.time.Duration;

public final class LocalActivityOptions {
    private static final LocalActivityOptions DEFAULT_INSTANCE = LocalActivityOptions.newBuilder().build();
    private final Duration scheduleToCloseTimeout;
    private final Duration localRetryThreshold;
    private final Duration startToCloseTimeout;
    private final RetryOptions retryOptions;

    public static Builder newBuilder() {
        return new Builder(null);
    }

    public static Builder newBuilder(LocalActivityOptions o) {
        return new Builder(o);
    }

    public static LocalActivityOptions getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    private LocalActivityOptions(Duration startToCloseTimeout, Duration localRetryThreshold, Duration scheduleToCloseTimeout, RetryOptions retryOptions) {
        this.localRetryThreshold = localRetryThreshold;
        this.scheduleToCloseTimeout = scheduleToCloseTimeout;
        this.startToCloseTimeout = startToCloseTimeout;
        this.retryOptions = retryOptions;
    }

    public Duration getScheduleToCloseTimeout() {
        return this.scheduleToCloseTimeout;
    }

    public Duration getLocalRetryThreshold() {
        return this.localRetryThreshold;
    }

    public Duration getStartToCloseTimeout() {
        return this.startToCloseTimeout;
    }

    public RetryOptions getRetryOptions() {
        return this.retryOptions;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocalActivityOptions that = (LocalActivityOptions)o;
        return Objects.equal((Object)this.scheduleToCloseTimeout, (Object)that.scheduleToCloseTimeout) && Objects.equal((Object)this.startToCloseTimeout, (Object)that.startToCloseTimeout) && Objects.equal((Object)this.retryOptions, (Object)that.retryOptions);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.scheduleToCloseTimeout, this.startToCloseTimeout, this.retryOptions});
    }

    public String toString() {
        return "LocalActivityOptions{scheduleToCloseTimeout=" + this.scheduleToCloseTimeout + ", startToCloseTimeout=" + this.startToCloseTimeout + ", retryOptions=" + this.retryOptions + '}';
    }

    public static final class Builder {
        private Duration scheduleToCloseTimeout;
        private Duration localRetryThreshold;
        private Duration startToCloseTimeout;
        private RetryOptions retryOptions;

        private Builder(LocalActivityOptions options) {
            if (options == null) {
                return;
            }
            this.scheduleToCloseTimeout = options.getScheduleToCloseTimeout();
            this.localRetryThreshold = options.getLocalRetryThreshold();
            this.startToCloseTimeout = options.getStartToCloseTimeout();
            this.retryOptions = options.retryOptions;
        }

        public Builder setScheduleToCloseTimeout(Duration timeout) {
            if (timeout.isZero() || timeout.isNegative()) {
                throw new IllegalArgumentException("Illegal timeout: " + timeout);
            }
            this.scheduleToCloseTimeout = timeout;
            return this;
        }

        public Builder setLocalRetryThreshold(Duration localRetryThreshold) {
            if (localRetryThreshold.isZero() || localRetryThreshold.isNegative()) {
                throw new IllegalArgumentException("Illegal threshold: " + localRetryThreshold);
            }
            this.localRetryThreshold = localRetryThreshold;
            return this;
        }

        public Builder setStartToCloseTimeout(Duration timeout) {
            if (timeout.isZero() || timeout.isNegative()) {
                throw new IllegalArgumentException("Illegal timeout: " + timeout);
            }
            this.startToCloseTimeout = timeout;
            return this;
        }

        public Builder setRetryOptions(RetryOptions retryOptions) {
            this.retryOptions = retryOptions;
            return this;
        }

        public Builder setMethodRetry(MethodRetry r) {
            if (r != null) {
                this.retryOptions = RetryOptions.merge(r, this.retryOptions);
            }
            return this;
        }

        public LocalActivityOptions build() {
            return new LocalActivityOptions(this.startToCloseTimeout, this.localRetryThreshold, this.scheduleToCloseTimeout, this.retryOptions);
        }

        public LocalActivityOptions validateAndBuildWithDefaults() {
            if (this.startToCloseTimeout == null && this.scheduleToCloseTimeout == null) {
                throw new IllegalArgumentException("one of the startToCloseTimeout or scheduleToCloseTimeout is required");
            }
            return new LocalActivityOptions(this.startToCloseTimeout, this.localRetryThreshold, this.scheduleToCloseTimeout, RetryOptions.newBuilder(this.retryOptions).validateBuildWithDefaults());
        }
    }
}

