/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.opentracing;

import com.google.common.base.MoreObjects;
import io.opentracing.Tracer;
import io.opentracing.util.GlobalTracer;
import io.temporal.opentracing.OpenTracingSpanContextCodec;
import io.temporal.opentracing.SpanBuilderProvider;
import io.temporal.opentracing.internal.ActionTypeAndNameSpanBuilderProvider;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class OpenTracingOptions {
    private static final OpenTracingOptions DEFAULT_INSTANCE = OpenTracingOptions.newBuilder().build();
    private final Tracer tracer;
    private final SpanBuilderProvider spanBuilderProvider;
    private final OpenTracingSpanContextCodec spanContextCodec;
    private final Predicate<Throwable> isErrorPredicate;

    public static OpenTracingOptions getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    private OpenTracingOptions(Tracer tracer, SpanBuilderProvider spanBuilderProvider, OpenTracingSpanContextCodec spanContextCodec, Predicate<Throwable> isErrorPredicate) {
        if (tracer == null) {
            throw new IllegalArgumentException("tracer shouldn't be null");
        }
        this.tracer = tracer;
        this.spanBuilderProvider = spanBuilderProvider;
        this.spanContextCodec = spanContextCodec;
        this.isErrorPredicate = isErrorPredicate;
    }

    @Nonnull
    public Tracer getTracer() {
        return this.tracer;
    }

    @Nonnull
    public SpanBuilderProvider getSpanBuilderProvider() {
        return this.spanBuilderProvider;
    }

    @Nonnull
    public OpenTracingSpanContextCodec getSpanContextCodec() {
        return this.spanContextCodec;
    }

    @Nonnull
    public Predicate<Throwable> getIsErrorPredicate() {
        return this.isErrorPredicate;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private Tracer tracer;
        private SpanBuilderProvider spanBuilderProvider = ActionTypeAndNameSpanBuilderProvider.INSTANCE;
        private OpenTracingSpanContextCodec spanContextCodec = OpenTracingSpanContextCodec.TEXT_MAP_INJECT_EXTRACT_CODEC;
        private Predicate<Throwable> isErrorPredicate = t -> true;

        private Builder() {
        }

        public Builder setTracer(@Nullable Tracer tracer) {
            this.tracer = tracer;
            return this;
        }

        public Builder setSpanBuilderProvider(@Nonnull SpanBuilderProvider spanBuilderProvider) {
            Objects.requireNonNull(spanBuilderProvider, "spanBuilderProvider can't be null");
            this.spanBuilderProvider = spanBuilderProvider;
            return this;
        }

        public Builder setSpanContextCodec(@Nonnull OpenTracingSpanContextCodec spanContextCodec) {
            Objects.requireNonNull(spanContextCodec, "spanContextCodec can't be null");
            this.spanContextCodec = spanContextCodec;
            return this;
        }

        public Builder setIsErrorPredicate(@Nonnull Predicate<Throwable> isErrorPredicate) {
            Objects.requireNonNull(isErrorPredicate, "isErrorPredicate can't be null");
            this.isErrorPredicate = isErrorPredicate;
            return this;
        }

        public OpenTracingOptions build() {
            return new OpenTracingOptions((Tracer)MoreObjects.firstNonNull((Object)this.tracer, (Object)GlobalTracer.get()), this.spanBuilderProvider, this.spanContextCodec, this.isErrorPredicate);
        }
    }
}

