/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.opentracing.internal;

import com.google.common.base.MoreObjects;
import com.google.common.base.Throwables;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.tag.Tag;
import io.opentracing.tag.Tags;
import io.temporal.opentracing.OpenTracingOptions;
import io.temporal.opentracing.SpanCreationContext;
import io.temporal.opentracing.SpanOperationType;
import java.util.HashMap;
import javax.annotation.Nullable;

public class SpanFactory {
    private final OpenTracingOptions options;

    public SpanFactory(OpenTracingOptions options) {
        this.options = options;
    }

    public Tracer.SpanBuilder createWorkflowStartSpan(Tracer tracer, SpanOperationType operationType, String workflowType, String workflowId) {
        SpanCreationContext context = SpanCreationContext.newBuilder().setSpanOperationType(operationType).setActionName(workflowType).setWorkflowId(workflowId).build();
        return this.createSpan(context, tracer, null, "follows_from");
    }

    public Tracer.SpanBuilder createChildWorkflowStartSpan(Tracer tracer, String childWorkflowType, String childWorkflowId, long startTimeMs, String parentWorkflowId, String parentRunId) {
        SpanCreationContext context = SpanCreationContext.newBuilder().setSpanOperationType(SpanOperationType.START_CHILD_WORKFLOW).setActionName(childWorkflowType).setWorkflowId(childWorkflowId).setParentWorkflowId(parentWorkflowId).setParentRunId(parentRunId).build();
        return this.createSpan(context, tracer, null, "child_of");
    }

    public Tracer.SpanBuilder createContinueAsNewWorkflowStartSpan(Tracer tracer, String continueAsNewWorkflowType, String workflowId, String parentRunId) {
        SpanCreationContext context = SpanCreationContext.newBuilder().setSpanOperationType(SpanOperationType.START_CONTINUE_AS_NEW_WORKFLOW).setActionName(continueAsNewWorkflowType).setWorkflowId(workflowId).setParentRunId(parentRunId).build();
        return this.createSpan(context, tracer, null, "follows_from");
    }

    public Tracer.SpanBuilder createWorkflowRunSpan(Tracer tracer, String workflowType, String workflowId, String runId, SpanContext workflowStartSpanContext) {
        SpanCreationContext context = SpanCreationContext.newBuilder().setSpanOperationType(SpanOperationType.RUN_WORKFLOW).setActionName(workflowType).setWorkflowId(workflowId).setRunId(runId).build();
        return this.createSpan(context, tracer, workflowStartSpanContext, "follows_from");
    }

    public Tracer.SpanBuilder createActivityStartSpan(Tracer tracer, String activityType, String workflowId, String runId) {
        SpanCreationContext context = SpanCreationContext.newBuilder().setSpanOperationType(SpanOperationType.START_ACTIVITY).setActionName(activityType).setWorkflowId(workflowId).setRunId(runId).build();
        return this.createSpan(context, tracer, null, "child_of");
    }

    public Tracer.SpanBuilder createActivityRunSpan(Tracer tracer, String activityType, String workflowId, String runId, SpanContext activityStartSpanContext) {
        SpanCreationContext context = SpanCreationContext.newBuilder().setSpanOperationType(SpanOperationType.RUN_ACTIVITY).setActionName(activityType).setWorkflowId(workflowId).setRunId(runId).build();
        return this.createSpan(context, tracer, activityStartSpanContext, "follows_from");
    }

    public void logFail(Span toSpan, Throwable failReason) {
        toSpan.setTag("failed", true);
        toSpan.setTag((Tag)Tags.ERROR, (Object)this.options.getIsErrorPredicate().test(failReason));
        HashMap<String, Object> logPayload = new HashMap<String, Object>();
        logPayload.put("event", "error");
        logPayload.put("error.kind", failReason.getClass().getName());
        logPayload.put("error.object", failReason);
        logPayload.put("stack", Throwables.getStackTraceAsString((Throwable)failReason));
        String message = failReason.getMessage();
        if (message != null) {
            logPayload.put("message", message);
        }
        toSpan.log(System.currentTimeMillis(), logPayload);
    }

    public void logEviction(Span toSpan) {
        toSpan.setTag("evicted", true);
    }

    private Tracer.SpanBuilder createSpan(SpanCreationContext context, Tracer tracer, @Nullable SpanContext parentSpanContext, @Nullable String parentReferenceType) {
        Span activeSpan = tracer.activeSpan();
        SpanContext parent = activeSpan != null ? activeSpan.context() : parentSpanContext;
        Tracer.SpanBuilder builder = this.options.getSpanBuilderProvider().createSpanBuilder(tracer, context);
        if (parent != null) {
            builder.addReference((String)MoreObjects.firstNonNull((Object)parentReferenceType, (Object)"follows_from"), parent);
        }
        return builder;
    }
}

