/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.opentracing.internal;

import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.temporal.activity.ActivityExecutionContext;
import io.temporal.activity.ActivityInfo;
import io.temporal.common.interceptors.ActivityInboundCallsInterceptor;
import io.temporal.common.interceptors.ActivityInboundCallsInterceptorBase;
import io.temporal.opentracing.OpenTracingOptions;
import io.temporal.opentracing.internal.ContextAccessor;
import io.temporal.opentracing.internal.SpanFactory;

public class OpenTracingActivityInboundCallsInterceptor
extends ActivityInboundCallsInterceptorBase {
    private final OpenTracingOptions options;
    private final SpanFactory spanFactory;
    private final Tracer tracer;
    private final ContextAccessor contextAccessor;
    private ActivityExecutionContext activityExecutionContext;

    public OpenTracingActivityInboundCallsInterceptor(ActivityInboundCallsInterceptor next, OpenTracingOptions options, SpanFactory spanFactory, ContextAccessor contextAccessor) {
        super(next);
        this.options = options;
        this.spanFactory = spanFactory;
        this.tracer = options.getTracer();
        this.contextAccessor = contextAccessor;
    }

    public void init(ActivityExecutionContext context) {
        this.activityExecutionContext = context;
        super.init(context);
    }

    public ActivityInboundCallsInterceptor.ActivityOutput execute(ActivityInboundCallsInterceptor.ActivityInput input) {
        SpanContext rootSpanContext = this.contextAccessor.readSpanContextFromHeader(input.getHeader(), this.tracer);
        ActivityInfo activityInfo = this.activityExecutionContext.getInfo();
        Span activityRunSpan = this.spanFactory.createActivityRunSpan(this.tracer, activityInfo.getActivityType(), activityInfo.getWorkflowId(), activityInfo.getRunId(), rootSpanContext).start();
        try {
            ActivityInboundCallsInterceptor.ActivityOutput activityOutput;
            block11: {
                Scope scope = this.tracer.scopeManager().activate(activityRunSpan);
                try {
                    activityOutput = super.execute(input);
                    if (scope == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (scope != null) {
                            try {
                                scope.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable t) {
                        this.spanFactory.logFail(activityRunSpan, t);
                        throw t;
                    }
                }
                scope.close();
            }
            return activityOutput;
        }
        finally {
            activityRunSpan.finish();
        }
    }
}

