/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.maven.polyglot;

import java.io.File;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.building.ModelProblem;
import org.apache.maven.model.building.ModelSource;
import org.apache.maven.project.DefaultProjectBuilder;
import org.apache.maven.project.DependencyResolutionResult;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingResult;
import org.sonatype.maven.polyglot.TeslaModelProcessor;

@Singleton
@Named
public class TeslaProjectBuilder
extends DefaultProjectBuilder {
    @Inject
    private TeslaModelProcessor teslaModelProcessor;

    public ProjectBuildingResult build(File pomFile, ProjectBuildingRequest request) throws ProjectBuildingException {
        return this.convert(super.build(pomFile, request));
    }

    public ProjectBuildingResult build(ModelSource modelSource, ProjectBuildingRequest request) throws ProjectBuildingException {
        return this.convert(super.build(modelSource, request));
    }

    public ProjectBuildingResult build(Artifact artifact, ProjectBuildingRequest request) throws ProjectBuildingException {
        return this.convert(super.build(artifact, request));
    }

    public ProjectBuildingResult build(Artifact artifact, boolean allowStubModel, ProjectBuildingRequest request) throws ProjectBuildingException {
        return this.convert(super.build(artifact, allowStubModel, request));
    }

    public List<ProjectBuildingResult> build(List<File> pomFiles, boolean recursive, ProjectBuildingRequest request) throws ProjectBuildingException {
        List results = super.build(pomFiles, recursive, request);
        return results.stream().map(this::convert).collect(Collectors.toList());
    }

    private ProjectBuildingResult convert(ProjectBuildingResult result) {
        if (result.getPomFile() == null) {
            return result;
        }
        String projectId = result.getProjectId();
        MavenProject project = result.getProject();
        List problems = result.getProblems();
        DependencyResolutionResult dependencyResolutionResult = result.getDependencyResolutionResult();
        File pomFile = this.teslaModelProcessor.getPomXmlFile(result.getPomFile()).orElse(result.getPomFile());
        project.setPomFile(pomFile);
        project.getModel().setPomFile(pomFile);
        return new TeslaProjectBuildingResult(projectId, pomFile, project, problems, dependencyResolutionResult);
    }

    private static class TeslaProjectBuildingResult
    implements ProjectBuildingResult {
        private final String projectId;
        private final File pomFile;
        private final MavenProject project;
        private final List<ModelProblem> problems;
        private final DependencyResolutionResult dependencyResolutionResult;

        public TeslaProjectBuildingResult(String projectId, File pomFile, MavenProject project, List<ModelProblem> problems, DependencyResolutionResult dependencyResolutionResult) {
            this.projectId = projectId;
            this.pomFile = pomFile;
            this.project = project;
            this.problems = problems;
            this.dependencyResolutionResult = dependencyResolutionResult;
        }

        public String getProjectId() {
            return this.projectId;
        }

        public File getPomFile() {
            return this.pomFile;
        }

        public MavenProject getProject() {
            return this.project;
        }

        public List<ModelProblem> getProblems() {
            return this.problems;
        }

        public DependencyResolutionResult getDependencyResolutionResult() {
            return this.dependencyResolutionResult;
        }
    }
}

